/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture;

import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.spi.DDSImage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;
import jogamp.opengl.Debug;

public class Texture {
    private int target;
    private int texID;
    private int texWidth;
    private int texHeight;
    private int imgWidth;
    private int imgHeight;
    private float aspectRatio;
    private boolean mustFlipVertically;
    private boolean usingAutoMipmapGeneration;
    private TextureCoords coords;
    private int estimatedMemorySize;
    private static final AccessControlContext localACC = AccessController.getContext();
    private static final boolean DEBUG = Debug.debug("Texture");
    private static final boolean VERBOSE = Debug.verbose();
    private static final boolean disableNPOT = Debug.isPropertyDefined("jogl.texture.nonpot", true, localACC);
    private static final boolean disableTexRect = Debug.isPropertyDefined("jogl.texture.notexrect", true, localACC);

    public Texture(GL gL, TextureData textureData) throws GLException {
        this.texID = 0;
        this.updateImage(gL, textureData);
    }

    public Texture(int n) {
        this.texID = 0;
        this.target = n;
    }

    Texture(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.texID = n;
        this.target = n2;
        this.mustFlipVertically = bl;
        this.texWidth = n3;
        this.texHeight = n4;
        this.setImageSize(n5, n6, n2);
    }

    public void enable(GL gL) throws GLException {
        gL.glEnable(this.target);
    }

    public void disable(GL gL) throws GLException {
        gL.glDisable(this.target);
    }

    public void bind(GL gL) throws GLException {
        this.validateTexID(gL, true);
        gL.glBindTexture(this.target, this.texID);
    }

    public final void dispose(GL gL) throws GLException {
        this.destroy(gL);
    }

    public void destroy(GL gL) throws GLException {
        if (0 != this.texID) {
            gL.glDeleteTextures(1, new int[]{this.texID}, 0);
            this.texID = 0;
        }
    }

    public int getTarget() {
        return this.target;
    }

    public int getWidth() {
        return this.texWidth;
    }

    public int getHeight() {
        return this.texHeight;
    }

    public int getImageWidth() {
        return this.imgWidth;
    }

    public int getImageHeight() {
        return this.imgHeight;
    }

    public float getAspectRatio() {
        return this.aspectRatio;
    }

    public TextureCoords getImageTexCoords() {
        return this.coords;
    }

    public TextureCoords getSubImageTexCoords(int n, int n2, int n3, int n4) {
        if (this.target == 34037) {
            if (this.mustFlipVertically) {
                return new TextureCoords(n, this.texHeight - n2, n3, this.texHeight - n4);
            }
            return new TextureCoords(n, n2, n3, n4);
        }
        float f = (float)n / (float)this.texWidth;
        float f2 = (float)n2 / (float)this.texHeight;
        float f3 = (float)n3 / (float)this.texWidth;
        float f4 = (float)n4 / (float)this.texHeight;
        if (this.mustFlipVertically) {
            float f5 = (float)this.imgHeight / (float)this.texHeight;
            return new TextureCoords(f, f5 - f2, f3, f5 - f4);
        }
        return new TextureCoords(f, f2, f3, f4);
    }

    public void updateImage(GL gL, TextureData textureData) throws GLException {
        this.updateImage(gL, textureData, 0);
    }

    public boolean getMustFlipVertically() {
        return this.mustFlipVertically;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateImage(GL gL, TextureData textureData, int n) throws GLException {
        int n2;
        Object[] objectArray;
        boolean bl;
        this.validateTexID(gL, true);
        this.imgWidth = textureData.getWidth();
        this.imgHeight = textureData.getHeight();
        this.aspectRatio = (float)this.imgWidth / (float)this.imgHeight;
        this.mustFlipVertically = textureData.getMustFlipVertically();
        int n3 = 0;
        int n4 = this.target;
        boolean bl2 = gL.isExtensionAvailable("GL_VERSION_1_4") || gL.isExtensionAvailable("GL_SGIS_generate_mipmap");
        textureData.setHaveEXTABGR(gL.isExtensionAvailable("GL_EXT_abgr"));
        textureData.setHaveGL12(gL.isExtensionAvailable("GL_VERSION_1_2"));
        boolean bl3 = bl = Texture.isPowerOfTwo(this.imgWidth) && Texture.isPowerOfTwo(this.imgHeight);
        if (!bl && !Texture.haveNPOT(gL)) {
            bl2 = false;
        }
        boolean bl4 = false;
        boolean bl5 = false;
        if (textureData.getMipmap() && !bl2) {
            this.imgWidth = Texture.nextPowerOfTwo(this.imgWidth);
            this.imgHeight = Texture.nextPowerOfTwo(this.imgHeight);
            this.texWidth = this.imgWidth;
            this.texHeight = this.imgHeight;
            n3 = 3553;
            bl5 = true;
        }
        if (!(bl5 || !Texture.preferTexRect(gL) || bl || !Texture.haveTexRect(gL) || textureData.isDataCompressed() || gL.isGL3() || gL.isGLES())) {
            if (DEBUG) {
                System.err.println("Using GL_ARB_texture_rectangle preferentially on this hardware");
            }
            this.texWidth = this.imgWidth;
            this.texHeight = this.imgHeight;
            n3 = 34037;
            bl5 = true;
        }
        if (!bl5 && (bl || Texture.haveNPOT(gL))) {
            if (DEBUG) {
                if (bl) {
                    System.err.println("Power-of-two texture");
                } else {
                    System.err.println("Using GL_ARB_texture_non_power_of_two");
                }
            }
            this.texWidth = this.imgWidth;
            this.texHeight = this.imgHeight;
            n3 = 3553;
            bl5 = true;
        }
        if (!(bl5 || !Texture.haveTexRect(gL) || textureData.isDataCompressed() || gL.isGL3() || gL.isGLES())) {
            if (DEBUG) {
                System.err.println("Using GL_ARB_texture_rectangle");
            }
            this.texWidth = this.imgWidth;
            this.texHeight = this.imgHeight;
            n3 = 34037;
            bl5 = true;
        }
        if (!bl5) {
            if (textureData.isDataCompressed()) {
                if (textureData.getMipmapData() != null) {
                    throw new GLException("Mipmapped non-power-of-two compressed textures only supported on OpenGL 2.0 hardware (GL_ARB_texture_non_power_of_two)");
                }
                bl4 = true;
            }
            if (DEBUG) {
                System.err.println("Expanding texture to power-of-two dimensions");
            }
            if (textureData.getBorder() != 0) {
                throw new RuntimeException("Scaling up a non-power-of-two texture which has a border won't work");
            }
            this.texWidth = Texture.nextPowerOfTwo(this.imgWidth);
            this.texHeight = Texture.nextPowerOfTwo(this.imgHeight);
            n3 = 3553;
        }
        n4 = n3;
        this.setImageSize(this.imgWidth, this.imgHeight, n3);
        if (n != 0) {
            n3 = n;
            if (this.target == 0) {
                throw new GLException("Override of target failed; no target specified yet");
            }
            n4 = this.target;
            gL.glBindTexture(n4, this.texID);
        } else {
            gL.glBindTexture(n3, this.texID);
        }
        if (textureData.getMipmap() && !bl2) {
            objectArray = new int[1];
            gL.glGetIntegerv(3317, (int[])objectArray, 0);
            gL.glPixelStorei(3317, textureData.getAlignment());
            if (textureData.isDataCompressed()) {
                throw new GLException("May not request mipmap generation for compressed textures");
            }
            try {
                GLU gLU = GLU.createGLU(gL);
                gLU.gluBuild2DMipmaps(n3, textureData.getInternalFormat(), textureData.getWidth(), textureData.getHeight(), textureData.getPixelFormat(), textureData.getPixelType(), textureData.getBuffer());
            }
            finally {
                gL.glPixelStorei(3317, objectArray[0]);
            }
        } else {
            this.checkCompressedTextureExtensions(gL, textureData);
            objectArray = textureData.getMipmapData();
            if (objectArray != null) {
                int n5 = this.texWidth;
                n2 = this.texHeight;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (textureData.isDataCompressed()) {
                        gL.glCompressedTexImage2D(n3, i, textureData.getInternalFormat(), n5, n2, textureData.getBorder(), objectArray[i].remaining(), (Buffer)objectArray[i]);
                    } else {
                        gL.glTexImage2D(n3, i, textureData.getInternalFormat(), n5, n2, textureData.getBorder(), textureData.getPixelFormat(), textureData.getPixelType(), null);
                        this.updateSubImageImpl(gL, textureData, n3, i, 0, 0, 0, 0, textureData.getWidth(), textureData.getHeight());
                    }
                    n5 = Math.max(n5 / 2, 1);
                    n2 = Math.max(n2 / 2, 1);
                }
            } else if (textureData.isDataCompressed()) {
                if (!bl4) {
                    gL.glCompressedTexImage2D(n3, 0, textureData.getInternalFormat(), this.texWidth, this.texHeight, textureData.getBorder(), textureData.getBuffer().capacity(), textureData.getBuffer());
                } else {
                    ByteBuffer byteBuffer = DDSImage.allocateBlankBuffer(this.texWidth, this.texHeight, textureData.getInternalFormat());
                    gL.glCompressedTexImage2D(n3, 0, textureData.getInternalFormat(), this.texWidth, this.texHeight, textureData.getBorder(), byteBuffer.capacity(), byteBuffer);
                    this.updateSubImageImpl(gL, textureData, n3, 0, 0, 0, 0, 0, textureData.getWidth(), textureData.getHeight());
                }
            } else {
                if (textureData.getMipmap() && bl2 && gL.isGL2ES1()) {
                    gL.glTexParameteri(n4, 33169, 1);
                    this.usingAutoMipmapGeneration = true;
                }
                gL.glTexImage2D(n3, 0, textureData.getInternalFormat(), this.texWidth, this.texHeight, textureData.getBorder(), textureData.getPixelFormat(), textureData.getPixelType(), null);
                this.updateSubImageImpl(gL, textureData, n3, 0, 0, 0, 0, 0, textureData.getWidth(), textureData.getHeight());
            }
        }
        int n6 = textureData.getMipmap() ? 9987 : 9729;
        int n7 = 9729;
        int n8 = n2 = gL.isExtensionAvailable("GL_VERSION_1_2") || !gL.isGL2() ? 33071 : 10496;
        if (n3 != 34037) {
            gL.glTexParameteri(n4, 10241, n6);
            gL.glTexParameteri(n4, 10240, n7);
            gL.glTexParameteri(n4, 10242, n2);
            gL.glTexParameteri(n4, 10243, n2);
            if (this.target == 34067) {
                gL.glTexParameteri(n4, 32882, n2);
            }
        }
        if (this.target == 0 || this.target == 3553 || this.target == 34037) {
            this.target = n3;
        }
        this.estimatedMemorySize = textureData.getEstimatedMemorySize();
    }

    public void updateSubImage(GL gL, TextureData textureData, int n, int n2, int n3) throws GLException {
        if (this.usingAutoMipmapGeneration && n != 0) {
            return;
        }
        this.bind(gL);
        this.updateSubImageImpl(gL, textureData, this.target, n, n2, n3, 0, 0, textureData.getWidth(), textureData.getHeight());
    }

    public void updateSubImage(GL gL, TextureData textureData, int n, int n2, int n3, int n4, int n5, int n6, int n7) throws GLException {
        if (textureData.isDataCompressed()) {
            throw new GLException("updateSubImage specifying a sub-rectangle is not supported for compressed TextureData");
        }
        if (this.usingAutoMipmapGeneration && n != 0) {
            return;
        }
        this.bind(gL);
        this.updateSubImageImpl(gL, textureData, this.target, n, n2, n3, n4, n5, n6, n7);
    }

    public void setTexParameterf(GL gL, int n, float f) {
        this.bind(gL);
        gL.glTexParameterf(this.target, n, f);
    }

    public void setTexParameterfv(GL gL, int n, FloatBuffer floatBuffer) {
        this.bind(gL);
        gL.glTexParameterfv(this.target, n, floatBuffer);
    }

    public void setTexParameterfv(GL gL, int n, float[] fArray, int n2) {
        this.bind(gL);
        gL.glTexParameterfv(this.target, n, fArray, n2);
    }

    public void setTexParameteri(GL gL, int n, int n2) {
        this.bind(gL);
        gL.glTexParameteri(this.target, n, n2);
    }

    public void setTexParameteriv(GL gL, int n, IntBuffer intBuffer) {
        this.bind(gL);
        gL.glTexParameteriv(this.target, n, intBuffer);
    }

    public void setTexParameteriv(GL gL, int n, int[] nArray, int n2) {
        this.bind(gL);
        gL.glTexParameteriv(this.target, n, nArray, n2);
    }

    public int getTextureObject(GL gL) {
        this.validateTexID(gL, false);
        return this.texID;
    }

    public int getEstimatedMemorySize() {
        return this.estimatedMemorySize;
    }

    public boolean isUsingAutoMipmapGeneration() {
        return this.usingAutoMipmapGeneration;
    }

    private static boolean isPowerOfTwo(int n) {
        return (n & n - 1) == 0;
    }

    private static int nextPowerOfTwo(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    private void setImageSize(int n, int n2, int n3) {
        this.imgWidth = n;
        this.imgHeight = n2;
        this.coords = n3 == 34037 ? (this.mustFlipVertically ? new TextureCoords(0.0f, this.imgHeight, this.imgWidth, 0.0f) : new TextureCoords(0.0f, 0.0f, this.imgWidth, this.imgHeight)) : (this.mustFlipVertically ? new TextureCoords(0.0f, (float)this.imgHeight / (float)this.texHeight, (float)this.imgWidth / (float)this.texWidth, 0.0f) : new TextureCoords(0.0f, 0.0f, (float)this.imgWidth / (float)this.texWidth, (float)this.imgHeight / (float)this.texHeight));
    }

    private void updateSubImageImpl(GL gL, TextureData textureData, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws GLException {
        textureData.setHaveEXTABGR(gL.isExtensionAvailable("GL_EXT_abgr"));
        textureData.setHaveGL12(gL.isExtensionAvailable("GL_VERSION_1_2"));
        Buffer buffer = textureData.getBuffer();
        if (buffer == null && textureData.getMipmapData() == null) {
            return;
        }
        int n9 = textureData.getRowLength();
        int n10 = textureData.getWidth();
        int n11 = textureData.getHeight();
        if (textureData.getMipmapData() != null) {
            for (int i = 0; i < n2; ++i) {
                n7 = Math.max(n7 / 2, 1);
                n8 = Math.max(n8 / 2, 1);
                n10 = Math.max(n10 / 2, 1);
                n11 = Math.max(n11 / 2, 1);
            }
            n9 = 0;
            buffer = textureData.getMipmapData()[n2];
        }
        if (n5 < 0) {
            n7 += n5;
            n5 = 0;
        }
        if (n6 < 0) {
            n8 += n6;
            n6 = 0;
        }
        if (n3 < 0) {
            n7 += n3;
            n3 = 0;
        }
        if (n4 < 0) {
            n8 += n4;
            n4 = 0;
        }
        if (n5 + n7 > n10) {
            n7 = n10 - n5;
        }
        if (n6 + n8 > n11) {
            n8 = n11 - n6;
        }
        if (n3 + n7 > this.texWidth) {
            n7 = this.texWidth - n3;
        }
        if (n4 + n8 > this.texHeight) {
            n8 = this.texHeight - n4;
        }
        this.checkCompressedTextureExtensions(gL, textureData);
        if (textureData.isDataCompressed()) {
            gL.glCompressedTexSubImage2D(n, n2, n3, n4, n7, n8, textureData.getInternalFormat(), buffer.remaining(), buffer);
        } else {
            int[] nArray = new int[]{0};
            int[] nArray2 = new int[]{0};
            int[] nArray3 = new int[]{0};
            int[] nArray4 = new int[]{0};
            gL.glGetIntegerv(3317, nArray, 0);
            if (gL.isGL2GL3()) {
                gL.glGetIntegerv(3314, nArray2, 0);
                gL.glGetIntegerv(3315, nArray3, 0);
                gL.glGetIntegerv(3316, nArray4, 0);
            }
            gL.glPixelStorei(3317, textureData.getAlignment());
            if (DEBUG && VERBOSE) {
                System.out.println("Row length  = " + n9);
                System.out.println("skip pixels = " + n5);
                System.out.println("skip rows   = " + n6);
                System.out.println("dstx        = " + n3);
                System.out.println("dsty        = " + n4);
                System.out.println("width       = " + n7);
                System.out.println("height      = " + n8);
            }
            if (gL.isGL2GL3()) {
                gL.glPixelStorei(3314, n9);
                gL.glPixelStorei(3315, n6);
                gL.glPixelStorei(3316, n5);
            } else if (n9 != 0 && n9 != n7 && n6 != 0 && n5 != 0) {
                throw new GLException("rowlen and/or x/y offset only available for GL2");
            }
            gL.glTexSubImage2D(n, n2, n3, n4, n7, n8, textureData.getPixelFormat(), textureData.getPixelType(), buffer);
            gL.glPixelStorei(3317, nArray[0]);
            if (gL.isGL2GL3()) {
                gL.glPixelStorei(3314, nArray2[0]);
                gL.glPixelStorei(3315, nArray3[0]);
                gL.glPixelStorei(3316, nArray4[0]);
            }
        }
    }

    private void checkCompressedTextureExtensions(GL gL, TextureData textureData) {
        if (textureData.isDataCompressed()) {
            switch (textureData.getInternalFormat()) {
                case 33776: 
                case 33777: 
                case 33778: 
                case 33779: {
                    if (gL.isExtensionAvailable("GL_EXT_texture_compression_s3tc") || gL.isExtensionAvailable("GL_NV_texture_compression_vtc")) break;
                    throw new GLException("DXTn compressed textures not supported by this graphics card");
                }
            }
        }
    }

    private boolean validateTexID(GL gL, boolean bl) {
        if (0 == this.texID) {
            if (null != gL) {
                int[] nArray = new int[1];
                gL.glGenTextures(1, nArray, 0);
                this.texID = nArray[0];
                if (0 == this.texID && bl) {
                    throw new GLException("Create texture ID invalid: texID " + this.texID + ", glerr 0x" + Integer.toHexString(gL.glGetError()));
                }
            } else if (bl) {
                throw new GLException("No GL context given, can't create texture ID");
            }
        }
        return 0 != this.texID;
    }

    private static boolean haveNPOT(GL gL) {
        return !disableNPOT && (gL.isGLES2() || gL.isExtensionAvailable("GL_ARB_texture_non_power_of_two"));
    }

    private static boolean haveTexRect(GL gL) {
        return !disableTexRect && TextureIO.isTexRectEnabled() && gL.isExtensionAvailable("GL_ARB_texture_rectangle");
    }

    private static boolean preferTexRect(GL gL) {
        String string;
        return "MacOSX".equals(NativeWindowFactory.getNativeWindowType(false)) && (string = gL.glGetString(7936)) != null && string.startsWith("ATI");
    }
}

