/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.Fixed;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.Table;

public class HeadTable
implements Table {
    private DirectoryEntry _de;
    private int _versionNumber;
    private int _fontRevision;
    private int _checkSumAdjustment;
    private int _magicNumber;
    private short _flags;
    private short _unitsPerEm;
    private long _created;
    private long _modified;
    private short _xMin;
    private short _yMin;
    private short _xMax;
    private short _yMax;
    private short _macStyle;
    private short _lowestRecPPEM;
    private short _fontDirectionHint;
    private short _indexToLocFormat;
    private short _glyphDataFormat;

    protected HeadTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._versionNumber = dataInput.readInt();
        this._fontRevision = dataInput.readInt();
        this._checkSumAdjustment = dataInput.readInt();
        this._magicNumber = dataInput.readInt();
        this._flags = dataInput.readShort();
        this._unitsPerEm = dataInput.readShort();
        this._created = dataInput.readLong();
        this._modified = dataInput.readLong();
        this._xMin = dataInput.readShort();
        this._yMin = dataInput.readShort();
        this._xMax = dataInput.readShort();
        this._yMax = dataInput.readShort();
        this._macStyle = dataInput.readShort();
        this._lowestRecPPEM = dataInput.readShort();
        this._fontDirectionHint = dataInput.readShort();
        this._indexToLocFormat = dataInput.readShort();
        this._glyphDataFormat = dataInput.readShort();
    }

    public int getCheckSumAdjustment() {
        return this._checkSumAdjustment;
    }

    public long getCreated() {
        return this._created;
    }

    public short getFlags() {
        return this._flags;
    }

    public short getFontDirectionHint() {
        return this._fontDirectionHint;
    }

    public int getFontRevision() {
        return this._fontRevision;
    }

    public short getGlyphDataFormat() {
        return this._glyphDataFormat;
    }

    public short getIndexToLocFormat() {
        return this._indexToLocFormat;
    }

    public short getLowestRecPPEM() {
        return this._lowestRecPPEM;
    }

    public short getMacStyle() {
        return this._macStyle;
    }

    public long getModified() {
        return this._modified;
    }

    @Override
    public int getType() {
        return 1751474532;
    }

    public short getUnitsPerEm() {
        return this._unitsPerEm;
    }

    public int getVersionNumber() {
        return this._versionNumber;
    }

    public short getXMax() {
        return this._xMax;
    }

    public short getXMin() {
        return this._xMin;
    }

    public short getYMax() {
        return this._yMax;
    }

    public short getYMin() {
        return this._yMin;
    }

    public String toString() {
        return new StringBuffer().append("'head' Table - Font Header\n--------------------------").append("\n  'head' version:      ").append(Fixed.floatValue(this._versionNumber)).append("\n  fontRevision:        ").append(Fixed.roundedFloatValue(this._fontRevision, 8)).append("\n  checkSumAdjustment:  0x").append(Integer.toHexString(this._checkSumAdjustment).toUpperCase()).append("\n  magicNumber:         0x").append(Integer.toHexString(this._magicNumber).toUpperCase()).append("\n  flags:               0x").append(Integer.toHexString(this._flags).toUpperCase()).append("\n  unitsPerEm:          ").append(this._unitsPerEm).append("\n  created:             ").append(this._created).append("\n  modified:            ").append(this._modified).append("\n  xMin:                ").append(this._xMin).append("\n  yMin:                ").append(this._yMin).append("\n  xMax:                ").append(this._xMax).append("\n  yMax:                ").append(this._yMax).append("\n  macStyle bits:       ").append(Integer.toHexString(this._macStyle).toUpperCase()).append("\n  lowestRecPPEM:       ").append(this._lowestRecPPEM).append("\n  fontDirectionHint:   ").append(this._fontDirectionHint).append("\n  indexToLocFormat:    ").append(this._indexToLocFormat).append("\n  glyphDataFormat:     ").append(this._glyphDataFormat).toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }
}

