/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.jawt;

import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Map;
import javax.media.nativewindow.NativeWindowException;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.jawt.JAWT;
import jogamp.nativewindow.jawt.JAWTJNILibLoader;
import jogamp.nativewindow.jawt.JAWTToolkitLock;

public class JAWTUtil {
    protected static final boolean DEBUG = Debug.debug("JAWT");
    private static final boolean headlessMode;
    private static final Method isQueueFlusherThread;
    private static final boolean j2dExist;
    private static final Method sunToolkitAWTLockMethod;
    private static final Method sunToolkitAWTUnlockMethod;
    private static final boolean hasSunToolkitAWTLock;
    private static final JAWTToolkitLock jawtToolkitLock;

    public static void initSingleton() {
    }

    public static boolean hasJava2D() {
        return j2dExist;
    }

    public static boolean isJava2DQueueFlusherThread() {
        boolean bl = false;
        if (j2dExist) {
            try {
                bl = (Boolean)isQueueFlusherThread.invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public static boolean isHeadlessMode() {
        return headlessMode;
    }

    public static void awtLock() {
        if (hasSunToolkitAWTLock) {
            try {
                sunToolkitAWTLockMethod.invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                throw new NativeWindowException("SunToolkit.awtLock failed", exception);
            }
        } else {
            JAWT.getJAWT().Lock();
        }
    }

    public static void awtUnlock() {
        if (hasSunToolkitAWTLock) {
            try {
                sunToolkitAWTUnlockMethod.invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                throw new NativeWindowException("SunToolkit.awtUnlock failed", exception);
            }
        } else {
            JAWT.getJAWT().Unlock();
        }
    }

    public static void lockToolkit() throws NativeWindowException {
        if (!headlessMode && !JAWTUtil.isJava2DQueueFlusherThread()) {
            JAWTUtil.awtLock();
        }
    }

    public static void unlockToolkit() {
        if (!headlessMode && !JAWTUtil.isJava2DQueueFlusherThread()) {
            JAWTUtil.awtUnlock();
        }
    }

    public static JAWTToolkitLock getJAWTToolkitLock() {
        return jawtToolkitLock;
    }

    static {
        JAWTJNILibLoader.loadAWTImpl();
        JAWTJNILibLoader.loadNativeWindow("awt");
        headlessMode = GraphicsEnvironment.isHeadless();
        boolean bl = false;
        Class<?> clazz = null;
        Method method = null;
        if (!headlessMode) {
            try {
                clazz = Class.forName("jogamp.opengl.awt.Java2D");
                method = clazz.getMethod("isQueueFlusherThread", null);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        isQueueFlusherThread = method;
        j2dExist = bl;
        PrivilegedDataBlob1 privilegedDataBlob1 = (PrivilegedDataBlob1)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PrivilegedDataBlob1 privilegedDataBlob1 = new PrivilegedDataBlob1();
                try {
                    Class<?> clazz = Class.forName("sun.awt.SunToolkit");
                    privilegedDataBlob1.sunToolkitAWTLockMethod = clazz.getDeclaredMethod("awtLock", new Class[0]);
                    privilegedDataBlob1.sunToolkitAWTLockMethod.setAccessible(true);
                    privilegedDataBlob1.sunToolkitAWTUnlockMethod = clazz.getDeclaredMethod("awtUnlock", new Class[0]);
                    privilegedDataBlob1.sunToolkitAWTUnlockMethod.setAccessible(true);
                    privilegedDataBlob1.ok = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return privilegedDataBlob1;
            }
        });
        sunToolkitAWTLockMethod = privilegedDataBlob1.sunToolkitAWTLockMethod;
        sunToolkitAWTUnlockMethod = privilegedDataBlob1.sunToolkitAWTUnlockMethod;
        boolean bl2 = false;
        if (privilegedDataBlob1.ok) {
            try {
                sunToolkitAWTLockMethod.invoke(null, (Object[])null);
                sunToolkitAWTUnlockMethod.invoke(null, (Object[])null);
                bl2 = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        hasSunToolkitAWTLock = bl2;
        jawtToolkitLock = new JAWTToolkitLock();
        Map map = null;
        try {
            if (EventQueue.isDispatchThread()) {
                map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
            } else {
                final ArrayList arrayList = new ArrayList(1);
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
                        if (null != map) {
                            arrayList.add(map);
                        }
                    }
                });
                map = arrayList.size() > 0 ? (Map)arrayList.get(0) : null;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        if (DEBUG) {
            System.err.println("JAWTUtil: Has sun.awt.SunToolkit.awtLock/awtUnlock " + hasSunToolkitAWTLock);
            System.err.println("JAWTUtil: Has Java2D " + j2dExist);
            System.err.println("JAWTUtil: Is headless " + headlessMode);
            int n = null != map ? map.size() : 0;
            System.err.println("JAWTUtil: AWT Desktop hints " + n);
        }
    }

    private static class PrivilegedDataBlob1 {
        Method sunToolkitAWTLockMethod;
        Method sunToolkitAWTUnlockMethod;
        boolean ok = false;

        PrivilegedDataBlob1() {
        }
    }
}

