/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.common.util.RunnableTask;
import com.jogamp.newt.util.EDTUtil;
import java.util.ArrayList;
import javax.media.nativewindow.NativeWindowException;
import jogamp.newt.Debug;

public class DefaultEDTUtil
implements EDTUtil {
    public static final boolean DEBUG = Debug.debug("EDT");
    private ThreadGroup threadGroup;
    private EventDispatchThread edt = null;
    private Object edtLock = new Object();
    private String name;
    int start_iter = 0;
    private Runnable dispatchMessages;

    public DefaultEDTUtil(ThreadGroup threadGroup, String string, Runnable runnable) {
        this.threadGroup = threadGroup;
        this.name = Thread.currentThread().getName() + "-" + string + "-EDT-";
        this.dispatchMessages = runnable;
        this.edt = new EventDispatchThread(this.threadGroup, string);
        this.edt.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reset() {
        Object object = this.edtLock;
        synchronized (object) {
            this.waitUntilStopped();
            if (DEBUG) {
                if (this.edt.tasks.size() > 0) {
                    String string = Thread.currentThread() + ": EDT reset, remaining tasks: " + this.edt.tasks.size() + " - " + this.edt;
                    System.err.println(string);
                }
                System.err.println(Thread.currentThread() + ": EDT reset - edt: " + this.edt);
            }
            this.edt = new EventDispatchThread(this.threadGroup, this.name);
            this.edt.setDaemon(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        Object object = this.edtLock;
        synchronized (object) {
            if (!this.edt.isRunning() && !this.edt.shouldStop) {
                if (this.edt.isAlive()) {
                    throw new RuntimeException("EDT Thread.isAlive(): true, isRunning: " + this.edt.isRunning() + ", edt: " + this.edt + ", tasks: " + this.edt.tasks.size());
                }
                ++this.start_iter;
                this.edt.setName(this.name + this.start_iter);
                this.edt.shouldStop = false;
                if (DEBUG) {
                    String string = Thread.currentThread() + ": EDT START - edt: " + this.edt;
                    System.err.println(string);
                }
                this.edt.start();
            }
        }
    }

    @Override
    public final boolean isCurrentThreadEDT() {
        return this.edt == Thread.currentThread();
    }

    @Override
    public final boolean isRunning() {
        return this.edt.isRunning();
    }

    @Override
    public final void invokeStop(Runnable runnable) {
        this.invokeImpl(true, runnable, true);
    }

    @Override
    public final void invoke(boolean bl, Runnable runnable) {
        this.invokeImpl(bl, runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeImpl(boolean bl, Runnable runnable, boolean bl2) {
        Object object;
        if (runnable == null) {
            throw new RuntimeException("Null Runnable");
        }
        Throwable throwable = null;
        RunnableTask runnableTask = null;
        Object object2 = object = new Object();
        synchronized (object2) {
            Object object3 = this.edtLock;
            synchronized (object3) {
                Object object4;
                if (this.edt.shouldStop) {
                    if (DEBUG) {
                        Throwable throwable2 = new Throwable("Warning: EDT about (1) to stop, won't enqueue new task: " + this.edt);
                        throwable2.printStackTrace();
                    }
                    return;
                }
                if (bl2) {
                    this.edt.shouldStop = true;
                    if (DEBUG) {
                        object4 = Thread.currentThread() + ": EDT signal STOP (on edt: " + this.isCurrentThreadEDT() + ") - tasks: " + this.edt.tasks.size() + " - " + this.edt;
                        System.err.println((String)object4);
                    }
                }
                if (this.isCurrentThreadEDT()) {
                    runnable.run();
                    bl = false;
                    if (bl2 && this.edt.tasks.size() > 0) {
                        object4 = "Warning: EDT about (2) to stop, having remaining tasks: " + this.edt.tasks.size() + " - " + this.edt;
                        if (DEBUG) {
                            Throwable throwable3 = new Throwable((String)object4);
                            throwable3.printStackTrace();
                        } else {
                            System.err.println((String)object4);
                        }
                    }
                } else {
                    object4 = this.edt.tasks;
                    synchronized (object4) {
                        this.start();
                        bl = bl && this.edt.isRunning();
                        runnableTask = new RunnableTask(runnable, bl ? object : null, true);
                        if (bl2) {
                            runnableTask.setAttachment((Object)new Boolean(true));
                        }
                        this.edt.tasks.add(runnableTask);
                        this.edt.tasks.notifyAll();
                    }
                }
            }
            if (bl) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
                if (null == throwable) {
                    throwable = runnableTask.getThrowable();
                }
                if (null != throwable) {
                    if (throwable instanceof NativeWindowException) {
                        throw (NativeWindowException)throwable;
                    }
                    throw new RuntimeException(throwable);
                }
            }
        }
        if (DEBUG && bl2) {
            System.err.println(Thread.currentThread() + ": EDT signal STOP X edt: " + this.edt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void waitUntilIdle() {
        EventDispatchThread eventDispatchThread;
        Object object = this.edtLock;
        synchronized (object) {
            eventDispatchThread = this.edt;
        }
        if (!eventDispatchThread.isRunning() || eventDispatchThread == Thread.currentThread()) {
            return;
        }
        object = eventDispatchThread.tasks;
        synchronized (object) {
            while (eventDispatchThread.isRunning() && eventDispatchThread.tasks.size() > 0) {
                try {
                    eventDispatchThread.tasks.notifyAll();
                    eventDispatchThread.tasks.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void waitUntilStopped() {
        Object object = this.edtLock;
        synchronized (object) {
            if (this.edt.isRunning() && this.edt != Thread.currentThread()) {
                while (this.edt.isRunning()) {
                    try {
                        this.edtLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }
    }

    class EventDispatchThread
    extends Thread {
        volatile boolean shouldStop;
        volatile boolean isRunning;
        ArrayList tasks;

        public EventDispatchThread(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
            this.shouldStop = false;
            this.isRunning = false;
            this.tasks = new ArrayList();
        }

        public final boolean isRunning() {
            return this.isRunning;
        }

        @Override
        public final void start() throws IllegalThreadStateException {
            this.isRunning = true;
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            ArrayList arrayList;
            Object object;
            RuntimeException runtimeException;
            block60: {
                if (DEBUG) {
                    System.err.println(this.getName() + ": EDT run() START " + this.getName());
                }
                runtimeException = null;
                try {
                    do {
                        if (!this.shouldStop) {
                            DefaultEDTUtil.this.dispatchMessages.run();
                        }
                        object = null;
                        arrayList = this.tasks;
                        synchronized (arrayList) {
                            if (!this.shouldStop && this.tasks.size() == 0) {
                                try {
                                    this.tasks.wait(10L);
                                }
                                catch (InterruptedException interruptedException) {
                                    interruptedException.printStackTrace();
                                }
                            }
                            if (this.tasks.size() > 0) {
                                object = (RunnableTask)this.tasks.remove(0);
                                this.tasks.notifyAll();
                            }
                        }
                        if (null == object) continue;
                        object.run();
                    } while (!this.shouldStop);
                    if (!DEBUG) break block60;
                    object = this.tasks.size() > 0 ? (RunnableTask)this.tasks.get(0) : null;
                }
                catch (Throwable throwable) {
                    Object object2;
                    block61: {
                        try {
                            this.shouldStop = true;
                            runtimeException = throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException("Within EDT", throwable);
                            if (!DEBUG) break block61;
                            object2 = this.tasks.size() > 0 ? (RunnableTask)this.tasks.get(0) : null;
                        }
                        catch (Throwable throwable2) {
                            Object object3;
                            if (DEBUG) {
                                object3 = this.tasks.size() > 0 ? (RunnableTask)this.tasks.get(0) : null;
                                System.err.println(this.getName() + ": EDT run() END " + this.getName() + ", tasks: " + this.tasks.size() + ", " + object3 + ", " + runtimeException);
                            }
                            object3 = DefaultEDTUtil.this.edtLock;
                            synchronized (object3) {
                                if (null == runtimeException) {
                                    ArrayList arrayList2 = this.tasks;
                                    synchronized (arrayList2) {
                                        RunnableTask runnableTask = null;
                                        while ((null == runnableTask || runnableTask.getAttachment() == null) && this.tasks.size() > 0) {
                                            runnableTask = (RunnableTask)this.tasks.remove(0);
                                            runnableTask.run();
                                            this.tasks.notifyAll();
                                        }
                                        if (DEBUG) {
                                            if (null != runnableTask && runnableTask.getAttachment() == null) {
                                                Throwable throwable3 = new Throwable("Warning: EDT exit: Last task Not Final: " + this.tasks.size() + ", " + runnableTask + " - " + DefaultEDTUtil.this.edt);
                                                throwable3.printStackTrace();
                                            } else if (this.tasks.size() > 0) {
                                                Throwable throwable4 = new Throwable("Warning: EDT exit: Remaining tasks Post Final: " + this.tasks.size());
                                                throwable4.printStackTrace();
                                            }
                                        }
                                    }
                                }
                                boolean bl = this.isRunning = !this.shouldStop;
                                if (!this.isRunning) {
                                    DefaultEDTUtil.this.edtLock.notifyAll();
                                }
                            }
                            if (DEBUG) {
                                System.err.println(this.getName() + ": EDT run() EXIT " + this.getName() + ", " + runtimeException);
                            }
                            if (null != runtimeException) {
                                throw runtimeException;
                            }
                            throw throwable2;
                        }
                        System.err.println(this.getName() + ": EDT run() END " + this.getName() + ", tasks: " + this.tasks.size() + ", " + object2 + ", " + runtimeException);
                    }
                    object2 = DefaultEDTUtil.this.edtLock;
                    synchronized (object2) {
                        if (null == runtimeException) {
                            ArrayList arrayList3 = this.tasks;
                            synchronized (arrayList3) {
                                RunnableTask runnableTask = null;
                                while ((null == runnableTask || runnableTask.getAttachment() == null) && this.tasks.size() > 0) {
                                    runnableTask = (RunnableTask)this.tasks.remove(0);
                                    runnableTask.run();
                                    this.tasks.notifyAll();
                                }
                                if (DEBUG) {
                                    if (null != runnableTask && runnableTask.getAttachment() == null) {
                                        Throwable throwable5 = new Throwable("Warning: EDT exit: Last task Not Final: " + this.tasks.size() + ", " + runnableTask + " - " + DefaultEDTUtil.this.edt);
                                        throwable5.printStackTrace();
                                    } else if (this.tasks.size() > 0) {
                                        Throwable throwable6 = new Throwable("Warning: EDT exit: Remaining tasks Post Final: " + this.tasks.size());
                                        throwable6.printStackTrace();
                                    }
                                }
                            }
                        }
                        boolean bl = this.isRunning = !this.shouldStop;
                        if (!this.isRunning) {
                            DefaultEDTUtil.this.edtLock.notifyAll();
                        }
                    }
                    if (DEBUG) {
                        System.err.println(this.getName() + ": EDT run() EXIT " + this.getName() + ", " + runtimeException);
                    }
                    if (null != runtimeException) {
                        throw runtimeException;
                    }
                }
                System.err.println(this.getName() + ": EDT run() END " + this.getName() + ", tasks: " + this.tasks.size() + ", " + object + ", " + runtimeException);
            }
            object = DefaultEDTUtil.this.edtLock;
            synchronized (object) {
                if (null == runtimeException) {
                    arrayList = this.tasks;
                    synchronized (arrayList) {
                        RunnableTask runnableTask = null;
                        while ((null == runnableTask || runnableTask.getAttachment() == null) && this.tasks.size() > 0) {
                            runnableTask = (RunnableTask)this.tasks.remove(0);
                            runnableTask.run();
                            this.tasks.notifyAll();
                        }
                        if (DEBUG) {
                            if (null != runnableTask && runnableTask.getAttachment() == null) {
                                Throwable throwable = new Throwable("Warning: EDT exit: Last task Not Final: " + this.tasks.size() + ", " + runnableTask + " - " + DefaultEDTUtil.this.edt);
                                throwable.printStackTrace();
                            } else if (this.tasks.size() > 0) {
                                Throwable throwable = new Throwable("Warning: EDT exit: Remaining tasks Post Final: " + this.tasks.size());
                                throwable.printStackTrace();
                            }
                        }
                    }
                }
                boolean bl = this.isRunning = !this.shouldStop;
                if (!this.isRunning) {
                    DefaultEDTUtil.this.edtLock.notifyAll();
                }
            }
            if (DEBUG) {
                System.err.println(this.getName() + ": EDT run() EXIT " + this.getName() + ", " + runtimeException);
            }
            if (null != runtimeException) {
                throw runtimeException;
            }
        }
    }
}

