/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.ScreenMode;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.newt.event.NEWTEventConsumer;
import com.jogamp.newt.event.ScreenModeListener;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.SurfaceUpdatedListener;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.nativewindow.util.Point;
import javax.media.nativewindow.util.Rectangle;
import jogamp.newt.Debug;
import jogamp.newt.DisplayImpl;
import jogamp.newt.OffscreenWindow;
import jogamp.newt.ScreenImpl;

public abstract class WindowImpl
implements Window,
NEWTEventConsumer {
    public static final boolean DEBUG_TEST_REPARENT_INCOMPATIBLE = Debug.isPropertyDefined("newt.test.Window.reparent.incompatible", true);
    private volatile long windowHandle = 0L;
    private volatile boolean visible = false;
    private RecursiveLock windowLock = new RecursiveLock();
    private RecursiveLock surfaceLock = new RecursiveLock();
    private ScreenImpl screen;
    private boolean screenReferenceAdded = false;
    private NativeWindow parentWindow = null;
    private long parentWindowHandle = 0L;
    protected AbstractGraphicsConfiguration config = null;
    protected CapabilitiesImmutable capsRequested = null;
    protected CapabilitiesChooser capabilitiesChooser = null;
    protected boolean fullscreen = false;
    protected boolean hasFocus = false;
    protected int width = 128;
    protected int height = 128;
    protected int x = -1;
    protected int y = -1;
    protected Insets insets = new Insets();
    protected int nfs_width;
    protected int nfs_height;
    protected int nfs_x;
    protected int nfs_y;
    protected String title = "Newt Window";
    protected boolean undecorated = false;
    protected boolean alwaysOnTop = false;
    private LifecycleHook lifecycleHook = null;
    private DestroyAction destroyAction = new DestroyAction();
    private boolean handleDestroyNotify = true;
    private ReparentActionRecreate reparentActionRecreate = new ReparentActionRecreate();
    private RequestFocusAction requestFocusAction = new RequestFocusAction();
    private Window.FocusRunnable focusAction = null;
    private Object surfaceUpdatedListenersLock = new Object();
    private ArrayList<SurfaceUpdatedListener> surfaceUpdatedListeners = new ArrayList();
    private Object childWindowsLock = new Object();
    private ArrayList<NativeWindow> childWindows = new ArrayList();
    private ArrayList<MouseListener> mouseListeners = new ArrayList();
    private int mouseButtonPressed = 0;
    private long lastMousePressed = 0L;
    private int lastMouseClickCount = 0;
    private ArrayList<KeyListener> keyListeners = new ArrayList();
    private ArrayList<WindowListener> windowListeners = new ArrayList();
    private boolean repaintQueued = false;
    ScreenModeListenerImpl screenModeListenerImpl = new ScreenModeListenerImpl();
    private Object closingListenerLock = new Object();
    private int defaultCloseOperation = 1;
    public static final int FLAG_CHANGE_PARENTING = 1;
    public static final int FLAG_CHANGE_DECORATION = 2;
    public static final int FLAG_CHANGE_FULLSCREEN = 4;
    public static final int FLAG_CHANGE_ALWAYSONTOP = 8;
    public static final int FLAG_CHANGE_VISIBILITY = 16;
    public static final int FLAG_HAS_PARENT = 256;
    public static final int FLAG_IS_UNDECORATED = 512;
    public static final int FLAG_IS_FULLSCREEN = 1024;
    public static final int FLAG_IS_ALWAYSONTOP = 2048;
    public static final int FLAG_IS_VISIBLE = 4096;

    public static void init(String string) {
        if ("MacOSX".equals(string)) {
            try {
                WindowImpl.getWindowClass(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static Class<?> getWindowClass(String string) throws ClassNotFoundException {
        Class<?> clazz = NewtFactory.getCustomClass(string, "Window");
        if (null == clazz) {
            if ("ANDROID".equals(string)) {
                clazz = Class.forName("jogamp.newt.driver.android.AndroidWindow");
            } else if ("EGL".equals(string)) {
                clazz = Class.forName("jogamp.newt.driver.kd.KDWindow");
            } else if ("Windows".equals(string)) {
                clazz = Class.forName("jogamp.newt.driver.windows.WindowsWindow");
            } else if ("MacOSX".equals(string)) {
                clazz = Class.forName("jogamp.newt.driver.macosx.MacWindow");
            } else if ("X11".equals(string)) {
                clazz = Class.forName("jogamp.newt.driver.x11.X11Window");
            } else if ("AWT".equals(string)) {
                clazz = Class.forName("jogamp.newt.driver.awt.AWTWindow");
            } else {
                throw new NativeWindowException("Unknown window type \"" + string + "\"");
            }
        }
        return clazz;
    }

    public static WindowImpl create(NativeWindow nativeWindow, long l, Screen screen, CapabilitiesImmutable capabilitiesImmutable) {
        try {
            Class clazz = capabilitiesImmutable.isOnscreen() ? WindowImpl.getWindowClass(screen.getDisplay().getType()) : OffscreenWindow.class;
            WindowImpl windowImpl = (WindowImpl)clazz.newInstance();
            windowImpl.parentWindow = nativeWindow;
            windowImpl.parentWindowHandle = l;
            windowImpl.screen = (ScreenImpl)screen;
            windowImpl.capsRequested = (CapabilitiesImmutable)capabilitiesImmutable.cloneMutable();
            windowImpl.setUndecorated(0L != l);
            return windowImpl;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new NativeWindowException(throwable);
        }
    }

    public static WindowImpl create(Object[] objectArray, Screen screen, CapabilitiesImmutable capabilitiesImmutable) {
        try {
            Class<?> clazz = WindowImpl.getWindowClass(screen.getDisplay().getType());
            Class[] classArray = WindowImpl.getCustomConstructorArgumentTypes(clazz);
            if (null == classArray) {
                throw new NativeWindowException("WindowClass " + clazz + " doesn't support custom arguments in constructor");
            }
            int n = WindowImpl.verifyConstructorArgumentTypes(classArray, objectArray);
            if (n < objectArray.length) {
                throw new NativeWindowException("WindowClass " + clazz + " constructor mismatch at argument #" + n + "; Constructor: " + WindowImpl.getTypeStrList(classArray) + ", arguments: " + WindowImpl.getArgsStrList(objectArray));
            }
            WindowImpl windowImpl = (WindowImpl)ReflectionUtil.createInstance(clazz, (Class[])classArray, (Object[])objectArray);
            windowImpl.screen = (ScreenImpl)screen;
            windowImpl.capsRequested = (CapabilitiesImmutable)capabilitiesImmutable.cloneMutable();
            return windowImpl;
        }
        catch (Throwable throwable) {
            throw new NativeWindowException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createNative() {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.createNative() START (" + WindowImpl.getThreadName() + ", " + this + ")");
        }
        if (null != this.parentWindow && 1 >= this.parentWindow.lockSurface()) {
            throw new NativeWindowException("Parent surface lock: not ready: " + this.parentWindow);
        }
        if (!(0 <= this.x && 0 <= this.y || !this.isUndecorated() && null == this.parentWindow)) {
            this.x = 0;
            this.y = 0;
        }
        try {
            if (this.validateParentWindowHandle()) {
                if (this.screenReferenceAdded) {
                    throw new InternalError("XXX");
                }
                if (this.canCreateNativeImpl()) {
                    this.screen.addReference();
                    this.screenReferenceAdded = true;
                    this.createNativeImpl();
                    this.screen.addScreenModeListener(this.screenModeListenerImpl);
                    this.setTitleImpl(this.title);
                    if (this.waitForVisible(true, false) && this.isFullscreen()) {
                        this.fullscreen = false;
                        FullScreenActionImpl fullScreenActionImpl = new FullScreenActionImpl(true);
                        fullScreenActionImpl.run();
                    }
                }
                this.visible = true;
            }
        }
        finally {
            if (null != this.parentWindow) {
                this.parentWindow.unlockSurface();
            }
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.createNative() END (" + WindowImpl.getThreadName() + ", " + this + ")");
        }
        return this.isNativeValid();
    }

    private void removeScreenReference() {
        if (this.screenReferenceAdded) {
            this.screenReferenceAdded = false;
            this.screen.removeReference();
        }
    }

    private boolean validateParentWindowHandle() {
        if (null != this.parentWindow) {
            this.parentWindowHandle = WindowImpl.getNativeWindowHandle(this.parentWindow);
            return 0L != this.parentWindowHandle;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNativeWindowHandle(NativeWindow nativeWindow) {
        long l = 0L;
        if (null != nativeWindow) {
            boolean bl = false;
            if (1 < nativeWindow.lockSurface()) {
                bl = true;
                try {
                    l = nativeWindow.getWindowHandle();
                    if (0L == l) {
                        throw new NativeWindowException("Parent native window handle is NULL, after succesful locking: " + nativeWindow);
                    }
                }
                catch (NativeWindowException nativeWindowException) {
                    if (DEBUG_IMPLEMENTATION) {
                        System.err.println("Window.getNativeWindowHandle: not successful yet: " + nativeWindowException);
                    }
                }
                finally {
                    nativeWindow.unlockSurface();
                }
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.getNativeWindowHandle: locked " + bl + ", " + nativeWindow);
            }
        }
        return l;
    }

    protected int lockSurfaceImpl() {
        return 3;
    }

    protected void unlockSurfaceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDefaultCloseOperation() {
        Object object = this.closingListenerLock;
        synchronized (object) {
            return this.defaultCloseOperation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setDefaultCloseOperation(int n) {
        Object object = this.closingListenerLock;
        synchronized (object) {
            int n2 = this.defaultCloseOperation;
            this.defaultCloseOperation = n;
            return n2;
        }
    }

    protected boolean canCreateNativeImpl() {
        return true;
    }

    protected abstract void createNativeImpl();

    protected abstract void closeNativeImpl();

    protected abstract void requestFocusImpl(boolean var1);

    protected abstract boolean reconfigureWindowImpl(int var1, int var2, int var3, int var4, int var5);

    protected int getReconfigureFlags(int n, boolean bl) {
        return n |= (0L != this.getParentWindowHandle() ? 256 : 0) | (this.isUndecorated() ? 512 : 0) | (this.isFullscreen() ? 1024 : 0) | (this.isAlwaysOnTop() ? 2048 : 0) | (bl ? 4096 : 0);
    }

    protected static String getReconfigureFlagsAsString(StringBuffer stringBuffer, int n) {
        if (null == stringBuffer) {
            stringBuffer = new StringBuffer();
        }
        stringBuffer.append("[");
        if (0 != (1 & n)) {
            stringBuffer.append("*");
        }
        stringBuffer.append("PARENT_");
        stringBuffer.append(0 != (0x100 & n));
        stringBuffer.append(", ");
        if (0 != (4 & n)) {
            stringBuffer.append("*");
        }
        stringBuffer.append("FS_");
        stringBuffer.append(0 != (0x400 & n));
        stringBuffer.append(", ");
        if (0 != (2 & n)) {
            stringBuffer.append("*");
        }
        stringBuffer.append("UNDECOR_");
        stringBuffer.append(0 != (0x200 & n));
        stringBuffer.append(", ");
        if (0 != (0x10 & n)) {
            stringBuffer.append("*");
        }
        stringBuffer.append("VISIBLE_");
        stringBuffer.append(0 != (0x1000 & n));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void setTitleImpl(String string) {
    }

    protected abstract Point getLocationOnScreenImpl(int var1, int var2);

    protected abstract void updateInsetsImpl(Insets var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int lockSurface() {
        int n;
        block9: {
            this.windowLock.lock();
            this.surfaceLock.lock();
            int n2 = n = this.surfaceLock.getRecursionCount() == 0 ? 1 : 3;
            if (1 == n) {
                try {
                    if (!this.isNativeValid()) break block9;
                    AbstractGraphicsDevice abstractGraphicsDevice = this.config.getScreen().getDevice();
                    abstractGraphicsDevice.lock();
                    try {
                        n = this.lockSurfaceImpl();
                    }
                    finally {
                        if (1 >= n) {
                            abstractGraphicsDevice.unlock();
                        }
                    }
                }
                finally {
                    if (1 >= n) {
                        this.surfaceLock.unlock();
                        this.windowLock.unlock();
                    }
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlockSurface() {
        this.surfaceLock.validateLocked();
        this.windowLock.validateLocked();
        if (this.surfaceLock.getRecursionCount() == 0) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.config.getScreen().getDevice();
            try {
                this.unlockSurfaceImpl();
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        }
        this.surfaceLock.unlock();
        this.windowLock.unlock();
    }

    public final boolean isWindowLockedByOtherThread() {
        return this.windowLock.isLockedByOtherThread();
    }

    public final boolean isWindowLocked() {
        return this.windowLock.isLocked();
    }

    public final Thread getWindowLockOwner() {
        return this.windowLock.getOwner();
    }

    @Override
    public final boolean isSurfaceLockedByOtherThread() {
        return this.surfaceLock.isLockedByOtherThread();
    }

    @Override
    public final boolean isSurfaceLocked() {
        return this.surfaceLock.isLocked();
    }

    @Override
    public final Thread getSurfaceLockOwner() {
        return this.surfaceLock.getOwner();
    }

    @Override
    public long getSurfaceHandle() {
        return this.windowHandle;
    }

    @Override
    public boolean surfaceSwap() {
        return false;
    }

    @Override
    public AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.config;
    }

    @Override
    public final long getDisplayHandle() {
        return this.getScreen().getDisplay().getHandle();
    }

    @Override
    public final int getScreenIndex() {
        return this.getScreen().getIndex();
    }

    @Override
    public final NativeWindow getParent() {
        return this.parentWindow;
    }

    @Override
    public final long getWindowHandle() {
        return this.windowHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point getLocationOnScreen(Point point) {
        if (this.isNativeValid()) {
            Point point2;
            this.windowLock.lock();
            try {
                point2 = this.getLocationOnScreenImpl(0, 0);
            }
            finally {
                this.windowLock.unlock();
            }
            if (null != point2) {
                if (null != point) {
                    point.translate(point2.getX(), point2.getY());
                    return point;
                }
                return point2;
            }
        }
        if (null != point) {
            point.translate(this.getX(), this.getY());
        } else {
            point = new Point(this.getX(), this.getY());
        }
        if (null != this.parentWindow) {
            this.parentWindow.getLocationOnScreen(point);
        }
        return point;
    }

    @Override
    public final boolean isNativeValid() {
        return 0L != this.windowHandle;
    }

    @Override
    public final Screen getScreen() {
        return this.screen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setVisibleActionImpl(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        this.windowLock.lock();
        try {
            NativeWindow nativeWindow;
            int n;
            Object object;
            if (null != this.lifecycleHook) {
                this.lifecycleHook.resetCounter();
            }
            if (!bl && null != this.childWindows && this.childWindows.size() > 0) {
                object = this.childWindowsLock;
                synchronized (object) {
                    for (n = 0; n < this.childWindows.size(); ++n) {
                        nativeWindow = this.childWindows.get(n);
                        if (!(nativeWindow instanceof WindowImpl)) continue;
                        ((WindowImpl)nativeWindow).setVisible(false);
                    }
                }
            }
            if (!this.isNativeValid() && bl) {
                if (0 < this.width * this.height) {
                    bl3 = bl2 = this.createNative();
                }
            } else if (this.visible != bl && this.isNativeValid()) {
                this.setVisibleImpl(bl, this.x, this.y, this.width, this.height);
                this.waitForVisible(bl, true);
                bl3 = bl;
            }
            if (null != this.lifecycleHook) {
                this.lifecycleHook.setVisibleActionPost(bl, bl2);
            }
            if (this.isNativeValid() && bl && null != this.childWindows && this.childWindows.size() > 0) {
                object = this.childWindowsLock;
                synchronized (object) {
                    for (n = 0; n < this.childWindows.size(); ++n) {
                        nativeWindow = this.childWindows.get(n);
                        if (!(nativeWindow instanceof WindowImpl)) continue;
                        ((WindowImpl)nativeWindow).setVisible(true);
                    }
                }
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window setVisible: END (" + WindowImpl.getThreadName() + ") " + this.x + "/" + this.y + " " + this.width + "x" + this.height + ", fs " + this.fullscreen + ", windowHandle " + WindowImpl.toHexString(this.windowHandle) + ", visible: " + this.visible + ", nativeWindowCreated: " + bl2 + ", madeVisible: " + bl3);
            }
        }
        finally {
            this.windowLock.unlock();
        }
        if (bl2 || bl3) {
            this.sendWindowEvent(100);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (!this.isNativeValid() && bl && 0 >= this.width * this.height) {
            return;
        }
        if (DEBUG_IMPLEMENTATION) {
            String string = "Window setVisible: START (" + WindowImpl.getThreadName() + ") " + this.x + "/" + this.y + " " + this.width + "x" + this.height + ", fs " + this.fullscreen + ", windowHandle " + WindowImpl.toHexString(this.windowHandle) + ", visible: " + this.visible + " -> " + bl + ", parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle) + ", parentWindow " + (null != this.parentWindow);
            System.err.println(string);
            Thread.dumpStack();
        }
        this.runOnEDTIfAvail(true, new VisibleAction(bl));
    }

    protected final void setVisibleImpl(boolean bl, int n, int n2, int n3, int n4) {
        this.reconfigureWindowImpl(n, n2, n3, n4, this.getReconfigureFlags(16, bl));
    }

    @Override
    public void setSize(int n, int n2) {
        this.runOnEDTIfAvail(true, new SetSizeActionImpl(n, n2));
    }

    @Override
    public void setTopLevelSize(int n, int n2) {
        this.setSize(n - this.getInsets().getTotalWidth(), n2 - this.getInsets().getTotalHeight());
    }

    @Override
    public void destroy() {
        this.visible = false;
        this.runOnEDTIfAvail(true, this.destroyAction);
    }

    @Override
    public final int reparentWindow(NativeWindow nativeWindow) {
        return this.reparentWindow(nativeWindow, false);
    }

    @Override
    public int reparentWindow(NativeWindow nativeWindow, boolean bl) {
        ReparentActionImpl reparentActionImpl = new ReparentActionImpl(nativeWindow, bl);
        this.runOnEDTIfAvail(true, reparentActionImpl);
        return reparentActionImpl.getStrategy();
    }

    @Override
    public CapabilitiesChooser setCapabilitiesChooser(CapabilitiesChooser capabilitiesChooser) {
        CapabilitiesChooser capabilitiesChooser2 = this.capabilitiesChooser;
        this.capabilitiesChooser = capabilitiesChooser;
        return capabilitiesChooser2;
    }

    @Override
    public final CapabilitiesImmutable getChosenCapabilities() {
        return this.config.getNativeGraphicsConfiguration().getChosenCapabilities();
    }

    @Override
    public final CapabilitiesImmutable getRequestedCapabilities() {
        return this.capsRequested;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String string) {
        if (string == null) {
            string = "";
        }
        this.title = string;
        if (0L != this.getWindowHandle()) {
            this.setTitleImpl(string);
        }
    }

    @Override
    public void setUndecorated(boolean bl) {
        this.runOnEDTIfAvail(true, new DecorationActionImpl(bl));
    }

    @Override
    public final boolean isUndecorated() {
        return 0L != this.parentWindowHandle || this.undecorated || this.fullscreen;
    }

    @Override
    public final void setAlwaysOnTop(boolean bl) {
        this.runOnEDTIfAvail(true, new AlwaysOnTopActionImpl(bl));
    }

    @Override
    public final boolean isAlwaysOnTop() {
        return this.alwaysOnTop || this.fullscreen;
    }

    @Override
    public void requestFocus() {
        this.enqueueRequestFocus(true);
    }

    @Override
    public final boolean hasFocus() {
        return this.hasFocus;
    }

    @Override
    public final InsetsImmutable getInsets() {
        if (this.isUndecorated()) {
            return Insets.getZero();
        }
        this.updateInsetsImpl(this.insets);
        return this.insets;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public final int getX() {
        return this.x;
    }

    @Override
    public final int getY() {
        return this.y;
    }

    @Override
    public final boolean isVisible() {
        return this.visible;
    }

    @Override
    public final boolean isFullscreen() {
        return this.fullscreen;
    }

    public boolean hasDeviceChanged() {
        return false;
    }

    public LifecycleHook getLifecycleHook() {
        return this.lifecycleHook;
    }

    public LifecycleHook setLifecycleHook(LifecycleHook lifecycleHook) {
        LifecycleHook lifecycleHook2 = this.lifecycleHook;
        this.lifecycleHook = lifecycleHook;
        return lifecycleHook2;
    }

    public Object getWrappedWindow() {
        return null;
    }

    public void setHandleDestroyNotify(boolean bl) {
        this.handleDestroyNotify = bl;
    }

    protected final long getParentWindowHandle() {
        return this.isFullscreen() ? 0L : this.parentWindowHandle;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName() + "[Config " + this.config + "\n, " + this.screen + "\n, ParentWindow " + this.parentWindow + "\n, ParentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle) + " (" + (0L != this.getParentWindowHandle()) + ")" + "\n, WindowHandle " + WindowImpl.toHexString(this.getWindowHandle()) + "\n, SurfaceHandle " + WindowImpl.toHexString(this.getSurfaceHandle()) + " (lockedExt window " + this.isWindowLockedByOtherThread() + ", surface " + this.isSurfaceLockedByOtherThread() + ")" + "\n, Pos " + this.getX() + "/" + this.getY() + ", size " + this.getWidth() + "x" + this.getHeight() + "\n, Visible " + this.isVisible() + "\n, Undecorated " + this.undecorated + " (" + this.isUndecorated() + ")" + "\n, AlwaysOnTop " + this.alwaysOnTop + ", Fullscreen " + this.fullscreen + "\n, WrappedWindow " + this.getWrappedWindow() + "\n, ChildWindows " + this.childWindows.size());
        stringBuilder.append(", SurfaceUpdatedListeners num " + this.surfaceUpdatedListeners.size() + " [");
        for (n = 0; n < this.surfaceUpdatedListeners.size(); ++n) {
            stringBuilder.append(this.surfaceUpdatedListeners.get(n) + ", ");
        }
        stringBuilder.append("], WindowListeners num " + this.windowListeners.size() + " [");
        for (n = 0; n < this.windowListeners.size(); ++n) {
            stringBuilder.append(this.windowListeners.get(n) + ", ");
        }
        stringBuilder.append("], MouseListeners num " + this.mouseListeners.size() + " [");
        for (n = 0; n < this.mouseListeners.size(); ++n) {
            stringBuilder.append(this.mouseListeners.get(n) + ", ");
        }
        stringBuilder.append("], KeyListeners num " + this.keyListeners.size() + " [");
        for (n = 0; n < this.keyListeners.size(); ++n) {
            stringBuilder.append(this.keyListeners.get(n) + ", ");
        }
        stringBuilder.append("] ]");
        return stringBuilder.toString();
    }

    protected final void setWindowHandle(long l) {
        this.windowHandle = l;
    }

    @Override
    public void runOnEDTIfAvail(boolean bl, Runnable runnable) {
        Screen screen = this.getScreen();
        if (null == screen) {
            throw new RuntimeException("Null screen of inner class: " + this);
        }
        DisplayImpl displayImpl = (DisplayImpl)screen.getDisplay();
        displayImpl.runOnEDTIfAvail(bl, runnable);
    }

    protected void enqueueRequestFocus(boolean bl) {
        this.runOnEDTIfAvail(bl, this.requestFocusAction);
    }

    @Override
    public void setFocusAction(Window.FocusRunnable focusRunnable) {
        this.focusAction = focusRunnable;
    }

    protected boolean focusAction() {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.focusAction() START - " + WindowImpl.getThreadName() + ", focusAction: " + this.focusAction + " - windowHandle " + WindowImpl.toHexString(this.getWindowHandle()));
        }
        boolean bl = null != this.focusAction ? this.focusAction.run() : false;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.focusAction() END - " + WindowImpl.getThreadName() + ", focusAction: " + this.focusAction + " - windowHandle " + WindowImpl.toHexString(this.getWindowHandle()) + ", res: " + bl);
        }
        return bl;
    }

    @Override
    public void setPosition(int n, int n2) {
        this.runOnEDTIfAvail(true, new SetPositionActionImpl(n, n2));
    }

    @Override
    public void setTopLevelPosition(int n, int n2) {
        this.setPosition(n + this.getInsets().getLeftWidth(), n2 + this.getInsets().getTopHeight());
    }

    @Override
    public boolean setFullscreen(boolean bl) {
        this.runOnEDTIfAvail(true, new FullScreenActionImpl(bl));
        return this.fullscreen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeChild(NativeWindow nativeWindow) {
        Object object = this.childWindowsLock;
        synchronized (object) {
            return this.childWindows.remove(nativeWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addChild(NativeWindow nativeWindow) {
        if (nativeWindow == null) {
            return false;
        }
        Object object = this.childWindowsLock;
        synchronized (object) {
            return this.childWindows.add(nativeWindow);
        }
    }

    private void doEvent(boolean bl, boolean bl2, NEWTEvent nEWTEvent) {
        boolean bl3 = false;
        if (!bl) {
            bl2 = bl3 = this.consumeEvent(nEWTEvent);
        }
        if (!bl3) {
            this.enqueueEvent(bl2, nEWTEvent);
        }
    }

    @Override
    public void enqueueEvent(boolean bl, NEWTEvent nEWTEvent) {
        if (this.isNativeValid()) {
            ((DisplayImpl)this.getScreen().getDisplay()).enqueueEvent(bl, nEWTEvent);
        }
    }

    @Override
    public boolean consumeEvent(NEWTEvent nEWTEvent) {
        switch (nEWTEvent.getEventType()) {
            case 105: {
                if (this.isWindowLocked()) {
                    if (!this.repaintQueued) {
                        this.repaintQueued = true;
                        if (DEBUG_IMPLEMENTATION) {
                            System.err.println("Window.consumeEvent: queued " + nEWTEvent);
                        }
                        return false;
                    }
                    return true;
                }
                this.repaintQueued = false;
                break;
            }
            case 100: {
                if (!this.isWindowLocked()) break;
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.consumeEvent: queued " + nEWTEvent);
                }
                return false;
            }
        }
        if (nEWTEvent instanceof WindowEvent) {
            this.consumeWindowEvent((WindowEvent)nEWTEvent);
        } else if (nEWTEvent instanceof KeyEvent) {
            this.consumeKeyEvent((KeyEvent)nEWTEvent);
        } else if (nEWTEvent instanceof MouseEvent) {
            this.consumeMouseEvent((MouseEvent)nEWTEvent);
        } else {
            throw new NativeWindowException("Unexpected NEWTEvent type " + nEWTEvent);
        }
        return true;
    }

    @Override
    public void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.addSurfaceUpdatedListener(-1, surfaceUpdatedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        if (surfaceUpdatedListener == null) {
            return;
        }
        Object object = this.surfaceUpdatedListenersLock;
        synchronized (object) {
            if (0 > n) {
                n = this.surfaceUpdatedListeners.size();
            }
            this.surfaceUpdatedListeners.add(n, surfaceUpdatedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        if (surfaceUpdatedListener == null) {
            return;
        }
        Object object = this.surfaceUpdatedListenersLock;
        synchronized (object) {
            this.surfaceUpdatedListeners.remove(surfaceUpdatedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllSurfaceUpdatedListener() {
        Object object = this.surfaceUpdatedListenersLock;
        synchronized (object) {
            this.surfaceUpdatedListeners = new ArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SurfaceUpdatedListener getSurfaceUpdatedListener(int n) {
        Object object = this.surfaceUpdatedListenersLock;
        synchronized (object) {
            if (0 > n) {
                n = this.surfaceUpdatedListeners.size() - 1;
            }
            return this.surfaceUpdatedListeners.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SurfaceUpdatedListener[] getSurfaceUpdatedListeners() {
        Object object = this.surfaceUpdatedListenersLock;
        synchronized (object) {
            return (SurfaceUpdatedListener[])this.surfaceUpdatedListeners.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        Object object2 = this.surfaceUpdatedListenersLock;
        synchronized (object2) {
            for (int i = 0; i < this.surfaceUpdatedListeners.size(); ++i) {
                SurfaceUpdatedListener surfaceUpdatedListener = this.surfaceUpdatedListeners.get(i);
                surfaceUpdatedListener.surfaceUpdated(object, nativeSurface, l);
            }
        }
    }

    public void sendMouseEvent(int n, int n2, int n3, int n4, int n5, int n6) {
        this.doMouseEvent(false, false, n, n2, n3, n4, n5, n6);
    }

    public void enqueueMouseEvent(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        this.doMouseEvent(true, bl, n, n2, n3, n4, n5, n6);
    }

    private void doMouseEvent(boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n3 < 0 || n4 < 0 || n3 >= this.width || n4 >= this.height) {
            return;
        }
        if (DEBUG_MOUSE_EVENT) {
            System.err.println("doMouseEvent: enqueue" + bl + ", wait " + bl2 + ", " + MouseEvent.getEventTypeString(n) + ", mod " + n2 + ", pos " + n3 + "/" + n4 + ", button " + n5);
        }
        if (n5 < 0 || n5 > 6) {
            throw new NativeWindowException("Invalid mouse button number" + n5);
        }
        long l = System.currentTimeMillis();
        MouseEvent mouseEvent = null;
        MouseEvent mouseEvent2 = null;
        if (203 == n) {
            this.lastMouseClickCount = l - this.lastMousePressed < (long)MouseEvent.getClickTimeout() ? ++this.lastMouseClickCount : 1;
            this.lastMousePressed = l;
            this.mouseButtonPressed = n5;
            mouseEvent2 = new MouseEvent(n, this, l, n2, n3, n4, this.lastMouseClickCount, n5, 0);
        } else if (204 == n) {
            mouseEvent2 = new MouseEvent(n, this, l, n2, n3, n4, this.lastMouseClickCount, n5, 0);
            if (l - this.lastMousePressed < (long)MouseEvent.getClickTimeout()) {
                mouseEvent = new MouseEvent(200, this, l, n2, n3, n4, this.lastMouseClickCount, n5, 0);
            } else {
                this.lastMouseClickCount = 0;
                this.lastMousePressed = 0L;
            }
            this.mouseButtonPressed = 0;
        } else {
            mouseEvent2 = 205 == n ? (this.mouseButtonPressed > 0 ? new MouseEvent(206, this, l, n2, n3, n4, 1, this.mouseButtonPressed, 0) : new MouseEvent(n, this, l, n2, n3, n4, 0, n5, 0)) : (207 == n ? new MouseEvent(n, this, l, n2, n3, n4, 0, n5, n6) : new MouseEvent(n, this, l, n2, n3, n4, 0, n5, 0));
        }
        this.doEvent(bl, bl2, mouseEvent2);
        if (null != mouseEvent) {
            if (DEBUG_MOUSE_EVENT) {
                System.err.println("doMouseEvent: synthesized MOUSE_CLICKED event");
            }
            this.doEvent(bl, bl2, mouseEvent);
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.addMouseListener(-1, mouseListener);
    }

    @Override
    public void addMouseListener(int n, MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, mouseListener);
        this.mouseListeners = arrayList;
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        arrayList.remove(mouseListener);
        this.mouseListeners = arrayList;
    }

    @Override
    public MouseListener getMouseListener(int n) {
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        if (0 > n) {
            n = arrayList.size() - 1;
        }
        return (MouseListener)arrayList.get(n);
    }

    @Override
    public MouseListener[] getMouseListeners() {
        return (MouseListener[])this.mouseListeners.toArray();
    }

    protected void consumeMouseEvent(MouseEvent mouseEvent) {
        if (DEBUG_MOUSE_EVENT) {
            System.err.println("consumeMouseEvent: event:         " + mouseEvent);
        }
        block10: for (int i = 0; i < this.mouseListeners.size(); ++i) {
            MouseListener mouseListener = this.mouseListeners.get(i);
            switch (mouseEvent.getEventType()) {
                case 200: {
                    mouseListener.mouseClicked(mouseEvent);
                    continue block10;
                }
                case 201: {
                    mouseListener.mouseEntered(mouseEvent);
                    continue block10;
                }
                case 202: {
                    mouseListener.mouseExited(mouseEvent);
                    continue block10;
                }
                case 203: {
                    mouseListener.mousePressed(mouseEvent);
                    continue block10;
                }
                case 204: {
                    mouseListener.mouseReleased(mouseEvent);
                    continue block10;
                }
                case 205: {
                    mouseListener.mouseMoved(mouseEvent);
                    continue block10;
                }
                case 206: {
                    mouseListener.mouseDragged(mouseEvent);
                    continue block10;
                }
                case 207: {
                    mouseListener.mouseWheelMoved(mouseEvent);
                    continue block10;
                }
                default: {
                    throw new NativeWindowException("Unexpected mouse event type " + mouseEvent.getEventType());
                }
            }
        }
    }

    public void sendKeyEvent(int n, int n2, int n3, char c) {
        this.consumeKeyEvent(new KeyEvent(n, this, System.currentTimeMillis(), n2, n3, c));
    }

    public void enqueueKeyEvent(boolean bl, int n, int n2, int n3, char c) {
        this.enqueueEvent(bl, new KeyEvent(n, this, System.currentTimeMillis(), n2, n3, c));
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.addKeyListener(-1, keyListener);
    }

    @Override
    public void addKeyListener(int n, KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.keyListeners.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, keyListener);
        this.keyListeners = arrayList;
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.keyListeners.clone();
        arrayList.remove(keyListener);
        this.keyListeners = arrayList;
    }

    @Override
    public KeyListener getKeyListener(int n) {
        ArrayList arrayList = (ArrayList)this.keyListeners.clone();
        if (0 > n) {
            n = arrayList.size() - 1;
        }
        return (KeyListener)arrayList.get(n);
    }

    @Override
    public KeyListener[] getKeyListeners() {
        return (KeyListener[])this.keyListeners.toArray();
    }

    protected void consumeKeyEvent(KeyEvent keyEvent) {
        if (DEBUG_KEY_EVENT) {
            System.err.println("consumeKeyEvent: " + keyEvent);
        }
        block5: for (int i = 0; i < this.keyListeners.size(); ++i) {
            KeyListener keyListener = this.keyListeners.get(i);
            switch (keyEvent.getEventType()) {
                case 300: {
                    keyListener.keyPressed(keyEvent);
                    continue block5;
                }
                case 301: {
                    keyListener.keyReleased(keyEvent);
                    continue block5;
                }
                case 302: {
                    keyListener.keyTyped(keyEvent);
                    continue block5;
                }
                default: {
                    throw new NativeWindowException("Unexpected key event type " + keyEvent.getEventType());
                }
            }
        }
    }

    @Override
    public void sendWindowEvent(int n) {
        this.consumeWindowEvent(new WindowEvent(n, this, System.currentTimeMillis()));
    }

    public void enqueueWindowEvent(boolean bl, int n) {
        this.enqueueEvent(bl, new WindowEvent(n, this, System.currentTimeMillis()));
    }

    @Override
    public void addWindowListener(WindowListener windowListener) {
        this.addWindowListener(-1, windowListener);
    }

    @Override
    public void addWindowListener(int n, WindowListener windowListener) throws IndexOutOfBoundsException {
        if (windowListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.windowListeners.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, windowListener);
        this.windowListeners = arrayList;
    }

    @Override
    public final void removeWindowListener(WindowListener windowListener) {
        if (windowListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.windowListeners.clone();
        arrayList.remove(windowListener);
        this.windowListeners = arrayList;
    }

    @Override
    public WindowListener getWindowListener(int n) {
        ArrayList arrayList = (ArrayList)this.windowListeners.clone();
        if (0 > n) {
            n = arrayList.size() - 1;
        }
        return (WindowListener)arrayList.get(n);
    }

    @Override
    public WindowListener[] getWindowListeners() {
        return (WindowListener[])this.windowListeners.toArray();
    }

    protected void consumeWindowEvent(WindowEvent windowEvent) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("consumeWindowEvent: " + windowEvent + ", visible " + this.isVisible() + " " + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight());
        }
        block9: for (int i = 0; i < this.windowListeners.size(); ++i) {
            WindowListener windowListener = this.windowListeners.get(i);
            switch (windowEvent.getEventType()) {
                case 100: {
                    windowListener.windowResized(windowEvent);
                    continue block9;
                }
                case 101: {
                    windowListener.windowMoved(windowEvent);
                    continue block9;
                }
                case 102: {
                    windowListener.windowDestroyNotify(windowEvent);
                    continue block9;
                }
                case 106: {
                    windowListener.windowDestroyed(windowEvent);
                    continue block9;
                }
                case 103: {
                    windowListener.windowGainedFocus(windowEvent);
                    continue block9;
                }
                case 104: {
                    windowListener.windowLostFocus(windowEvent);
                    continue block9;
                }
                case 105: {
                    windowListener.windowRepaint((WindowUpdateEvent)windowEvent);
                    continue block9;
                }
                default: {
                    throw new NativeWindowException("Unexpected window event type " + windowEvent.getEventType());
                }
            }
        }
    }

    protected void focusChanged(boolean bl) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.focusChanged: (" + WindowImpl.getThreadName() + "): " + this.hasFocus + " -> " + bl + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
        }
        this.hasFocus = bl;
        if (bl) {
            this.sendWindowEvent(103);
        } else {
            this.sendWindowEvent(104);
        }
    }

    protected void visibleChanged(boolean bl) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.visibleChanged (" + WindowImpl.getThreadName() + "): " + this.visible + " -> " + bl + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
        }
        this.visible = bl;
    }

    private boolean waitForVisible(boolean bl, boolean bl2) {
        return this.waitForVisible(bl, bl2, 1000L);
    }

    private boolean waitForVisible(boolean bl, boolean bl2, long l) {
        DisplayImpl displayImpl = (DisplayImpl)this.screen.getDisplay();
        for (long i = l; 0L < i && this.visible != bl; i -= 10L) {
            displayImpl.dispatchMessagesNative();
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.visible != bl) {
            String string = "Visibility not reached as requested within " + l + "ms : requested " + bl + ", is " + this.visible;
            if (bl2) {
                throw new NativeWindowException(string);
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println(string);
            }
        }
        return this.visible == bl;
    }

    protected void sizeChanged(int n, int n2, boolean bl) {
        if (bl || this.width != n || this.height != n2) {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.sizeChanged: (" + WindowImpl.getThreadName() + "): force " + bl + ", " + this.width + "x" + this.height + " -> " + n + "x" + n2 + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
            }
            if (0 > n || 0 > n2) {
                throw new NativeWindowException("Illegal width or height " + n + "x" + n2 + " (must be >= 0)");
            }
            this.width = n;
            this.height = n2;
            if (this.isNativeValid()) {
                this.sendWindowEvent(100);
            }
        }
    }

    private boolean waitForSize(int n, int n2, boolean bl, long l) {
        DisplayImpl displayImpl = (DisplayImpl)this.screen.getDisplay();
        boolean bl2 = false;
        for (long i = l; !bl2 && 0L < i; i -= 10L) {
            if (n == this.getWidth() && n2 == this.getHeight()) {
                bl2 = true;
                continue;
            }
            displayImpl.dispatchMessagesNative();
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!bl2) {
            String string = "Size/Pos not reached as requested within " + l + "ms : requested " + n + "x" + n2 + ", is " + this.getWidth() + "x" + this.getHeight();
            if (bl) {
                throw new NativeWindowException(string);
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println(string);
                Thread.dumpStack();
            }
        }
        return bl2;
    }

    protected void positionChanged(int n, int n2) {
        if (this.x != n || this.y != n2) {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.positionChanged: (" + WindowImpl.getThreadName() + "): " + this.x + "/" + this.y + " -> " + n + "/" + n2 + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
            }
            this.x = n;
            this.y = n2;
            this.sendWindowEvent(101);
        }
    }

    protected void insetsChanged(int n, int n2, int n3, int n4) {
        if (n >= 0 && n2 >= 0 && n3 >= 0 && n4 >= 0) {
            if (this.isUndecorated()) {
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.insetsChanged: skip insets change for undecoration mode");
                }
            } else if (n != this.insets.getLeftWidth() || n2 != this.insets.getRightWidth() || n3 != this.insets.getTopHeight() || n4 != this.insets.getBottomHeight()) {
                this.insets.setLeftWidth(n);
                this.insets.setRightWidth(n2);
                this.insets.setTopHeight(n3);
                this.insets.setBottomHeight(n4);
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.insetsChanged: " + this.insets);
                }
            }
        }
    }

    protected void windowDestroyNotify() {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.windowDestroyNotify START " + WindowImpl.getThreadName());
        }
        this.enqueueWindowEvent(true, 102);
        if (this.handleDestroyNotify && 1 == this.defaultCloseOperation) {
            this.destroy();
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.windowDestroyeNotify END " + WindowImpl.getThreadName());
        }
    }

    @Override
    public void windowRepaint(int n, int n2, int n3, int n4) {
        n = 0 > n ? this.x : n;
        n2 = 0 > n2 ? this.y : n2;
        n3 = 0 >= n3 ? this.width : n3;
        int n5 = n4 = 0 >= n4 ? this.height : n4;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.windowRepaint " + WindowImpl.getThreadName() + " - " + n + "/" + n2 + " " + n3 + "x" + n4);
        }
        if (this.isNativeValid()) {
            WindowUpdateEvent windowUpdateEvent = new WindowUpdateEvent(105, this, System.currentTimeMillis(), new Rectangle(n, n2, n3, n4));
            this.doEvent(false, false, windowUpdateEvent);
        }
    }

    private static Class<?>[] getCustomConstructorArgumentTypes(Class<?> clazz) {
        Class[] classArray = null;
        try {
            Method method = clazz.getDeclaredMethod("getCustomConstructorArgumentTypes", new Class[0]);
            classArray = (Class[])method.invoke(null, (Object[])null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return classArray;
    }

    private static int verifyConstructorArgumentTypes(Class<?>[] classArray, Object[] objectArray) {
        if (classArray.length != objectArray.length) {
            return -1;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (classArray[i].isInstance(objectArray[i])) continue;
            return i;
        }
        return objectArray.length;
    }

    private static String getArgsStrList(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuilder.append(objectArray[i].getClass());
            if (i >= objectArray.length) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    private static String getTypeStrList(Class<?>[] classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuilder.append(classArray[i]);
            if (i >= classArray.length) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    protected final void shouldNotCallThis() {
        throw new NativeWindowException("Should not call this");
    }

    public static String getThreadName() {
        return Display.getThreadName();
    }

    public static String toHexString(int n) {
        return Display.toHexString(n);
    }

    public static String toHexString(long l) {
        return Display.toHexString(l);
    }

    private class AlwaysOnTopActionImpl
    implements Runnable {
        boolean alwaysOnTop;

        private AlwaysOnTopActionImpl(boolean bl) {
            this.alwaysOnTop = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            WindowImpl.this.windowLock.lock();
            try {
                if (WindowImpl.this.alwaysOnTop != this.alwaysOnTop) {
                    boolean bl = !WindowImpl.this.fullscreen && WindowImpl.this.isNativeValid() && WindowImpl.this.isAlwaysOnTop() != this.alwaysOnTop;
                    WindowImpl.this.alwaysOnTop = this.alwaysOnTop;
                    if (bl) {
                        int n = WindowImpl.this.x;
                        int n2 = WindowImpl.this.y;
                        int n3 = WindowImpl.this.width;
                        int n4 = WindowImpl.this.height;
                        if (WindowImpl.this.isNativeValid()) {
                            DisplayImpl displayImpl = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                            displayImpl.dispatchMessagesNative();
                            WindowImpl.this.reconfigureWindowImpl(n, n2, n3, n4, WindowImpl.this.getReconfigureFlags(8, WindowImpl.this.isVisible()));
                            displayImpl.dispatchMessagesNative();
                        }
                    }
                }
            }
            finally {
                WindowImpl.this.windowLock.unlock();
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    private class DecorationActionImpl
    implements Runnable {
        boolean undecorated;

        private DecorationActionImpl(boolean bl) {
            this.undecorated = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            WindowImpl.this.windowLock.lock();
            try {
                if (WindowImpl.this.undecorated != this.undecorated) {
                    boolean bl = !WindowImpl.this.fullscreen && WindowImpl.this.isNativeValid() && WindowImpl.this.isUndecorated() != this.undecorated;
                    WindowImpl.this.undecorated = this.undecorated;
                    if (bl) {
                        int n = WindowImpl.this.x;
                        int n2 = WindowImpl.this.y;
                        int n3 = WindowImpl.this.width;
                        int n4 = WindowImpl.this.height;
                        if (WindowImpl.this.isNativeValid()) {
                            DisplayImpl displayImpl = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                            displayImpl.dispatchMessagesNative();
                            WindowImpl.this.reconfigureWindowImpl(n, n2, n3, n4, WindowImpl.this.getReconfigureFlags(2, WindowImpl.this.isVisible()));
                            displayImpl.dispatchMessagesNative();
                        }
                    }
                }
            }
            finally {
                WindowImpl.this.windowLock.unlock();
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    private class DestroyAction
    implements Runnable {
        private DestroyAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            boolean bl = false;
            if (null != WindowImpl.this.lifecycleHook) {
                bl = WindowImpl.this.lifecycleHook.pauseRenderingAction();
            }
            if (null != WindowImpl.this.lifecycleHook) {
                WindowImpl.this.lifecycleHook.destroyActionPreLock();
            }
            WindowImpl.this.windowLock.lock();
            try {
                Object object;
                if (Window.DEBUG_IMPLEMENTATION) {
                    object = "!!! Window DestroyAction() " + WindowImpl.getThreadName();
                    System.err.println((String)object);
                }
                object = WindowImpl.this.childWindowsLock;
                synchronized (object) {
                    if (WindowImpl.this.childWindows.size() > 0) {
                        ArrayList arrayList = (ArrayList)WindowImpl.this.childWindows.clone();
                        while (arrayList.size() > 0) {
                            NativeWindow nativeWindow = (NativeWindow)arrayList.remove(0);
                            if (nativeWindow instanceof WindowImpl) {
                                ((WindowImpl)nativeWindow).sendWindowEvent(102);
                                ((WindowImpl)nativeWindow).destroy();
                                continue;
                            }
                            nativeWindow.destroy();
                        }
                    }
                }
                if (null != WindowImpl.this.lifecycleHook) {
                    WindowImpl.this.lifecycleHook.destroyActionInLock();
                }
                if (null != WindowImpl.this.screen) {
                    if (WindowImpl.this.isNativeValid()) {
                        WindowImpl.this.screen.removeScreenModeListener(WindowImpl.this.screenModeListenerImpl);
                        WindowImpl.this.closeNativeImpl();
                        WindowImpl.this.removeScreenReference();
                    }
                    if (null != (object = WindowImpl.this.screen.getDisplay())) {
                        ((Display)object).validateEDT();
                    }
                }
                WindowImpl.this.sendWindowEvent(106);
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.destroy() END " + WindowImpl.getThreadName());
                }
            }
            finally {
                WindowImpl.this.windowLock.unlock();
            }
            if (bl) {
                WindowImpl.this.lifecycleHook.resumeRenderingAction();
            }
            WindowImpl.this.setWindowHandle(0L);
            WindowImpl.this.visible = false;
            WindowImpl.this.fullscreen = false;
            WindowImpl.this.hasFocus = false;
            WindowImpl.this.parentWindowHandle = 0L;
        }
    }

    private class FullScreenActionImpl
    implements Runnable {
        boolean fullscreen;

        private FullScreenActionImpl(boolean bl) {
            this.fullscreen = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            block18: {
                WindowImpl.this.windowLock.lock();
                try {
                    NativeWindow nativeWindow;
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    if (WindowImpl.this.fullscreen == this.fullscreen) break block18;
                    boolean bl = WindowImpl.this.isNativeValid() && WindowImpl.this.isFullscreen() != this.fullscreen;
                    WindowImpl.this.fullscreen = this.fullscreen;
                    if (!bl) break block18;
                    if (this.fullscreen) {
                        WindowImpl.this.nfs_x = WindowImpl.this.x;
                        WindowImpl.this.nfs_y = WindowImpl.this.y;
                        WindowImpl.this.nfs_width = WindowImpl.this.width;
                        WindowImpl.this.nfs_height = WindowImpl.this.height;
                        n4 = 0;
                        n3 = 0;
                        n2 = WindowImpl.this.screen.getWidth();
                        n = WindowImpl.this.screen.getHeight();
                    } else {
                        n4 = WindowImpl.this.nfs_x;
                        n3 = WindowImpl.this.nfs_y;
                        n2 = WindowImpl.this.nfs_width;
                        n = WindowImpl.this.nfs_height;
                        if (null != WindowImpl.this.parentWindow) {
                            n4 = 0;
                            n3 = 0;
                            if (n2 > WindowImpl.this.parentWindow.getWidth()) {
                                n2 = WindowImpl.this.parentWindow.getWidth();
                            }
                            if (n > WindowImpl.this.parentWindow.getHeight()) {
                                n = WindowImpl.this.parentWindow.getHeight();
                            }
                        }
                    }
                    if (Window.DEBUG_IMPLEMENTATION) {
                        System.err.println("Window fs: " + this.fullscreen + " " + n4 + "/" + n3 + " " + n2 + "x" + n + ", " + WindowImpl.this.isUndecorated() + ", " + WindowImpl.this.screen);
                    }
                    DisplayImpl displayImpl = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                    displayImpl.dispatchMessagesNative();
                    boolean bl2 = WindowImpl.this.isVisible();
                    if (null != WindowImpl.this.parentWindow) {
                        nativeWindow = WindowImpl.this.parentWindow;
                        if (1 >= nativeWindow.lockSurface()) {
                            throw new NativeWindowException("Parent surface lock: not ready: " + WindowImpl.this.parentWindow);
                        }
                    } else {
                        nativeWindow = null;
                    }
                    try {
                        WindowImpl.this.reconfigureWindowImpl(n4, n3, n2, n, WindowImpl.this.getReconfigureFlags((null != nativeWindow ? 1 : 0) | 4 | 2, bl2));
                    }
                    finally {
                        if (null != nativeWindow) {
                            nativeWindow.unlockSurface();
                        }
                    }
                    displayImpl.dispatchMessagesNative();
                    if (bl2) {
                        WindowImpl.this.setVisibleImpl(true, n4, n3, n2, n);
                        WindowImpl.this.waitForVisible(true, false);
                        displayImpl.dispatchMessagesNative();
                        WindowImpl.this.waitForSize(n2, n, false, 1000L);
                        displayImpl.dispatchMessagesNative();
                        WindowImpl.this.requestFocusImpl(true);
                        displayImpl.dispatchMessagesNative();
                        if (Window.DEBUG_IMPLEMENTATION) {
                            System.err.println("Window fs done: " + WindowImpl.this);
                        }
                    }
                }
                finally {
                    WindowImpl.this.windowLock.unlock();
                }
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    public static interface LifecycleHook {
        public void resetCounter();

        public void setVisibleActionPost(boolean var1, boolean var2);

        public void destroyActionPreLock();

        public void destroyActionInLock();

        public boolean pauseRenderingAction();

        public void resumeRenderingAction();
    }

    private class ReparentActionImpl
    implements Runnable,
    Window.ReparentAction {
        NativeWindow newParentWindow;
        boolean forceDestroyCreate;
        int reparentAction;

        private ReparentActionImpl(NativeWindow nativeWindow, boolean bl) {
            this.newParentWindow = nativeWindow;
            this.forceDestroyCreate = bl;
            this.reparentAction = -1;
        }

        private int getStrategy() {
            return this.reparentAction;
        }

        private void setScreen(ScreenImpl screenImpl) {
            WindowImpl.this.removeScreenReference();
            WindowImpl.this.screen = screenImpl;
        }

        @Override
        public final void run() {
            boolean bl = false;
            if (null != WindowImpl.this.lifecycleHook) {
                bl = WindowImpl.this.lifecycleHook.pauseRenderingAction();
            }
            this.reparent();
            if (bl) {
                WindowImpl.this.lifecycleHook.resumeRenderingAction();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reparent() {
            boolean bl;
            int n = WindowImpl.this.x;
            int n2 = WindowImpl.this.y;
            int n3 = WindowImpl.this.width;
            int n4 = WindowImpl.this.height;
            WindowImpl.this.windowLock.lock();
            try {
                Object object;
                bl = WindowImpl.this.isVisible();
                Window window = null;
                if (this.newParentWindow instanceof Window) {
                    window = (Window)this.newParentWindow;
                }
                long l = 0L;
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.reparent: START (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", visible " + bl + ", old parentWindow: " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow) + ", new parentWindow: " + Display.hashCodeNullSafe(this.newParentWindow) + ", forceDestroyCreate " + this.forceDestroyCreate + ", DEBUG_TEST_REPARENT_INCOMPATIBLE " + DEBUG_TEST_REPARENT_INCOMPATIBLE + " " + n + "/" + n2 + " " + n3 + "x" + n4);
                }
                if (null != WindowImpl.this.lifecycleHook) {
                    WindowImpl.this.lifecycleHook.resetCounter();
                }
                if (null != this.newParentWindow) {
                    n = 0;
                    n2 = 0;
                    if (n3 > this.newParentWindow.getWidth()) {
                        n3 = this.newParentWindow.getWidth();
                    }
                    if (n4 > this.newParentWindow.getHeight()) {
                        n4 = this.newParentWindow.getHeight();
                    }
                    if (0L == (l = WindowImpl.getNativeWindowHandle(this.newParentWindow))) {
                        if (null == window) {
                            throw new NativeWindowException("Reparenting with non NEWT Window type only available after it's realized: " + this.newParentWindow);
                        }
                        WindowImpl.this.destroy();
                        this.setScreen((ScreenImpl)window.getScreen());
                        this.reparentAction = 3;
                    } else if (this.newParentWindow != WindowImpl.this.getParent()) {
                        if (!WindowImpl.this.isNativeValid()) {
                            if (null != window) {
                                this.setScreen((ScreenImpl)window.getScreen());
                            } else {
                                object = NewtFactory.createCompatibleScreen(this.newParentWindow, WindowImpl.this.getScreen());
                                if (WindowImpl.this.getScreen() != object) {
                                    this.setScreen((ScreenImpl)object);
                                }
                            }
                            this.reparentAction = 0 < n3 * n4 ? 2 : 3;
                        } else if (DEBUG_TEST_REPARENT_INCOMPATIBLE || this.forceDestroyCreate || !NewtFactory.isScreenCompatible(this.newParentWindow, WindowImpl.this.getScreen())) {
                            WindowImpl.this.destroy();
                            if (null != window) {
                                this.setScreen((ScreenImpl)window.getScreen());
                            } else {
                                this.setScreen((ScreenImpl)NewtFactory.createCompatibleScreen(this.newParentWindow, WindowImpl.this.getScreen()));
                            }
                            this.reparentAction = 2;
                        } else {
                            this.reparentAction = 1;
                        }
                    } else {
                        this.reparentAction = 0;
                    }
                } else {
                    if (null != WindowImpl.this.parentWindow) {
                        object = WindowImpl.this.getLocationOnScreen(null);
                        n = ((Point)object).getX();
                        n2 = ((Point)object).getY();
                    }
                    if (0L == WindowImpl.this.parentWindowHandle) {
                        this.reparentAction = 0;
                    } else if (!WindowImpl.this.isNativeValid() || DEBUG_TEST_REPARENT_INCOMPATIBLE || this.forceDestroyCreate) {
                        WindowImpl.this.destroy();
                        this.reparentAction = 0 < n3 * n4 ? 2 : 3;
                    } else {
                        this.reparentAction = 1;
                    }
                }
                WindowImpl.this.parentWindowHandle = l;
                if (0 > this.reparentAction) {
                    throw new NativeWindowException("Internal Error: reparentAction not set");
                }
                if (0 == this.reparentAction) {
                    if (Window.DEBUG_IMPLEMENTATION) {
                        System.err.println("Window.reparent: NO CHANGE (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " new parentWindowHandle " + WindowImpl.toHexString(l) + ", visible " + bl);
                    }
                    return;
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.reparent: ACTION (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " new parentWindowHandle " + WindowImpl.toHexString(l) + ", reparentAction " + this.reparentAction + ", visible " + bl);
                }
                if (null != WindowImpl.this.parentWindow && WindowImpl.this.parentWindow instanceof Window) {
                    ((Window)WindowImpl.this.parentWindow).removeChild(WindowImpl.this);
                }
                WindowImpl.this.parentWindow = this.newParentWindow;
                if (WindowImpl.this.parentWindow instanceof Window) {
                    ((Window)WindowImpl.this.parentWindow).addChild(WindowImpl.this);
                }
                if (3 == this.reparentAction) {
                    WindowImpl.this.x = n;
                    WindowImpl.this.y = n2;
                    WindowImpl.this.width = n3;
                    WindowImpl.this.height = n4;
                    return;
                }
                if (1 == this.reparentAction) {
                    NativeWindow nativeWindow;
                    object = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                    ((DisplayImpl)object).dispatchMessagesNative();
                    if (bl) {
                        WindowImpl.this.setVisibleImpl(false, n, n2, n3, n4);
                        WindowImpl.this.waitForVisible(false, true);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ((DisplayImpl)object).dispatchMessagesNative();
                    }
                    if (null != WindowImpl.this.parentWindow) {
                        nativeWindow = WindowImpl.this.parentWindow;
                        if (1 >= nativeWindow.lockSurface()) {
                            throw new NativeWindowException("Parent surface lock: not ready: " + nativeWindow);
                        }
                        WindowImpl.this.parentWindowHandle = nativeWindow.getWindowHandle();
                    } else {
                        nativeWindow = null;
                    }
                    boolean bl2 = false;
                    try {
                        bl2 = WindowImpl.this.reconfigureWindowImpl(n, n2, n3, n4, WindowImpl.this.getReconfigureFlags(3, WindowImpl.this.isVisible()));
                    }
                    finally {
                        if (null != nativeWindow) {
                            nativeWindow.unlockSurface();
                        }
                    }
                    if (bl2) {
                        ((DisplayImpl)object).dispatchMessagesNative();
                        if (bl) {
                            WindowImpl.this.setVisibleImpl(true, n, n2, n3, n4);
                            bl2 = WindowImpl.this.waitForVisible(true, false);
                            ((DisplayImpl)object).dispatchMessagesNative();
                            if (bl2) {
                                bl2 = WindowImpl.this.waitForSize(n3, n4, false, 1000L);
                            }
                            if (bl2) {
                                WindowImpl.this.requestFocusImpl(true);
                                ((DisplayImpl)object).dispatchMessagesNative();
                            }
                        }
                    }
                    if (!bl2 || !bl) {
                        WindowImpl.this.x = n;
                        WindowImpl.this.y = n2;
                        WindowImpl.this.width = n3;
                        WindowImpl.this.height = n4;
                    }
                    if (!bl2) {
                        if (Window.DEBUG_IMPLEMENTATION) {
                            System.err.println("Window.reparent: native reparenting failed (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + " -> " + WindowImpl.toHexString(l) + " - Trying recreation");
                        }
                        WindowImpl.this.destroy();
                        this.reparentAction = 2;
                    }
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.reparentWindow: END-1 (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", visible: " + WindowImpl.this.visible + ", parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", parentWindow " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow) + " " + n + "/" + n2 + " " + n3 + "x" + n4);
                }
            }
            finally {
                WindowImpl.this.windowLock.unlock();
            }
            if (bl) {
                switch (this.reparentAction) {
                    case 1: {
                        WindowImpl.this.sendWindowEvent(100);
                        break;
                    }
                    case 2: {
                        WindowImpl.this.runOnEDTIfAvail(true, WindowImpl.this.reparentActionRecreate);
                    }
                }
            }
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.reparentWindow: END-X (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", visible: " + WindowImpl.this.visible + ", parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", parentWindow " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow) + " " + n + "/" + n2 + " " + n3 + "x" + n4);
            }
        }
    }

    private class ReparentActionRecreate
    implements Runnable {
        private ReparentActionRecreate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            WindowImpl.this.windowLock.lock();
            try {
                WindowImpl.this.visible = true;
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.reparentWindow: ReparentActionRecreate (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", visible: " + WindowImpl.this.visible + ", parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", parentWindow " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow));
                }
                WindowImpl.this.setVisible(true);
            }
            finally {
                WindowImpl.this.windowLock.unlock();
            }
        }
    }

    private class RequestFocusAction
    implements Runnable {
        private RequestFocusAction() {
        }

        @Override
        public final void run() {
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.RequestFocusAction: (" + WindowImpl.getThreadName() + "): " + WindowImpl.this.hasFocus + " -> true - windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle));
            }
            WindowImpl.this.requestFocusImpl(false);
        }
    }

    private class ScreenModeListenerImpl
    implements ScreenModeListener {
        boolean animatorPaused = false;

        private ScreenModeListenerImpl() {
        }

        @Override
        public void screenModeChangeNotify(ScreenMode screenMode) {
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.screenModeChangeNotify: " + screenMode);
            }
            if (null != WindowImpl.this.lifecycleHook) {
                this.animatorPaused = WindowImpl.this.lifecycleHook.pauseRenderingAction();
            }
        }

        @Override
        public void screenModeChanged(ScreenMode screenMode, boolean bl) {
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.screenModeChanged: " + screenMode + ", success: " + bl);
            }
            if (bl) {
                DimensionImmutable dimensionImmutable = screenMode.getMonitorMode().getSurfaceSize().getResolution();
                if (WindowImpl.this.getHeight() > dimensionImmutable.getHeight() || WindowImpl.this.getWidth() > dimensionImmutable.getWidth()) {
                    WindowImpl.this.setSize(dimensionImmutable.getWidth(), dimensionImmutable.getHeight());
                }
            }
            if (this.animatorPaused) {
                WindowImpl.this.lifecycleHook.resumeRenderingAction();
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    private class SetPositionActionImpl
    implements Runnable {
        int x;
        int y;

        private SetPositionActionImpl(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            WindowImpl.this.windowLock.lock();
            try {
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window setPosition: " + WindowImpl.this.x + "/" + WindowImpl.this.y + " -> " + this.x + "/" + this.y + ", fs " + WindowImpl.this.fullscreen + ", windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle));
                }
                if (!(WindowImpl.this.x == this.x && WindowImpl.this.y == this.y || WindowImpl.this.fullscreen)) {
                    if (0L != WindowImpl.this.windowHandle) {
                        WindowImpl.this.reconfigureWindowImpl(this.x, this.y, WindowImpl.this.width, WindowImpl.this.height, WindowImpl.this.getReconfigureFlags(0, WindowImpl.this.isVisible()));
                    } else {
                        WindowImpl.this.x = this.x;
                        WindowImpl.this.y = this.y;
                    }
                }
            }
            finally {
                WindowImpl.this.windowLock.unlock();
            }
        }
    }

    private class SetSizeActionImpl
    implements Runnable {
        int width;
        int height;

        private SetSizeActionImpl(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            WindowImpl.this.windowLock.lock();
            try {
                int n = 0;
                if (WindowImpl.this.fullscreen) return;
                if (this.width == WindowImpl.this.width) {
                    if (WindowImpl.this.height == this.height) return;
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    String string = "Window setSize: START " + WindowImpl.this.width + "x" + WindowImpl.this.height + " -> " + this.width + "x" + this.height + ", fs " + WindowImpl.this.fullscreen + ", windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", visible " + WindowImpl.this.visible;
                    System.err.println(string);
                }
                if (WindowImpl.this.isNativeValid() && 0 >= this.width * this.height && WindowImpl.this.visible) {
                    n = 1;
                    WindowImpl.this.width = 0;
                    WindowImpl.this.height = 0;
                } else if (!WindowImpl.this.isNativeValid() && 0 < this.width * this.height && WindowImpl.this.visible) {
                    n = 2;
                    WindowImpl.this.width = this.width;
                    WindowImpl.this.height = this.height;
                } else if (WindowImpl.this.isNativeValid()) {
                    WindowImpl.this.reconfigureWindowImpl(WindowImpl.this.x, WindowImpl.this.y, this.width, this.height, WindowImpl.this.getReconfigureFlags(0, WindowImpl.this.isVisible()));
                } else {
                    WindowImpl.this.width = this.width;
                    WindowImpl.this.height = this.height;
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window setSize: END " + WindowImpl.this.width + "x" + WindowImpl.this.height + ", visibleAction " + n);
                }
                switch (n) {
                    case 1: {
                        WindowImpl.this.setVisibleActionImpl(false);
                        return;
                    }
                    case 2: {
                        WindowImpl.this.setVisibleActionImpl(true);
                        return;
                    }
                }
                return;
            }
            finally {
                WindowImpl.this.windowLock.unlock();
            }
        }
    }

    private class VisibleAction
    implements Runnable {
        boolean visible;

        private VisibleAction(boolean bl) {
            this.visible = bl;
        }

        @Override
        public final void run() {
            WindowImpl.this.setVisibleActionImpl(this.visible);
        }
    }
}

