/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.windows;

import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.nativewindow.util.Point;
import jogamp.nativewindow.windows.GDI;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.windows.WindowsDisplay;
import jogamp.newt.driver.windows.WindowsScreen;

public class WindowsWindow
extends WindowImpl {
    private long hmon;
    private long hdc;
    private long windowHandleClose;

    @Override
    protected int lockSurfaceImpl() {
        if (0L != this.hdc) {
            throw new InternalError("surface not released");
        }
        this.hdc = GDI.GetDC(this.getWindowHandle());
        this.hmon = this.MonitorFromWindow0(this.getWindowHandle());
        return 0L != this.hdc ? 3 : 1;
    }

    @Override
    protected void unlockSurfaceImpl() {
        if (0L == this.hdc) {
            throw new InternalError("surface not acquired");
        }
        GDI.ReleaseDC(this.getWindowHandle(), this.hdc);
        this.hdc = 0L;
    }

    @Override
    public final long getSurfaceHandle() {
        return this.hdc;
    }

    @Override
    public boolean hasDeviceChanged() {
        long l;
        if (0L != this.getWindowHandle() && this.hmon != (l = this.MonitorFromWindow0(this.getWindowHandle()))) {
            if (DEBUG_IMPLEMENTATION) {
                Exception exception = new Exception("Info: Window Device Changed " + Thread.currentThread().getName() + ", HMON " + WindowsWindow.toHexString(this.hmon) + " -> " + WindowsWindow.toHexString(l));
                exception.printStackTrace();
            }
            this.hmon = l;
            return true;
        }
        return false;
    }

    @Override
    protected void createNativeImpl() {
        WindowsScreen windowsScreen = (WindowsScreen)this.getScreen();
        WindowsDisplay windowsDisplay = (WindowsDisplay)windowsScreen.getDisplay();
        this.config = GraphicsConfigurationFactory.getFactory(windowsDisplay.getGraphicsDevice()).chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, windowsScreen.getGraphicsScreen());
        if (this.config == null) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        int n = this.getReconfigureFlags(0, true) & 0xA00;
        this.setWindowHandle(this.CreateWindow0(windowsDisplay.getHInstance(), windowsDisplay.getWindowClassName(), windowsDisplay.getWindowClassName(), this.getParentWindowHandle(), this.x, this.y, this.width, this.height, n));
        if (this.getWindowHandle() == 0L) {
            throw new NativeWindowException("Error creating window");
        }
        this.windowHandleClose = this.getWindowHandle();
        if (DEBUG_IMPLEMENTATION) {
            Exception exception = new Exception("Info: Window new window handle " + Thread.currentThread().getName() + " (Parent HWND " + WindowsWindow.toHexString(this.getParentWindowHandle()) + ") : HWND " + WindowsWindow.toHexString(this.getWindowHandle()) + ", " + Thread.currentThread());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNativeImpl() {
        Exception exception;
        if (this.hdc != 0L) {
            block11: {
                if (this.windowHandleClose != 0L) {
                    try {
                        GDI.ReleaseDC(this.windowHandleClose, this.hdc);
                    }
                    catch (Throwable throwable) {
                        if (!DEBUG_IMPLEMENTATION) break block11;
                        exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                        exception.printStackTrace();
                    }
                }
            }
            this.hdc = 0L;
        }
        if (this.windowHandleClose != 0L) {
            try {
                GDI.DestroyWindow(this.windowHandleClose);
            }
            catch (Throwable throwable) {
                if (DEBUG_IMPLEMENTATION) {
                    exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                    exception.printStackTrace();
                }
            }
            finally {
                this.windowHandleClose = 0L;
            }
        }
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowsWindow reconfig: " + n + "/" + n2 + " " + n3 + "x" + n4 + ", " + WindowsWindow.getReconfigureFlagsAsString(null, n5));
        }
        if (0 == (0x200 & n5)) {
            InsetsImmutable insetsImmutable = this.getInsets();
            if (0 <= n && 0 <= n2) {
                n2 -= insetsImmutable.getTopHeight();
                if (0 > (n -= insetsImmutable.getLeftWidth())) {
                    n = 0;
                }
                if (0 > n2) {
                    n2 = 0;
                }
            }
            if (0 < n3 && 0 < n4) {
                n3 += insetsImmutable.getTotalWidth();
                n4 += insetsImmutable.getTotalHeight();
            }
        }
        this.reconfigureWindow0(this.getParentWindowHandle(), this.getWindowHandle(), n, n2, n3, n4, n5);
        if (0 != (0x10 & n5)) {
            this.visibleChanged(0 != (0x1000 & n5));
        }
        return true;
    }

    @Override
    protected void requestFocusImpl(boolean bl) {
        this.requestFocus0(this.getWindowHandle(), bl);
    }

    @Override
    protected void setTitleImpl(String string) {
        WindowsWindow.setTitle0(this.getWindowHandle(), string);
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        return GDI.GetRelativeLocation(this.getWindowHandle(), 0L, n, n2);
    }

    @Override
    protected void updateInsetsImpl(Insets insets) {
    }

    protected static native boolean initIDs0();

    protected static native long getNewtWndProc0();

    private native long CreateWindow0(long var1, String var3, String var4, long var5, int var7, int var8, int var9, int var10, int var11);

    private native long MonitorFromWindow0(long var1);

    private native void reconfigureWindow0(long var1, long var3, int var5, int var6, int var7, int var8, int var9);

    private static native void setTitle0(long var0, String var2);

    private native void requestFocus0(long var1, boolean var3);

    static {
        WindowsDisplay.initSingleton();
    }
}

