/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import java.util.ArrayList;
import java.util.HashSet;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLRunnable;
import jogamp.opengl.Debug;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLRunnableTask;

public class GLDrawableHelper {
    protected static final boolean DEBUG = GLDrawableImpl.DEBUG;
    private static final boolean VERBOSE = Debug.verbose();
    private Object listenersLock = new Object();
    private ArrayList<GLEventListener> listeners;
    private HashSet<GLEventListener> listenersToBeInit;
    private boolean autoSwapBufferMode;
    private Object glRunnablesLock = new Object();
    private ArrayList<GLRunnable> glRunnables;
    private GLAnimatorControl animatorCtrl;
    private static final ThreadLocal<Runnable> perThreadInitAction = new ThreadLocal();

    public GLDrawableHelper() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners = new ArrayList();
            this.listenersToBeInit = new HashSet();
        }
        this.autoSwapBufferMode = true;
        object = this.glRunnablesLock;
        synchronized (object) {
            this.glRunnables = new ArrayList();
        }
        this.animatorCtrl = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GLAnimatorControl: " + this.animatorCtrl + ", ");
        Object object = this.listenersLock;
        synchronized (object) {
            stringBuilder.append("GLEventListeners num " + this.listeners.size() + " [");
            for (int i = 0; i < this.listeners.size(); ++i) {
                GLEventListener gLEventListener = this.listeners.get(i);
                stringBuilder.append(gLEventListener);
                stringBuilder.append("[init ");
                stringBuilder.append(!this.listenersToBeInit.contains(gLEventListener));
                stringBuilder.append("], ");
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public final void addGLEventListener(GLEventListener gLEventListener) {
        this.addGLEventListener(-1, gLEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addGLEventListener(int n, GLEventListener gLEventListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (0 > n) {
                n = this.listeners.size();
            }
            this.listenersToBeInit.add(gLEventListener);
            this.listeners.add(n, gLEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeGLEventListener(GLEventListener gLEventListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.remove(gLEventListener);
            this.listenersToBeInit.remove(gLEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose(GLAutoDrawable gLAutoDrawable) {
        Object object = this.listenersLock;
        synchronized (object) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).dispose(gLAutoDrawable);
            }
        }
    }

    private boolean init(GLEventListener gLEventListener, GLAutoDrawable gLAutoDrawable, boolean bl) {
        if (this.listenersToBeInit.remove(gLEventListener)) {
            gLEventListener.init(gLAutoDrawable);
            if (bl) {
                this.reshape(gLEventListener, gLAutoDrawable, 0, 0, gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight(), true);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(GLAutoDrawable gLAutoDrawable) {
        Object object = this.listenersLock;
        synchronized (object) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                GLEventListener gLEventListener = this.listeners.get(i);
                this.listenersToBeInit.add(gLEventListener);
                if (this.init(gLEventListener, gLAutoDrawable, false)) continue;
                throw new GLException("GLEventListener " + gLEventListener + " already initialized: " + gLAutoDrawable);
            }
        }
    }

    public final void display(GLAutoDrawable gLAutoDrawable) {
        this.displayImpl(gLAutoDrawable);
        if (!this.execGLRunnables(gLAutoDrawable)) {
            this.displayImpl(gLAutoDrawable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayImpl(GLAutoDrawable gLAutoDrawable) {
        Object object = this.listenersLock;
        synchronized (object) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                GLEventListener gLEventListener = this.listeners.get(i);
                this.init(gLEventListener, gLAutoDrawable, true);
                gLEventListener.display(gLAutoDrawable);
            }
        }
    }

    private void reshape(GLEventListener gLEventListener, GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            gLAutoDrawable.getGL().glViewport(n, n2, n3, n4);
        }
        gLEventListener.reshape(gLAutoDrawable, n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        Object object = this.listenersLock;
        synchronized (object) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.reshape(this.listeners.get(i), gLAutoDrawable, n, n2, n3, n4, 0 == i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execGLRunnables(GLAutoDrawable gLAutoDrawable) {
        boolean bl = true;
        if (this.glRunnables.size() > 0) {
            ArrayList<GLRunnable> arrayList = null;
            Object object = this.glRunnablesLock;
            synchronized (object) {
                if (this.glRunnables.size() > 0) {
                    arrayList = this.glRunnables;
                    this.glRunnables = new ArrayList();
                }
            }
            if (null != arrayList) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    bl = arrayList.get(i).run(gLAutoDrawable) && bl;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAnimator(GLAnimatorControl gLAnimatorControl) throws GLException {
        Object object = this.glRunnablesLock;
        synchronized (object) {
            if (this.animatorCtrl != gLAnimatorControl && null != gLAnimatorControl && null != this.animatorCtrl) {
                throw new GLException("Trying to register GLAnimatorControl " + gLAnimatorControl + ", where " + this.animatorCtrl + " is already registered. Unregister first.");
            }
            this.animatorCtrl = gLAnimatorControl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLAnimatorControl getAnimator() {
        Object object = this.glRunnablesLock;
        synchronized (object) {
            return this.animatorCtrl;
        }
    }

    public final boolean isExternalAnimatorRunning() {
        return null != this.animatorCtrl ? this.animatorCtrl.isStarted() && this.animatorCtrl.getThread() != Thread.currentThread() : false;
    }

    public final boolean isExternalAnimatorAnimating() {
        return null != this.animatorCtrl ? this.animatorCtrl.isAnimating() && this.animatorCtrl.getThread() != Thread.currentThread() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invoke(GLAutoDrawable gLAutoDrawable, boolean bl, GLRunnable gLRunnable) {
        Object object;
        if (null == gLAutoDrawable || null == gLRunnable) {
            return;
        }
        Throwable throwable = null;
        GLRunnableTask gLRunnableTask = null;
        Object object2 = object = new Object();
        synchronized (object2) {
            boolean bl2;
            Object object3 = this.glRunnablesLock;
            synchronized (object3) {
                bl2 = this.isExternalAnimatorAnimating();
                if (!bl2) {
                    bl = false;
                }
                gLRunnableTask = new GLRunnableTask(gLRunnable, bl ? object : null, bl);
                this.glRunnables.add(gLRunnableTask);
            }
            if (!bl2) {
                gLAutoDrawable.display();
            } else if (bl) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
                if (null == throwable) {
                    throwable = gLRunnableTask.getThrowable();
                }
                if (null != throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }
    }

    public final void setAutoSwapBufferMode(boolean bl) {
        this.autoSwapBufferMode = bl;
    }

    public final boolean getAutoSwapBufferMode() {
        return this.autoSwapBufferMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invokeGL(GLDrawable gLDrawable, GLContext gLContext, Runnable runnable, Runnable runnable2) {
        if (null == gLContext) {
            if (DEBUG) {
                GLException gLException = new GLException(Thread.currentThread().getName() + " Info: GLDrawableHelper " + this + ".invokeGL(): NULL GLContext");
                gLException.printStackTrace();
            }
            return;
        }
        if (null == runnable2 && !gLContext.isCreated()) {
            throw new GLException(Thread.currentThread().getName() + " GLDrawableHelper " + this + ".invokeGL(): Dispose case (no init action given): Native context is not created: " + gLContext);
        }
        GLContext gLContext2 = GLContext.getCurrent();
        Runnable runnable3 = perThreadInitAction.get();
        if (gLContext2 != null) {
            gLContext2.release();
        }
        int n = 0;
        try {
            n = gLContext.makeCurrent();
            if (n != 0) {
                if (null != runnable2) {
                    perThreadInitAction.set(runnable2);
                    if (n == 2) {
                        if (DEBUG) {
                            System.err.println("GLDrawableHelper " + this + ".invokeGL(): Running initAction");
                        }
                        runnable2.run();
                    }
                }
                if (null != runnable) {
                    if (DEBUG && VERBOSE) {
                        System.err.println("GLDrawableHelper " + this + ".invokeGL(): Running runnable");
                    }
                    runnable.run();
                    if (this.autoSwapBufferMode && null != runnable2 && gLDrawable != null) {
                        gLDrawable.swapBuffers();
                    }
                }
            }
        }
        finally {
            int n2;
            try {
                if (n != 0) {
                    gLContext.release();
                }
            }
            catch (Exception exception) {}
            if (gLContext2 != null && (n2 = gLContext2.makeCurrent()) == 2) {
                runnable3.run();
            }
        }
    }
}

