/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import com.jogamp.common.nio.PointerBuffer;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.SurfaceChangeable;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import jogamp.nativewindow.windows.BITMAPINFO;
import jogamp.nativewindow.windows.BITMAPINFOHEADER;
import jogamp.nativewindow.windows.GDI;
import jogamp.opengl.windows.wgl.WindowsBitmapWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;

public class WindowsBitmapWGLDrawable
extends WindowsWGLDrawable {
    private long origbitmap;
    private long hbitmap;

    protected WindowsBitmapWGLDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
        super(gLDrawableFactory, nativeSurface, true);
        this.create();
    }

    @Override
    protected void setRealizedImpl() {
        if (this.realized) {
            this.create();
        } else {
            this.destroyImpl();
        }
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new WindowsBitmapWGLContext(this, gLContext);
    }

    private void create() {
        long l;
        NativeSurface nativeSurface = this.getNativeSurface();
        if (DEBUG) {
            System.err.println("WindowsBitmapWGLDrawable (1): " + nativeSurface);
        }
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)nativeSurface.getGraphicsConfiguration().getNativeGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)windowsWGLGraphicsConfiguration.getRequestedCapabilities();
        int n = this.getWidth();
        int n2 = this.getHeight();
        BITMAPINFO bITMAPINFO = BITMAPINFO.create();
        BITMAPINFOHEADER bITMAPINFOHEADER = bITMAPINFO.getBmiHeader();
        int n3 = gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits() + gLCapabilitiesImmutable.getAlphaBits();
        bITMAPINFOHEADER.setBiSize(bITMAPINFOHEADER.size());
        bITMAPINFOHEADER.setBiWidth(n);
        bITMAPINFOHEADER.setBiHeight(-1 * n2);
        bITMAPINFOHEADER.setBiPlanes((short)1);
        bITMAPINFOHEADER.setBiBitCount((short)n3);
        bITMAPINFOHEADER.setBiXPelsPerMeter(0);
        bITMAPINFOHEADER.setBiYPelsPerMeter(0);
        bITMAPINFOHEADER.setBiClrUsed(0);
        bITMAPINFOHEADER.setBiClrImportant(0);
        bITMAPINFOHEADER.setBiCompression(0);
        int n4 = n * n2 * (n3 >> 3);
        bITMAPINFOHEADER.setBiSizeImage(n4);
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)1);
        this.hbitmap = GDI.CreateDIBSection(0L, bITMAPINFO, 0, pointerBuffer, 0L, 0);
        int n5 = GDI.GetLastError();
        if (DEBUG) {
            l = pointerBuffer.capacity() > 0 ? pointerBuffer.get(0) : 0L;
            System.err.println("WindowsBitmapWGLDrawable: pb sz/ptr " + pointerBuffer.capacity() + ", " + WindowsBitmapWGLDrawable.toHexString(l));
            System.err.println("WindowsBitmapWGLDrawable: " + n + "x" + n2 + ", bpp " + n3 + ", bytes " + n4 + ", header sz " + bITMAPINFOHEADER.size() + ", DIB ptr num " + pointerBuffer.capacity() + ", " + gLCapabilitiesImmutable + ", werr " + n5);
        }
        if (this.hbitmap == 0L) {
            throw new GLException("Error creating offscreen bitmap of " + nativeSurface + ", werr " + n5);
        }
        l = GDI.CreateCompatibleDC(0L);
        n5 = GDI.GetLastError();
        if (l == 0L) {
            GDI.DeleteObject(this.hbitmap);
            this.hbitmap = 0L;
            throw new GLException("Error creating device context for offscreen OpenGL context, werr " + n5);
        }
        ((SurfaceChangeable)((Object)nativeSurface)).setSurfaceHandle(l);
        if (DEBUG) {
            System.err.println("WindowsBitmapWGLDrawable (2): " + nativeSurface);
        }
        if ((this.origbitmap = GDI.SelectObject(l, this.hbitmap)) == 0L) {
            GDI.DeleteObject(this.hbitmap);
            this.hbitmap = 0L;
            GDI.DeleteDC(l);
            l = 0L;
            throw new GLException("Error selecting bitmap into new device context");
        }
        windowsWGLGraphicsConfiguration.updateGraphicsConfiguration(this.getFactory(), nativeSurface, null);
    }

    @Override
    protected void destroyImpl() {
        NativeSurface nativeSurface = this.getNativeSurface();
        if (nativeSurface.getSurfaceHandle() != 0L) {
            GDI.SelectObject(nativeSurface.getSurfaceHandle(), this.origbitmap);
            GDI.DeleteObject(this.hbitmap);
            GDI.DeleteDC(nativeSurface.getSurfaceHandle());
            this.origbitmap = 0L;
            this.hbitmap = 0L;
            ((SurfaceChangeable)((Object)nativeSurface)).setSurfaceHandle(0L);
        }
    }

    @Override
    protected void swapBuffersImpl() {
        if (DEBUG) {
            System.err.println("unhandled swapBuffersImpl() called for: " + this);
        }
    }
}

