/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.SurfaceChangeable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.windows.GDI;
import jogamp.opengl.windows.wgl.WGLExt;
import jogamp.opengl.windows.wgl.WGLGLCapabilities;
import jogamp.opengl.windows.wgl.WindowsPbufferWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLDrawableFactory;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;

public class WindowsPbufferWGLDrawable
extends WindowsWGLDrawable {
    private WGLExt cachedWGLExt;
    private long buffer;
    private int floatMode;

    protected WindowsPbufferWGLDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface, WindowsWGLDrawableFactory.SharedResource sharedResource) {
        super(gLDrawableFactory, nativeSurface, true);
        if (DEBUG) {
            System.out.println("Pbuffer config: " + this.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration());
        }
        this.createPbuffer(sharedResource);
        if (DEBUG) {
            System.err.println("Created pbuffer " + this);
        }
    }

    @Override
    protected void setRealizedImpl() {
        if (this.realized) {
            throw new GLException("Recreation via setRealized not supported.");
        }
        this.destroyImpl();
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new WindowsPbufferWGLContext(this, gLContext);
    }

    @Override
    protected void destroyImpl() {
        NativeSurface nativeSurface = this.getNativeSurface();
        if (0L != this.buffer) {
            WGLExt wGLExt = this.cachedWGLExt;
            if (nativeSurface.getSurfaceHandle() != 0L) {
                if (wGLExt.wglReleasePbufferDCARB(this.buffer, nativeSurface.getSurfaceHandle()) == 0) {
                    throw new GLException("Error releasing pbuffer device context: error code " + GDI.GetLastError());
                }
                ((SurfaceChangeable)((Object)nativeSurface)).setSurfaceHandle(0L);
            }
            if (!wGLExt.wglDestroyPbufferARB(this.buffer)) {
                throw new GLException("Error destroying pbuffer: error code " + GDI.GetLastError());
            }
            this.buffer = 0L;
        }
    }

    public long getPbufferHandle() {
        return this.buffer;
    }

    public int getFloatingPointMode() {
        return this.floatMode;
    }

    @Override
    protected void swapBuffersImpl() {
        if (DEBUG) {
            System.err.println("unhandled swapBuffersImpl() called for: " + this);
        }
    }

    private void createPbuffer(WindowsWGLDrawableFactory.SharedResource sharedResource) {
        int n;
        int n2;
        int[] nArray;
        int[] nArray2;
        long l = sharedResource.getDrawable().getNativeSurface().getSurfaceHandle();
        WGLExt wGLExt = sharedResource.getContext().getWGLExt();
        int[] nArray3 = new int[512];
        float[] fArray = new float[1];
        int[] nArray4 = new int[1];
        int n3 = 0;
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)this.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)windowsWGLGraphicsConfiguration.getChosenCapabilities();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        if (DEBUG) {
            System.out.println("Pbuffer parentHdc = " + WindowsPbufferWGLDrawable.toHexString(l));
            System.out.println("Pbuffer chosenCaps: " + gLCapabilitiesImmutable);
        }
        if (!WindowsWGLGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable, nArray3, sharedResource, -1, nArray4)) {
            throw new GLException("Pbuffer-related extensions not supported");
        }
        this.floatMode = nArray4[0];
        boolean bl = gLCapabilitiesImmutable.getPbufferRenderToTexture();
        boolean bl2 = gLCapabilitiesImmutable.getPbufferRenderToTextureRectangle();
        boolean bl3 = gLCapabilitiesImmutable.getPbufferFloatingPointBuffers();
        boolean bl4 = false;
        if (bl3) {
            boolean bl5 = bl4 = this.floatMode == 2;
        }
        if (!wGLExt.wglChoosePixelFormatARB(l, nArray3, 0, fArray, 0, 256, nArray2 = new int[256], 0, nArray = new int[1], 0)) {
            throw new GLException("pbuffer creation error: wglChoosePixelFormat() failed");
        }
        int n4 = nArray[0];
        if (n4 <= 0) {
            throw new GLException("pbuffer creation error: Couldn't find a suitable pixel format");
        }
        if (DEBUG) {
            System.err.println("" + n4 + " suitable pixel formats found");
            for (n2 = 0; n2 < n4; ++n2) {
                WGLGLCapabilities wGLGLCapabilities = WindowsWGLGraphicsConfiguration.wglARBPFID2GLCapabilities(sharedResource, l, nArray2[n2], gLProfile, false, true);
                System.err.println("pixel format " + nArray2[n2] + " (index " + n2 + "): " + wGLGLCapabilities);
            }
        }
        n2 = 0;
        long l2 = 0L;
        for (n = 0; n < n4; ++n) {
            int n5 = nArray2[n];
            n3 = 0;
            if (bl) {
                nArray3[n3++] = 8306;
                nArray3[n3++] = bl3 ? 8375 : 8310;
                nArray3[n3++] = 8307;
                nArray3[n3++] = bl2 ? 8354 : 8314;
                nArray3[n3++] = 8308;
                nArray3[n3++] = 0;
                nArray3[n3++] = 8243;
                nArray3[n3++] = 0;
            }
            nArray3[n3++] = 0;
            l2 = wGLExt.wglCreatePbufferARB(l, n5, this.getWidth(), this.getHeight(), nArray3, 0);
            if (l2 != 0L) break;
        }
        if (0L == l2) {
            throw new GLException("pbuffer creation error: wglCreatePbuffer() failed: tried " + n4 + " pixel formats, last error was: " + WindowsPbufferWGLDrawable.wglGetLastError());
        }
        n2 = nArray2[n];
        long l3 = wGLExt.wglGetPbufferDCARB(l2);
        if (l3 == 0L) {
            throw new GLException("pbuffer creation error: wglGetPbufferDC() failed");
        }
        NativeSurface nativeSurface = this.getNativeSurface();
        this.buffer = l2;
        ((SurfaceChangeable)((Object)nativeSurface)).setSurfaceHandle(l3);
        this.cachedWGLExt = wGLExt;
        Object object = WindowsWGLGraphicsConfiguration.wglARBPFID2GLCapabilities(sharedResource, l, n2, gLProfile, false, true);
        if (null == object) {
            throw new GLException("pbuffer creation error: unable to re-query chosen PFD ID: " + n2 + ", hdc " + WindowsPbufferWGLDrawable.toHexString(l3));
        }
        if (((Capabilities)object).isOnscreen() || !((GLCapabilities)object).isPBuffer()) {
            throw new GLException("Error: Selected Onscreen Caps for PBuffer: " + object);
        }
        windowsWGLGraphicsConfiguration.setCapsPFD((WGLGLCapabilities)object);
        object = new int[1];
        wGLExt.wglQueryPbufferARB(this.buffer, 8244, (int[])object, 0);
        Object object2 = object[0];
        wGLExt.wglQueryPbufferARB(this.buffer, 8245, (int[])object, 0);
        Object object3 = object[0];
        ((SurfaceChangeable)((Object)nativeSurface)).setSize((int)object2, (int)object3);
    }

    private static String wglGetLastError() {
        return WindowsWGLDrawableFactory.wglGetLastError();
    }
}

