/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.util.GLPixelStorageModes;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLDrawable;

public class GLReadBufferUtil {
    protected final int components;
    protected final int alignment;
    protected final Texture readTexture;
    protected final GLPixelStorageModes psm;
    protected int readPixelSizeLast = 0;
    protected ByteBuffer readPixelBuffer = null;
    protected TextureData readTextureData = null;

    public GLReadBufferUtil(boolean bl, boolean bl2) {
        this.components = bl ? 4 : 3;
        this.alignment = bl ? 4 : 1;
        this.readTexture = bl2 ? new Texture(3553) : null;
        this.psm = new GLPixelStorageModes();
    }

    public boolean isValid() {
        return null != this.readTextureData && null != this.readPixelBuffer;
    }

    public ByteBuffer getPixelBuffer() {
        return this.readPixelBuffer;
    }

    public void rewindPixelBuffer() {
        if (null != this.readPixelBuffer) {
            this.readPixelBuffer.rewind();
        }
    }

    public TextureData getTextureData() {
        return this.readTextureData;
    }

    public Texture getTexture() {
        return this.readTexture;
    }

    public void write(File file) {
        try {
            TextureIO.write(this.readTextureData, file);
            this.rewindPixelBuffer();
        }
        catch (IOException iOException) {
            throw new RuntimeException("can not write to file: " + file.getAbsolutePath(), iOException);
        }
    }

    public void readPixels(GL gL, GLDrawable gLDrawable, boolean bl) {
        int n;
        int n2;
        if (4 == this.components) {
            n2 = 6408;
            n = 6408;
        } else {
            n2 = 6407;
            n = 6407;
        }
        int n3 = gLDrawable.getWidth() * gLDrawable.getHeight() * this.components;
        boolean bl2 = false;
        if (n3 > this.readPixelSizeLast) {
            this.readPixelBuffer = Buffers.newDirectByteBuffer((int)n3);
            this.readPixelSizeLast = n3;
            try {
                this.readTextureData = new TextureData(gL.getGLProfile(), n2, gLDrawable.getWidth(), gLDrawable.getHeight(), 0, n, 5121, false, false, bl, this.readPixelBuffer, null);
                bl2 = true;
            }
            catch (Exception exception) {
                this.readTextureData = null;
                this.readPixelBuffer = null;
                this.readPixelSizeLast = 0;
                throw new RuntimeException("can not fetch offscreen texture", exception);
            }
        }
        if (null != this.readPixelBuffer) {
            this.psm.setAlignment(gL, this.alignment, this.alignment);
            this.readPixelBuffer.clear();
            gL.glReadPixels(0, 0, gLDrawable.getWidth(), gLDrawable.getHeight(), n, 5121, this.readPixelBuffer);
            this.readPixelBuffer.rewind();
            if (null != this.readTexture) {
                if (bl2) {
                    this.readTexture.updateImage(gL, this.readTextureData);
                } else {
                    this.readTexture.updateSubImage(gL, this.readTextureData, 0, 0, 0, 0, 0, gLDrawable.getWidth(), gLDrawable.getHeight());
                }
                this.readPixelBuffer.rewind();
            }
            this.psm.restore(gL);
        }
    }

    public void dispose(GL gL) {
        if (null != this.readTexture) {
            this.readTexture.destroy(gL);
            this.readTextureData = null;
        }
        if (null != this.readPixelBuffer) {
            this.readPixelBuffer.clear();
            this.readPixelBuffer = null;
        }
        this.readPixelSizeLast = 0;
    }
}

