/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.util.ReflectionUtil;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.ProxySurface;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.GLProfile;
import jogamp.common.Debug;

public abstract class GLDrawableFactory {
    private static final String nativeOSType;
    static final String macosxFactoryClassNameCGL = "jogamp.opengl.macosx.cgl.MacOSXCGLDrawableFactory";
    static final String macosxFactoryClassNameAWTCGL = "jogamp.opengl.macosx.cgl.awt.MacOSXAWTCGLDrawableFactory";
    private static volatile boolean initialized;
    private static GLDrawableFactory eglFactory;
    private static GLDrawableFactory nativeOSFactory;
    protected static ArrayList<GLDrawableFactory> glDrawableFactories;
    private static boolean factoryShutdownHookRegistered;
    private static Thread factoryShutdownHook;

    protected static final void initialize() {
        GLDrawableFactory gLDrawableFactory;
        block16: {
            ClassLoader classLoader;
            block15: {
                if (initialized) {
                    return;
                }
                initialized = true;
                GLDrawableFactory.registerFactoryShutdownHook();
                gLDrawableFactory = null;
                String string = Debug.getProperty((String)"jogl.gldrawablefactory.class.name", (boolean)true, (AccessControlContext)AccessController.getContext());
                classLoader = GLDrawableFactory.class.getClassLoader();
                if (null == string) {
                    if (nativeOSType.equals("X11")) {
                        string = "jogamp.opengl.x11.glx.X11GLXDrawableFactory";
                    } else if (nativeOSType.equals("Windows")) {
                        string = "jogamp.opengl.windows.wgl.WindowsWGLDrawableFactory";
                    } else if (nativeOSType.equals("MacOSX")) {
                        string = ReflectionUtil.isClassAvailable((String)macosxFactoryClassNameAWTCGL, (ClassLoader)classLoader) ? macosxFactoryClassNameAWTCGL : macosxFactoryClassNameCGL;
                    } else if (GLProfile.DEBUG) {
                        System.err.println("GLDrawableFactory.static - No native OS Factory for: " + nativeOSType + "; May use EGLDrawableFactory, if available.");
                    }
                }
                if (null != string) {
                    if (GLProfile.DEBUG) {
                        System.err.println("GLDrawableFactory.static - Native OS Factory for: " + nativeOSType + ": " + string);
                    }
                    try {
                        gLDrawableFactory = (GLDrawableFactory)ReflectionUtil.createInstance((String)string, (ClassLoader)classLoader);
                    }
                    catch (JogampRuntimeException jogampRuntimeException) {
                        if (!GLProfile.DEBUG) break block15;
                        System.err.println("Info: GLDrawableFactory.static - Native Platform: " + nativeOSType + " - not available: " + string);
                        jogampRuntimeException.printStackTrace();
                    }
                }
            }
            nativeOSFactory = gLDrawableFactory;
            gLDrawableFactory = null;
            try {
                gLDrawableFactory = (GLDrawableFactory)ReflectionUtil.createInstance((String)"jogamp.opengl.egl.EGLDrawableFactory", (ClassLoader)classLoader);
            }
            catch (JogampRuntimeException jogampRuntimeException) {
                if (!GLProfile.DEBUG) break block16;
                System.err.println("Info: GLDrawableFactory.static - EGLDrawableFactory - not available");
                jogampRuntimeException.printStackTrace();
            }
        }
        eglFactory = gLDrawableFactory;
    }

    private static synchronized void registerFactoryShutdownHook() {
        if (factoryShutdownHookRegistered) {
            return;
        }
        factoryShutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                GLDrawableFactory.shutdownImpl();
            }
        });
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Runtime.getRuntime().addShutdownHook(factoryShutdownHook);
                return null;
            }
        });
        factoryShutdownHookRegistered = true;
    }

    private static synchronized void unregisterFactoryShutdownHook() {
        if (!factoryShutdownHookRegistered) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Runtime.getRuntime().removeShutdownHook(factoryShutdownHook);
                return null;
            }
        });
        factoryShutdownHookRegistered = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdownImpl() {
        ArrayList<GLDrawableFactory> arrayList = glDrawableFactories;
        synchronized (arrayList) {
            for (int i = 0; i < glDrawableFactories.size(); ++i) {
                GLDrawableFactory gLDrawableFactory = glDrawableFactories.get(i);
                gLDrawableFactory.shutdownInstance();
            }
            glDrawableFactories.clear();
        }
    }

    protected static void shutdown() {
        GLDrawableFactory.unregisterFactoryShutdownHook();
        GLDrawableFactory.shutdownImpl();
        eglFactory = null;
        nativeOSFactory = null;
        initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GLDrawableFactory() {
        ArrayList<GLDrawableFactory> arrayList = glDrawableFactories;
        synchronized (arrayList) {
            glDrawableFactories.add(this);
        }
    }

    protected void enterThreadCriticalZone() {
    }

    protected void leaveThreadCriticalZone() {
    }

    protected abstract void shutdownInstance();

    public abstract AbstractGraphicsDevice getDefaultDevice();

    public abstract boolean getIsDeviceCompatible(AbstractGraphicsDevice var1);

    protected final AbstractGraphicsDevice validateDevice(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null == abstractGraphicsDevice) {
            abstractGraphicsDevice = this.getDefaultDevice();
            if (null == abstractGraphicsDevice) {
                throw new InternalError("no default device");
            }
            if (GLProfile.DEBUG) {
                System.err.println("Info: GLDrawableFactory.validateDevice: using default device : " + abstractGraphicsDevice);
            }
        } else if (!this.getIsDeviceCompatible(abstractGraphicsDevice)) {
            if (GLProfile.DEBUG) {
                System.err.println("Info: GLDrawableFactory.validateDevice: device not compatible : " + abstractGraphicsDevice);
            }
            return null;
        }
        return abstractGraphicsDevice;
    }

    public abstract boolean getWasSharedContextCreated(AbstractGraphicsDevice var1);

    public final GLContext getOrCreateSharedContext(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null != (abstractGraphicsDevice = this.validateDevice(abstractGraphicsDevice))) {
            return this.getOrCreateSharedContextImpl(abstractGraphicsDevice);
        }
        return null;
    }

    protected abstract GLContext getOrCreateSharedContextImpl(AbstractGraphicsDevice var1);

    public static GLDrawableFactory getDesktopFactory() {
        return nativeOSFactory;
    }

    public static GLDrawableFactory getEGLFactory() {
        return eglFactory;
    }

    public static GLDrawableFactory getFactory(GLProfile gLProfile) throws GLException {
        return GLDrawableFactory.getFactoryImpl(gLProfile.getImplName());
    }

    protected static GLDrawableFactory getFactoryImpl(String string) throws GLException {
        if (GLProfile.usesNativeGLES(string)) {
            if (null == eglFactory) {
                throw new GLException("No EGLDrawableFactory available for profile: " + string);
            }
            return eglFactory;
        }
        if (null == nativeOSFactory) {
            throw new GLException("No native platform GLDrawableFactory available for profile: " + string);
        }
        return nativeOSFactory;
    }

    protected static GLDrawableFactory getFactoryImpl(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        if (null != nativeOSFactory && nativeOSFactory.getIsDeviceCompatible(abstractGraphicsDevice)) {
            return nativeOSFactory;
        }
        if (null != eglFactory && eglFactory.getIsDeviceCompatible(abstractGraphicsDevice)) {
            return eglFactory;
        }
        throw new GLException("No native platform GLDrawableFactory, nor EGLDrawableFactory available: " + abstractGraphicsDevice);
    }

    public final List<GLCapabilitiesImmutable> getAvailableCapabilities(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null != (abstractGraphicsDevice = this.validateDevice(abstractGraphicsDevice))) {
            return this.getAvailableCapabilitiesImpl(abstractGraphicsDevice);
        }
        return null;
    }

    protected abstract List<GLCapabilitiesImmutable> getAvailableCapabilitiesImpl(AbstractGraphicsDevice var1);

    public abstract GLDrawable createGLDrawable(NativeSurface var1) throws IllegalArgumentException, GLException;

    public abstract GLDrawable createOffscreenDrawable(AbstractGraphicsDevice var1, GLCapabilitiesImmutable var2, GLCapabilitiesChooser var3, int var4, int var5) throws GLException;

    public abstract NativeSurface createOffscreenSurface(AbstractGraphicsDevice var1, GLCapabilitiesImmutable var2, GLCapabilitiesChooser var3, int var4, int var5);

    public abstract ProxySurface createProxySurface(AbstractGraphicsDevice var1, long var2, GLCapabilitiesImmutable var4, GLCapabilitiesChooser var5);

    public abstract boolean canCreateGLPbuffer(AbstractGraphicsDevice var1);

    public abstract GLPbuffer createGLPbuffer(AbstractGraphicsDevice var1, GLCapabilitiesImmutable var2, GLCapabilitiesChooser var3, int var4, int var5, GLContext var6) throws GLException;

    public abstract GLContext createExternalGLContext() throws GLException;

    public abstract boolean canCreateExternalGLDrawable(AbstractGraphicsDevice var1);

    public abstract GLDrawable createExternalGLDrawable() throws GLException;

    static {
        initialized = false;
        glDrawableFactories = new ArrayList();
        factoryShutdownHookRegistered = false;
        factoryShutdownHook = null;
        nativeOSType = NativeWindowFactory.getNativeWindowType(true);
    }
}

