/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import java.util.Comparator;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class EGLGLCapabilities
extends GLCapabilities {
    final long eglcfg;
    final int eglcfgid;
    final int renderableType;
    int nativeVisualID;

    public EGLGLCapabilities(long l, int n, GLProfile gLProfile, int n2) {
        super(null != gLProfile ? gLProfile : EGLGLCapabilities.getCompatible(n2));
        this.eglcfg = l;
        this.eglcfgid = n;
        if (!EGLGLCapabilities.isCompatible(gLProfile, n2)) {
            throw new GLException("Incompatible " + gLProfile + " with EGL-RenderableType[" + EGLGLCapabilities.renderableTypeToString(null, n2) + "]");
        }
        this.renderableType = n2;
    }

    @Override
    public Object cloneMutable() {
        return this.clone();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (RuntimeException runtimeException) {
            throw new GLException(runtimeException);
        }
    }

    public final long getEGLConfig() {
        return this.eglcfg;
    }

    public final int getEGLConfigID() {
        return this.eglcfgid;
    }

    public final int getRenderableType() {
        return this.renderableType;
    }

    public final void setNativeVisualID(int n) {
        this.nativeVisualID = n;
    }

    public final int getNativeVisualID() {
        return this.nativeVisualID;
    }

    public static boolean isCompatible(GLProfile gLProfile, int n) {
        if (null == gLProfile) {
            return true;
        }
        if (0 != (n & 1) && gLProfile.usesNativeGLES1()) {
            return true;
        }
        if (0 != (n & 4) && gLProfile.usesNativeGLES2()) {
            return true;
        }
        return 0 != (n & 8) && !gLProfile.usesNativeGLES();
    }

    public static GLProfile getCompatible(int n) {
        if (0 != (n & 4) && GLProfile.isAvailable("GLES2")) {
            return GLProfile.get("GLES2");
        }
        if (0 != (n & 1) && GLProfile.isAvailable("GLES1")) {
            return GLProfile.get("GLES1");
        }
        if (0 != (n & 8)) {
            return GLProfile.getDefault();
        }
        return null;
    }

    public static StringBuffer renderableTypeToString(StringBuffer stringBuffer, int n) {
        if (null == stringBuffer) {
            stringBuffer = new StringBuffer();
        }
        boolean bl = true;
        if (0 != (n & 8)) {
            stringBuffer.append("GL");
            bl = false;
        }
        if (0 != (n & 1)) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("GLES1");
            bl = false;
        }
        if (0 != (n & 4)) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("GLES2");
            bl = false;
        }
        if (0 != (n & 0x30A1)) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("VG");
            bl = false;
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer toString(StringBuffer stringBuffer) {
        if (null == stringBuffer) {
            stringBuffer = new StringBuffer();
        }
        stringBuffer.append("0x").append(Long.toHexString(this.eglcfgid)).append(": ");
        stringBuffer.append("vid 0x").append(Integer.toHexString(this.nativeVisualID)).append(", ");
        super.toString(stringBuffer);
        stringBuffer.append(", [");
        EGLGLCapabilities.renderableTypeToString(stringBuffer, this.renderableType);
        return stringBuffer.append("]");
    }

    public static class EglCfgIDComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            EGLGLCapabilities eGLGLCapabilities;
            long l;
            if (!(object instanceof EGLGLCapabilities)) {
                Class<?> clazz = null != object ? object.getClass() : null;
                throw new ClassCastException("arg1 not a EGLGLCapabilities object: " + clazz);
            }
            if (!(object2 instanceof EGLGLCapabilities)) {
                Class<?> clazz = null != object2 ? object2.getClass() : null;
                throw new ClassCastException("arg2 not a EGLGLCapabilities object: " + clazz);
            }
            EGLGLCapabilities eGLGLCapabilities2 = (EGLGLCapabilities)object;
            long l2 = eGLGLCapabilities2.getEGLConfigID();
            if (l2 > (l = (long)(eGLGLCapabilities = (EGLGLCapabilities)object2).getEGLConfigID())) {
                return 1;
            }
            if (l2 < l) {
                return -1;
            }
            return 0;
        }
    }
}

