/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.io.File;
import java.io.FileReader;
import java.text.DecimalFormat;
import opennlp.maxent.BasicContextGenerator;
import opennlp.maxent.BasicEventStream;
import opennlp.maxent.ContextGenerator;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.model.AbstractModel;
import opennlp.model.Event;
import opennlp.model.GenericModelReader;
import opennlp.model.MaxentModel;
import opennlp.model.RealValueFileEventStream;

public class ModelApplier {
    MaxentModel _model;
    ContextGenerator _cg = new BasicContextGenerator(",");
    int counter = 1;
    public static final DecimalFormat ROUNDED_FORMAT = new DecimalFormat("0.000");

    public ModelApplier(MaxentModel m) {
        this._model = m;
    }

    private void eval(Event event) {
        this.eval(event, false);
    }

    private void eval(Event event, boolean real) {
        double[] ocs;
        String outcome = event.getOutcome();
        String[] context = event.getContext();
        if (!real) {
            ocs = this._model.eval(context);
        } else {
            float[] values = RealValueFileEventStream.parseContexts(context);
            ocs = this._model.eval(context, values);
        }
        int best = 0;
        for (int i = 1; i < ocs.length; ++i) {
            if (!(ocs[i] > ocs[best])) continue;
            best = i;
        }
        String predictedLabel = this._model.getOutcome(best);
        String madeError = "+";
        if (predictedLabel.equals(outcome)) {
            madeError = "";
        }
        System.out.println(this.counter + "\t0:" + outcome + "\t0:" + this._model.getOutcome(best) + "\t" + madeError + "\t" + ROUNDED_FORMAT.format(ocs[best]));
        ++this.counter;
    }

    private static void usage() {
        System.err.println("java ModelApplier [-real] modelFile dataFile");
        System.exit(1);
    }

    public static void main(String[] args) {
        boolean real = false;
        String type = "maxent";
        int ai = 0;
        if (args.length > 0) {
            while (args[ai].startsWith("-")) {
                if (args[ai].equals("-real")) {
                    real = true;
                } else if (args[ai].equals("-perceptron")) {
                    type = "perceptron";
                } else {
                    ModelApplier.usage();
                }
                ++ai;
            }
            String modelFileName = args[ai++];
            String dataFileName = args[ai++];
            ModelApplier predictor = null;
            try {
                AbstractModel m = new GenericModelReader(new File(modelFileName)).getModel();
                predictor = new ModelApplier(m);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
            System.out.println("=== Predictions on test data ===\n");
            System.out.println(" inst#     actual  predicted error prediction");
            try {
                BasicEventStream es = new BasicEventStream(new PlainTextByLineDataStream(new FileReader(new File(dataFileName))), ",");
                while (es.hasNext()) {
                    predictor.eval(es.next(), real);
                }
                return;
            }
            catch (Exception e) {
                System.out.println("Unable to read from specified file: " + modelFileName);
                System.out.println();
                e.printStackTrace();
            }
        }
    }
}

