/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkSample {
    private final List<String> sentence;
    private final List<String> tags;
    private final List<String> preds;

    public ChunkSample(String[] sentence, String[] tags, String[] preds) {
        if (sentence.length != tags.length || tags.length != preds.length) {
            throw new IllegalArgumentException("All arrays must have the same length!");
        }
        this.sentence = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(sentence)));
        this.tags = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(tags)));
        this.preds = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(preds)));
    }

    public ChunkSample(List<String> sentence, List<String> tags, List<String> preds) {
        this.sentence = Collections.unmodifiableList(new ArrayList<String>(sentence));
        this.tags = Collections.unmodifiableList(new ArrayList<String>(tags));
        this.preds = Collections.unmodifiableList(new ArrayList<String>(preds));
    }

    public String[] getSentence() {
        return this.sentence.toArray(new String[this.sentence.size()]);
    }

    public String[] getTags() {
        return this.tags.toArray(new String[this.tags.size()]);
    }

    public String[] getPreds() {
        return this.preds.toArray(new String[this.preds.size()]);
    }

    public String toString() {
        StringBuilder chunkString = new StringBuilder();
        int cn = this.preds.size();
        for (int ci = 0; ci < cn; ++ci) {
            if (ci > 0 && !this.preds.get(ci).startsWith("I-") && !this.preds.get(ci - 1).equals("O")) {
                chunkString.append(" ]");
            }
            if (this.preds.get(ci).startsWith("B-")) {
                chunkString.append(" [" + this.preds.get(ci).substring(2));
            }
            chunkString.append(" " + this.getSentence()[ci] + "_" + this.getTags()[ci]);
        }
        return chunkString.toString();
    }
}

