/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.util.model.BaseModel;

public final class CmdLineUtil {
    static final int IO_BUFFER_SIZE = 0x100000;

    private CmdLineUtil() {
    }

    public static void checkInputFile(String name, File inFile) {
        boolean isFailure;
        if (inFile.isDirectory()) {
            System.err.println("The " + name + " file is a directory!");
            isFailure = true;
        } else if (!inFile.exists()) {
            System.err.println("The " + name + " file does not exist!");
            isFailure = true;
        } else if (!inFile.canRead()) {
            System.err.println("No permissions to read the " + name + " file!");
            isFailure = true;
        } else {
            isFailure = false;
        }
        if (isFailure) {
            System.err.println("Path: " + inFile.getAbsolutePath());
            throw new TerminateToolException(-1);
        }
    }

    public static void checkOutputFile(String name, File outFile) {
        boolean isFailure = true;
        if (outFile.exists()) {
            if (outFile.isDirectory()) {
                System.err.println("The " + name + " file is a directory!");
            } else if (outFile.isFile()) {
                if (outFile.canWrite()) {
                    isFailure = false;
                } else {
                    System.err.println("No permissions to write the " + name + " file!");
                }
            } else {
                System.err.println("The " + name + " file is not a normal file!");
            }
        } else {
            File parentDir = outFile.getAbsoluteFile().getParentFile();
            if (parentDir != null && parentDir.exists()) {
                if (parentDir.canWrite()) {
                    isFailure = false;
                } else {
                    System.err.println("No permissions to create the " + name + " file!");
                }
            } else {
                System.err.println("The parent directory of the " + name + " file does not exist, " + "please create it first!");
            }
        }
        if (isFailure) {
            System.err.println("Path: " + outFile.getAbsolutePath());
            throw new TerminateToolException(-1);
        }
    }

    public static FileInputStream openInFile(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            System.err.println("File cannot be found: " + e.getMessage());
            throw new TerminateToolException(-1);
        }
    }

    public static void writeModel(String modelName, File modelFile, BaseModel model) {
        CmdLineUtil.checkOutputFile(modelName + " model", modelFile);
        System.err.print("Writing " + modelName + " model ... ");
        long beginModelWritingTime = System.currentTimeMillis();
        OutputStream modelOut = null;
        try {
            modelOut = new BufferedOutputStream(new FileOutputStream(modelFile), 0x100000);
            model.serialize(modelOut);
        }
        catch (IOException e) {
            System.err.println("failed");
            System.err.println("Error during writing model file: " + e.getMessage());
            throw new TerminateToolException(-1);
        }
        finally {
            if (modelOut != null) {
                try {
                    modelOut.close();
                }
                catch (IOException e) {
                    System.err.println("Failed to properly close model file: " + e.getMessage());
                }
            }
        }
        long modelWritingDuration = System.currentTimeMillis() - beginModelWritingTime;
        System.err.printf("done (%.3fs)\n", (double)modelWritingDuration / 1000.0);
        System.err.println();
        System.err.println("Wrote " + modelName + " model to");
        System.err.println("path: " + modelFile.getAbsolutePath());
        System.err.println();
    }

    public static String getParameter(String param, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-") || !args[i].equals(param) || ++i >= args.length) continue;
            return args[i];
        }
        return null;
    }

    public static Integer getIntParameter(String param, String[] args) {
        String value = CmdLineUtil.getParameter(param, args);
        try {
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static Double getDoubleParameter(String param, String[] args) {
        String value = CmdLineUtil.getParameter(param, args);
        try {
            if (value != null) {
                return Double.parseDouble(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static Charset getEncodingParameter(String[] args) {
        String charsetName = CmdLineUtil.getParameter("-encoding", args);
        try {
            if (charsetName != null) {
                if (Charset.isSupported(charsetName)) {
                    return Charset.forName(charsetName);
                }
                System.out.println("Error: Unsuppoted encoding " + charsetName + ".");
                throw new TerminateToolException(-1);
            }
        }
        catch (IllegalCharsetNameException e) {
            System.out.println("Error: encoding name(" + e.getCharsetName() + ") is invalid.");
            throw new TerminateToolException(-1);
        }
        return null;
    }

    public static void checkLanguageCode(String code) {
        List<String> languageCodes = Arrays.asList(Locale.getISOLanguages());
        if (!languageCodes.contains(code)) {
            System.err.println("Unkown language code, must be an ISO 639 code!");
            throw new TerminateToolException(-1);
        }
    }

    public static boolean containsParam(String param, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(param)) continue;
            return true;
        }
        return false;
    }

    public static void printTrainingIoError(IOException e) {
        System.err.println("IO error while reading training data or indexing data: " + e.getMessage());
    }

    public static void handleStdinIoError(IOException e) {
        System.err.println("IO Error while reading from stdin: " + e.getMessage());
        throw new TerminateToolException(-1);
    }
}

