/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.namefind.TokenNameFinderModelLoader;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;

public final class TokenNameFinderTool
implements CmdLineTool {
    public String getName() {
        return "TokenNameFinder";
    }

    public String getShortDescription() {
        return "learnable name finder";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model1 model2 ... modelN < sentences";
    }

    public void run(String[] args) {
        if (args.length == 0) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        NameFinderME[] nameFinders = new NameFinderME[args.length];
        for (int i = 0; i < nameFinders.length; ++i) {
            TokenNameFinderModel model = (TokenNameFinderModel)new TokenNameFinderModelLoader().load(new File(args[i]));
            nameFinders[i] = new NameFinderME(model);
        }
        PlainTextByLineStream untokenizedLineStream = new PlainTextByLineStream(new InputStreamReader(System.in));
        PerformanceMonitor perfMon = new PerformanceMonitor(System.err, "sent");
        perfMon.start();
        try {
            String line;
            while ((line = (String)untokenizedLineStream.read()) != null) {
                String[] whitespaceTokenizerLine = WhitespaceTokenizer.INSTANCE.tokenize(line);
                if (whitespaceTokenizerLine.length == 0) {
                    for (int i = 0; i < nameFinders.length; ++i) {
                        nameFinders[i].clearAdaptiveData();
                    }
                }
                ArrayList names = new ArrayList();
                for (NameFinderME nameFinder : nameFinders) {
                    Collections.addAll(names, nameFinder.find(whitespaceTokenizerLine));
                }
                Span[] reducedNames = NameFinderME.dropOverlappingSpans(names.toArray(new Span[names.size()]));
                NameSample nameSample = new NameSample(whitespaceTokenizerLine, reducedNames, false);
                System.out.println(nameSample.toString());
                perfMon.incrementCounter();
            }
        }
        catch (IOException e) {
            CmdLineUtil.handleStdinIoError(e);
        }
        perfMon.stopAndPrintFinalResult();
    }
}

