/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.postag;

import opennlp.tools.cmdline.BasicTrainingParameters;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.util.model.ModelType;

class TrainingParameters
extends BasicTrainingParameters {
    private final String dictPath;
    private final ModelType model;

    TrainingParameters(String[] args) {
        super(args);
        this.dictPath = CmdLineUtil.getParameter("-dict", args);
        String modelString = CmdLineUtil.getParameter("-model-type", args);
        if (modelString == null) {
            modelString = "maxent";
        }
        this.model = modelString.equals("maxent") ? ModelType.MAXENT : (modelString.equals("perceptron") ? ModelType.PERCEPTRON : (modelString.equals("perceptron_sequence") ? ModelType.PERCEPTRON_SEQUENCE : null));
    }

    ModelType getModel() {
        return this.model;
    }

    String getDictionaryPath() {
        return this.dictPath;
    }

    public boolean isValid() {
        if (this.model == null) {
            return false;
        }
        return super.isValid();
    }

    public static String getParameterUsage() {
        return BasicTrainingParameters.getParameterUsage() + " [-dict tagdict] [-model maxent|perceptron|perceptron_sequence]";
    }
}

