/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.tokenizer;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.tokenizer.DetokenizationDictionaryLoader;
import opennlp.tools.tokenize.DetokenizationDictionary;
import opennlp.tools.tokenize.Detokenizer;
import opennlp.tools.tokenize.DictionaryDetokenizer;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.PlainTextByLineStream;

public final class DictionaryDetokenizerTool
implements CmdLineTool {
    public String getName() {
        return "DictionaryDetokenizer";
    }

    public String getShortDescription() {
        return "";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " detokenizerDictionary";
    }

    public static String detokenize(String[] tokens, Detokenizer.DetokenizationOperation[] operations) {
        if (tokens.length != operations.length) {
            throw new IllegalArgumentException("tokens and operations array must have same length!");
        }
        StringBuilder untokenizedString = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            untokenizedString.append(tokens[i]);
            boolean isAppendSpace = i + 1 == operations.length ? false : (operations[i + 1].equals((Object)Detokenizer.DetokenizationOperation.MERGE_TO_LEFT) ? false : !operations[i].equals((Object)Detokenizer.DetokenizationOperation.MERGE_TO_RIGHT));
            if (!isAppendSpace) continue;
            untokenizedString.append(' ');
        }
        return untokenizedString.toString();
    }

    public void run(String[] args) {
        if (args.length != 1) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        DictionaryDetokenizer detokenizer = new DictionaryDetokenizer((DetokenizationDictionary)new DetokenizationDictionaryLoader().load(new File(args[0])));
        PlainTextByLineStream tokenizedLineStream = new PlainTextByLineStream(new InputStreamReader(System.in));
        PerformanceMonitor perfMon = new PerformanceMonitor(System.err, "sent");
        perfMon.start();
        try {
            String tokenizedLine;
            while ((tokenizedLine = (String)tokenizedLineStream.read()) != null) {
                String[] tokens = WhitespaceTokenizer.INSTANCE.tokenize(tokenizedLine);
                Detokenizer.DetokenizationOperation[] operations = detokenizer.detokenize(tokens);
                System.out.println(DictionaryDetokenizerTool.detokenize(tokens, operations));
                perfMon.incrementCounter();
            }
        }
        catch (IOException e) {
            CmdLineUtil.handleStdinIoError(e);
        }
        perfMon.stopAndPrintFinalResult();
    }
}

