/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import opennlp.model.AbstractModel;
import opennlp.model.Event;
import opennlp.model.Sequence;
import opennlp.model.SequenceStream;
import opennlp.tools.postag.DefaultPOSContextGenerator;
import opennlp.tools.postag.POSContextGenerator;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSSampleEventStream;
import opennlp.tools.postag.POSSampleSequenceIterator;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSSampleSequenceStream
implements SequenceStream {
    private POSContextGenerator pcg;
    private List<POSSample> samples = new ArrayList<POSSample>();

    public POSSampleSequenceStream(ObjectStream<POSSample> psi) throws IOException {
        this(psi, new DefaultPOSContextGenerator(null));
    }

    public POSSampleSequenceStream(ObjectStream<POSSample> psi, POSContextGenerator pcg) throws IOException {
        POSSample sample;
        while ((sample = psi.read()) != null) {
            this.samples.add(sample);
        }
        System.err.println("Got " + this.samples.size() + " sequences");
        this.pcg = pcg;
    }

    public Event[] updateContext(Sequence sequence, AbstractModel model) {
        Sequence pss = sequence;
        POSTaggerME tagger = new POSTaggerME(new POSModel("x-unspecified", model, null, null));
        String[] sentence = ((POSSample)pss.getSource()).getSentence();
        String[] tags = tagger.tag(((POSSample)pss.getSource()).getSentence());
        Event[] events = new Event[sentence.length];
        for (int si = 0; si < events.length; ++si) {
            POSSampleEventStream.generateEvents(sentence, tags, this.pcg).toArray(events);
        }
        return events;
    }

    public Iterator<Sequence> iterator() {
        return new POSSampleSequenceIterator(this.samples.iterator());
    }
}

