/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import opennlp.tools.tokenize.Detokenizer;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.Span;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenSample {
    public static final String DEFAULT_SEPARATOR_CHARS = "<SPLIT>";
    private final String separatorChars = "<SPLIT>";
    private final String text;
    private final List<Span> tokenSpans;

    public TokenSample(String text, Span[] tokenSpans) {
        if (text == null) {
            throw new IllegalArgumentException("text must not be null!");
        }
        if (tokenSpans == null) {
            throw new IllegalArgumentException("tokenSpans must not be null! ");
        }
        this.text = text;
        this.tokenSpans = Collections.unmodifiableList(new ArrayList<Span>(Arrays.asList(tokenSpans)));
        for (int i = 0; i < tokenSpans.length; ++i) {
            if (tokenSpans[i].getStart() >= 0 && tokenSpans[i].getStart() <= text.length() && tokenSpans[i].getEnd() <= text.length() && tokenSpans[i].getEnd() >= 0) continue;
            throw new IllegalArgumentException("Span " + tokenSpans[i].toString() + " is out of bounds!");
        }
    }

    public TokenSample(Detokenizer detokenizer, String[] tokens) {
        StringBuilder sentence = new StringBuilder();
        Detokenizer.DetokenizationOperation[] operations = detokenizer.detokenize(tokens);
        ArrayList<Span> mergedTokenSpans = new ArrayList<Span>();
        for (int i = 0; i < operations.length; ++i) {
            boolean isSeparateFromPreviousToken;
            boolean bl = isSeparateFromPreviousToken = i > 0 && !Detokenizer.DetokenizationOperation.MERGE_TO_RIGHT.equals((Object)operations[i - 1]) && !Detokenizer.DetokenizationOperation.MERGE_TO_LEFT.equals((Object)operations[i]);
            if (isSeparateFromPreviousToken) {
                sentence.append(' ');
            }
            int beginIndex = sentence.length();
            sentence.append(tokens[i]);
            mergedTokenSpans.add(new Span(beginIndex, sentence.length()));
        }
        this.text = sentence.toString();
        this.tokenSpans = Collections.unmodifiableList(mergedTokenSpans);
    }

    public String getText() {
        return this.text;
    }

    public Span[] getTokenSpans() {
        return this.tokenSpans.toArray(new Span[this.tokenSpans.size()]);
    }

    public String toString() {
        StringBuilder sentence = new StringBuilder();
        int lastEndIndex = -1;
        for (Span token : this.tokenSpans) {
            if (lastEndIndex != -1) {
                String separator = "";
                separator = lastEndIndex == token.getStart() ? DEFAULT_SEPARATOR_CHARS : " ";
                sentence.append(separator);
            }
            sentence.append(token.getCoveredText(this.text));
            lastEndIndex = token.getEnd();
        }
        return sentence.toString();
    }

    private static void addToken(StringBuilder sample, List<Span> tokenSpans, String token, boolean isNextMerged) {
        int tokenSpanStart = sample.length();
        sample.append(token);
        int tokenSpanEnd = sample.length();
        tokenSpans.add(new Span(tokenSpanStart, tokenSpanEnd));
        if (!isNextMerged) {
            sample.append(" ");
        }
    }

    public static TokenSample parse(String sampleString, String separatorChars) {
        if (sampleString == null || separatorChars == null) {
            throw new IllegalArgumentException("arguments must not be null!");
        }
        Span[] whitespaceTokenSpans = WhitespaceTokenizer.INSTANCE.tokenizePos(sampleString);
        ArrayList<Span> realTokenSpans = new ArrayList<Span>((int)((double)whitespaceTokenSpans.length * 1.2));
        StringBuilder untaggedSampleString = new StringBuilder();
        for (Span whiteSpaceTokenSpan : whitespaceTokenSpans) {
            String token;
            String whitespaceToken = ((Object)whiteSpaceTokenSpan.getCoveredText(sampleString)).toString();
            boolean wasTokenReplaced = false;
            int tokStart = 0;
            int tokEnd = -1;
            while ((tokEnd = whitespaceToken.indexOf(separatorChars, tokStart)) > -1) {
                token = whitespaceToken.substring(tokStart, tokEnd);
                TokenSample.addToken(untaggedSampleString, realTokenSpans, token, true);
                tokStart = tokEnd + separatorChars.length();
                wasTokenReplaced = true;
            }
            if (wasTokenReplaced) {
                token = whitespaceToken.substring(tokStart);
                TokenSample.addToken(untaggedSampleString, realTokenSpans, token, false);
                continue;
            }
            TokenSample.addToken(untaggedSampleString, realTokenSpans, whitespaceToken, false);
        }
        return new TokenSample(untaggedSampleString.toString(), realTokenSpans.toArray(new Span[realTokenSpans.size()]));
    }
}

