/*
 * Decompiled with CFR 0.152.
 */
package com.gotometrics.orderly.example;

import com.gotometrics.orderly.BigDecimalRowKey;
import com.gotometrics.orderly.LazyBigDecimalRowKey;
import com.gotometrics.orderly.Order;
import java.math.BigDecimal;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;

public class BigDecimalExample {
    public void lengthExamples() throws Exception {
        BigDecimalRowKey i = new BigDecimalRowKey();
        System.out.println("serialize(null) length - " + i.serialize(null).length);
        System.out.println("serialize(58.75) length - " + i.serialize((Object)new BigDecimal(58.75)).length);
        System.out.println("serialize(107-e902) length - " + i.serialize((Object)new BigDecimal("107e-902")).length);
        i.setOrder(Order.DESCENDING);
        System.out.println("descending serialize (null) - length " + i.serialize(null).length);
        System.out.println("descending serialize (57) - length " + i.serialize((Object)new BigDecimal(57)).length);
    }

    public void serializationExamples() throws Exception {
        BigDecimalRowKey i = new BigDecimalRowKey();
        LazyBigDecimalRowKey l = new LazyBigDecimalRowKey();
        ImmutableBytesWritable buffer = new ImmutableBytesWritable();
        BigDecimal bd = new BigDecimal("107e-902");
        byte[] b = new byte[i.getSerializedLength((Object)bd)];
        buffer.set(b);
        i.serialize((Object)bd, buffer);
        buffer.set(b, 0, b.length);
        System.out.println("deserialize(serialize(107e-902)) = " + i.deserialize(buffer));
        l.setOrder(Order.DESCENDING);
        System.out.println("deserialize(serialize(0)) = " + l.getBigDecimal((ImmutableBytesWritable)l.deserialize(l.serialize((Object)BigDecimal.ZERO))));
        System.out.println("deserialize(serialize(NULL)) = " + i.deserialize(i.serialize(null)));
    }

    public static void main(String[] args) throws Exception {
        BigDecimalExample e = new BigDecimalExample();
        e.lengthExamples();
        e.serializationExamples();
    }
}

