/*
 * Decompiled with CFR 0.152.
 */
package com.gotometrics.orderly.example;

import com.gotometrics.orderly.FixedLongWritableRowKey;
import com.gotometrics.orderly.FixedUnsignedLongRowKey;
import com.gotometrics.orderly.Order;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.LongWritable;

public class FixedLongExample {
    public void lengthExamples() throws Exception {
        FixedUnsignedLongRowKey i = new FixedUnsignedLongRowKey();
        System.out.println("serialize(2^63) length - " + i.serialize((Object)Long.MIN_VALUE).length);
        System.out.println("serialize(57) length - " + i.serialize((Object)57L).length);
        System.out.println("serialize(293) length - " + i.serialize((Object)293L).length);
        i.setOrder(Order.DESCENDING);
        System.out.println("descending serialize (57) - length " + i.serialize((Object)57L).length);
        System.out.println("descending serialize (2^32) - length " + i.serialize((Object)0x100000000L).length);
    }

    public void serializationExamples() throws Exception {
        FixedLongWritableRowKey l = new FixedLongWritableRowKey();
        LongWritable w = new LongWritable();
        ImmutableBytesWritable buffer = new ImmutableBytesWritable();
        w.set(-93214L);
        byte[] b = new byte[l.getSerializedLength((Object)w)];
        buffer.set(b);
        l.serialize((Object)w, buffer);
        buffer.set(b, 0, b.length);
        System.out.println("deserialize(serialize(-93214)) = " + ((LongWritable)l.deserialize(buffer)).get());
        l.setOrder(Order.DESCENDING);
        w.set(0L);
        System.out.println("deserialize(serialize(0)) = " + ((LongWritable)l.deserialize(l.serialize((Object)w))).get());
    }

    public static void main(String[] args) throws Exception {
        FixedLongExample e = new FixedLongExample();
        e.lengthExamples();
        e.serializationExamples();
    }
}

