/*
 * Decompiled with CFR 0.152.
 */
package com.gotometrics.orderly.example;

import com.gotometrics.orderly.BigDecimalRowKey;
import com.gotometrics.orderly.DoubleRowKey;
import com.gotometrics.orderly.FixedUnsignedLongRowKey;
import com.gotometrics.orderly.IntegerRowKey;
import com.gotometrics.orderly.Order;
import com.gotometrics.orderly.RowKey;
import com.gotometrics.orderly.StringRowKey;
import com.gotometrics.orderly.StructBuilder;
import com.gotometrics.orderly.StructIterator;
import com.gotometrics.orderly.StructRowKey;
import com.gotometrics.orderly.Termination;
import java.math.BigDecimal;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;

public class StructExample {
    BigDecimalRowKey bd = new BigDecimalRowKey();
    DoubleRowKey d;
    FixedUnsignedLongRowKey ul = new FixedUnsignedLongRowKey();
    StringRowKey s = new StringRowKey();
    IntegerRowKey i;

    public StructExample() {
        this.d = new DoubleRowKey();
        this.i = new IntegerRowKey();
    }

    public void structLengthExample() throws Exception {
        StructRowKey fin = new StructRowKey(new RowKey[]{this.i, this.bd, this.s});
        System.out.println("struct(null) length - " + fin.serialize((Object)new Object[]{null, null, null}).length);
        fin.setOrder(Order.DESCENDING);
        System.out.println("struct DESC (null) length - " + fin.serialize((Object)new Object[]{null, null, null}).length);
        fin.setOrder(Order.ASCENDING);
        System.out.println("struct (293, 2934, hi) length - " + fin.serialize((Object)new Object[]{293, new BigDecimal("2934"), "hi"}).length);
        System.out.println("struct (293, 2934, null) length - " + fin.serialize((Object)new Object[]{293, new BigDecimal("2934"), null}).length);
        fin.setTermination(Termination.MUST);
        System.out.println("mustTerminate struct (293, 2934, hi) length - " + fin.serialize((Object)new Object[]{293, new BigDecimal("2934"), "hi"}).length);
        System.out.println("mustTerminate struct (293, 2934, null) length - " + fin.serialize((Object)new Object[]{293, new BigDecimal("2934"), null}).length);
        fin.setTermination(Termination.SHOULD_NOT);
        fin.setOrder(Order.DESCENDING);
        System.out.println("struct DESC (293, 2934, hi) length - " + fin.serialize((Object)new Object[]{293, new BigDecimal("2934"), "hi"}).length);
        System.out.println("struct DESC (293, 2934, null) length - " + fin.serialize((Object)new Object[]{293, new BigDecimal("2934"), null}).length);
        fin.setOrder(Order.ASCENDING);
    }

    void printStruct(Object obj, String prefix) {
        Object[] o = (Object[])obj;
        if (o == null) {
            System.out.println(prefix + "Struct: NULL");
            return;
        }
        System.out.println(prefix + "Struct: ");
        int pos = 0;
        for (Object field : o) {
            if (field instanceof Object[]) {
                System.out.println(prefix + " Field " + pos++ + " nested: ");
                this.printStruct(field, prefix + "\t");
                continue;
            }
            System.out.println(prefix + "  Field " + pos++ + " = " + field);
        }
    }

    void printStruct(Object obj) {
        this.printStruct(obj, "");
    }

    public void structSerializationExample() throws Exception {
        StructRowKey r = new StructRowKey(new RowKey[]{this.s, this.bd});
        System.out.println("deserialize(serialize(foobarbaz, 3.14159e102))");
        this.printStruct(r.deserialize(r.serialize((Object)new Object[]{"foobarbaz", new BigDecimal(3.14159E102)})));
        ImmutableBytesWritable buffer = new ImmutableBytesWritable();
        Object[] o = new Object[]{"helloworld", null};
        byte[] b = new byte[r.getSerializedLength((Object)o)];
        buffer.set(b);
        r.serialize((Object)o, buffer);
        buffer.set(b);
        System.out.println("deserialize(serialize(helloworld, null))");
        this.printStruct(r.deserialize(buffer));
    }

    public void prefixExample() throws Exception {
        StructRowKey rk = new StructRowKey(new RowKey[]{this.s, this.d, this.bd});
        StructRowKey prefix1 = new StructRowKey(new RowKey[]{this.s, this.d});
        StructRowKey prefix2 = new StructRowKey(new RowKey[]{this.s});
        byte[] b = rk.serialize((Object)new Object[]{"hello", 3.14159, new BigDecimal("0.93e-102")});
        System.out.println("Deserialize first two fields of (hello, 3.14159, 0.93e-102)");
        this.printStruct(prefix1.deserialize(b));
        System.out.println("Deserialize first field of (hello, 3.14159, 0.93e-102)");
        this.printStruct(prefix2.deserialize(b));
        System.out.println("Deserialize all fields of (hello, 3.14159, 0.93e-102)");
        this.printStruct(rk.deserialize(b));
    }

    public void builderAndIteratorExample() throws Exception {
        StructRowKey rk = new StructBuilder().add((RowKey)this.s).add((RowKey)this.d).add((RowKey)this.ul).toRowKey();
        Object[] o = new Object[]{"hello", 3.14159, 17L};
        StructIterator iterator = rk.iterateOver(rk.serialize((Object)o)).iterator();
        System.out.println("Printing fields 1, 3 of (hello, 3.14159, 17");
        System.out.println(iterator.deserialize());
        iterator.skip();
        System.out.println(iterator.deserialize());
        System.out.println("Printing fields all fields (hello, 3.14159, 17");
        for (Object field : rk) {
            System.out.println(field);
        }
    }

    public void nestedStructExample() throws Exception {
        StructBuilder b = new StructBuilder();
        StructRowKey n = b.add((RowKey)this.ul).add((RowKey)this.bd).toRowKey();
        StructRowKey rk = b.reset().add((RowKey)this.s).add((RowKey)n).add((RowKey)this.i).toRowKey();
        System.out.println("Serializing (outerString, (17, 940.2e-87)), 42");
        Object[] o = new Object[]{"outerString", new Object[]{17L, new BigDecimal("940.2e-87")}, 42};
        byte[] a = rk.serialize((Object)o);
        System.out.println("Length " + a.length);
        this.printStruct(rk.deserialize(a));
    }

    public static void main(String[] args) throws Exception {
        StructExample e = new StructExample();
        e.structLengthExample();
        e.structSerializationExample();
        e.prefixExample();
        e.builderAndIteratorExample();
        e.nestedStructExample();
    }
}

