# clj-util

Common Clojure utility functions I use.

[![Travis](https://img.shields.io/travis/ajoberstar/clj-util.svg?style=flat-square)](https://travis-ci.org/ajoberstar/clj-util)
[![GitHub license](https://img.shields.io/github/license/ajoberstar/clj-util.svg?style=flat-square)](https://github.com/ajoberstar/clj-util/blob/master/LICENSE)
[![Clojars](https://img.shields.io/clojars/v/ajoberstar/clj-util.svg?style=flat-square)](http://clojars.org/org.ajoberstar/clj-util)

## Overview

- Stuart Sierra's Component
    - `IdempotentLifecycle` protocol to make it easier to implement Lifecycle idempotently.
- Ring
    - `make-handler` function that wraps a handler function with middleware that adds components to the request map
- Aleph
    - `AlephRingServer` component (uses `IdempotentLifecycle` and `make-handler`)
    - `websocket->async` for using core.async as interface to an Aleph websocket on server-side
    - `async->websocket` for using core.async as interface to an Aleph websocket on client-side
- Transducers
    - `peek` for applying a function to each item coming through the transducer, without modifying it
    - `reductions` for accumulating the results of a function and having the accumulated result as of each item be passed
    to the next item in the stack
