/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.framework.servlet;

import java.io.IOException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public final class PersistenceFilter
implements Filter {
    private static final PersistenceManagerFactory persistenceManagerFactory = JDOHelper.getPersistenceManagerFactory((String)"transactions-optional");
    private static ThreadLocal<PersistenceManager> currentManager = new ThreadLocal();

    private static PersistenceManagerFactory factory() {
        return persistenceManagerFactory;
    }

    public static synchronized PersistenceManager getManager() {
        if (currentManager.get() == null || currentManager.get().isClosed()) {
            currentManager.set(PersistenceFilter.factory().getPersistenceManager());
        }
        return currentManager.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        PersistenceManager manager = null;
        try {
            manager = PersistenceFilter.getManager();
            chain.doFilter(req, res);
        }
        finally {
            if (manager != null) {
                manager.flush();
                manager.close();
            }
        }
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }
}

