/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.surveyal.app.web;

import com.beoui.geocell.GeocellManager;
import com.beoui.geocell.model.Point;
import com.gallatinsystems.common.util.MemCacheUtils;
import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.gis.geography.dao.CountryDao;
import com.gallatinsystems.gis.geography.domain.Country;
import com.gallatinsystems.gis.location.GeoLocationServiceGeonamesImpl;
import com.gallatinsystems.gis.location.GeoPlace;
import com.gallatinsystems.gis.map.domain.OGRFeature;
import com.gallatinsystems.surveyal.app.web.SurveyalRestRequest;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import net.sf.jsr107cache.Cache;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.SurveyInstance;

public class SurveyalRestServlet
extends AbstractRestApiServlet {
    private static final long serialVersionUID = 5923399458369692813L;
    private static final double UNSET_VAL = -9999.9;
    private static final Logger log = Logger.getLogger(SurveyalRestServlet.class.getName());
    private SurveyInstanceDAO surveyInstanceDao = new SurveyInstanceDAO();
    private SurveyedLocaleDao surveyedLocaleDao = new SurveyedLocaleDao();
    private CountryDao countryDao = new CountryDao();
    private String statusFragment = PropertyUtil.getProperty("statusQuestionText");
    private Map<String, String> scoredVals;

    public SurveyalRestServlet() {
        if (this.statusFragment != null && this.statusFragment.trim().length() > 0) {
            String[] fields = this.statusFragment.split(";");
            this.statusFragment = fields[0].toLowerCase();
            this.scoredVals = new HashMap<String, String>();
            if (fields.length > 1) {
                for (int i = 1; i < fields.length; ++i) {
                    if (!fields[i].contains("=")) continue;
                    String[] kvp = fields[i].split("=");
                    this.scoredVals.put(kvp[0], kvp[1]);
                }
            }
        }
    }

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        SurveyalRestRequest restRequest = new SurveyalRestRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        RestResponse resp = new RestResponse();
        SurveyalRestRequest sReq = (SurveyalRestRequest)req;
        if ("ingestInstance".equalsIgnoreCase(req.getAction())) {
            try {
                this.ingestSurveyInstance(sReq.getSurveyInstanceId());
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, "Could not process instance: " + sReq.getSurveyInstanceId() + ": " + e.getMessage());
            }
        } else if ("rerun".equalsIgnoreCase(req.getAction())) {
            this.rerunForSurvey(sReq.getSurveyId());
        } else if ("reingestInstance".equalsIgnoreCase(req.getAction())) {
            log.log(Level.INFO, "Reprocessing SurveyInstanceId: " + sReq.getSurveyInstanceId());
            try {
                this.ingestSurveyInstance(sReq.getSurveyInstanceId());
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, "Could not process instance: " + sReq.getSurveyInstanceId() + ": " + e.getMessage());
            }
        } else if ("populateGeocellsForLocale".equalsIgnoreCase(req.getAction())) {
            log.log(Level.INFO, "Creating geocells");
            this.populateGeocellsForLocale(req.getCursor());
        } else if ("adaptClusterData".equalsIgnoreCase(req.getAction())) {
            log.log(Level.INFO, "adapting cluster data");
            Boolean decrement = sReq.getDecrementClusterCount();
            int delta = decrement != false ? -1 : 1;
            this.adaptClusterData(sReq.getSurveyedLocaleId(), delta);
        }
        return resp;
    }

    private void rerunForSurvey(Long surveyId) {
        if (surveyId != null) {
            Queue queue = QueueFactory.getDefaultQueue();
            Iterable<Entity> siList = this.surveyInstanceDao.listSurveyInstanceKeysBySurveyId(surveyId);
            if (siList != null) {
                int i = 0;
                for (Entity inst : siList) {
                    if (inst != null && inst.getKey() != null) {
                        String item = inst.getKey().toString();
                        Integer startPos = item.indexOf("(");
                        Integer endPos = item.indexOf(")");
                        String surveyInstanceIdString = item.substring(startPos + 1, endPos);
                        if (surveyInstanceIdString == null || surveyInstanceIdString.trim().equalsIgnoreCase("")) continue;
                        TaskOptions to = TaskOptions.Builder.withUrl((String)"/app_worker/surveyalservlet").param("action", "reingestInstance").param("surveyInstanceId", surveyInstanceIdString);
                        queue.add(to);
                        ++i;
                        continue;
                    }
                    String instString = null;
                    if (inst != null) {
                        instString = inst.toString();
                    }
                    log.log(Level.INFO, "Inside rerunForSurvey in the null or empty instanceid branch: " + instString);
                }
                log.log(Level.INFO, "Submitted: " + i + " SurveyInstances for remapping");
            }
        }
    }

    private void ingestSurveyInstance(Long surveyInstanceId) {
        SurveyInstance instance = (SurveyInstance)this.surveyInstanceDao.getByKey(surveyInstanceId);
        if (instance != null) {
            this.ingestSurveyInstance(instance);
        } else {
            log.log(Level.INFO, "Got to ingestSurveyInstance, but instance is null for surveyInstanceId: " + surveyInstanceId);
        }
    }

    private void ingestSurveyInstance(SurveyInstance surveyInstance) {
        Boolean adaptClusterData = Boolean.FALSE;
        SurveyedLocale locale = (SurveyedLocale)this.surveyedLocaleDao.getByKey(surveyInstance.getSurveyedLocaleId());
        if (locale == null) {
            throw new IllegalStateException("Cannot find SurveyedLocale for SurveyInstance " + surveyInstance.toString());
        }
        GeoPlace geoPlace = null;
        Map<String, Object> geoLocationMap = null;
        try {
            geoLocationMap = SurveyInstance.retrieveGeoLocation(surveyInstance);
        }
        catch (NumberFormatException nfe) {
            log.log(Level.SEVERE, "Could not parse lat/lon for SurveyInstance " + surveyInstance.getKey().getId());
        }
        if (geoLocationMap != null && !geoLocationMap.isEmpty()) {
            Double latitude = (Double)geoLocationMap.get("latitude");
            Double longitude = (Double)geoLocationMap.get("longitude");
            if (!latitude.equals(locale.getLatitude()) || !longitude.equals(locale.getLongitude()) || locale.getGeocells() == null || locale.getGeocells().isEmpty()) {
                locale.setLatitude(latitude);
                locale.setLongitude(longitude);
                try {
                    locale.setGeocells(GeocellManager.generateGeoCell((Point)new Point(latitude.doubleValue(), longitude.doubleValue())));
                }
                catch (Exception ex) {
                    log.log(Level.INFO, "Could not generate Geocell for locale: " + locale.getKey().getId() + " error: " + ex);
                }
                adaptClusterData = Boolean.TRUE;
            }
            geoPlace = this.getGeoPlace(latitude, longitude);
        }
        if (geoPlace != null) {
            this.setGeoData(geoPlace, locale);
            surveyInstance.setCountryCode(geoPlace.getCountryCode());
        }
        locale.addContributingSurveyInstance(surveyInstance.getKey().getId());
        locale.setLastSurveyedDate(new Date(surveyInstance.getCollectionDate().getTime()));
        locale.setLastSurveyalInstanceId(surveyInstance.getKey().getId());
        log.log(Level.FINE, "SurveyLocale at this point " + locale.toString());
        SurveyedLocale savedLocale = this.surveyedLocaleDao.save(locale);
        if (savedLocale.getKey() != null) {
            surveyInstance.setSurveyedLocaleId(savedLocale.getKey().getId());
            this.surveyedLocaleDao.save(savedLocale);
            this.surveyInstanceDao.save(surveyInstance);
        }
        if (adaptClusterData.booleanValue()) {
            Queue defaultQueue = QueueFactory.getDefaultQueue();
            TaskOptions adaptClusterTaskOptions = TaskOptions.Builder.withUrl((String)"/app_worker/surveyalservlet").param("action", "adaptClusterData").param("surveyedLocaleId", Long.toString(locale.getKey().getId()));
            defaultQueue.add(adaptClusterTaskOptions);
        }
    }

    private synchronized void adaptClusterData(Long surveyedLocaleId, Integer delta) {
        SurveyedLocaleDao slDao = new SurveyedLocaleDao();
        SurveyedLocale locale = slDao.getById(surveyedLocaleId);
        if (locale == null) {
            log.log(Level.SEVERE, "Couldn't find surveyedLocale with id: " + surveyedLocaleId);
            return;
        }
        Cache cache = MemCacheUtils.initCache(43200);
        if (cache == null) {
            Queue queue = QueueFactory.getDefaultQueue();
            TaskOptions to = TaskOptions.Builder.withUrl((String)"/app_worker/surveyalservlet").param("action", "adaptClusterData").param("surveyedLocaleId", surveyedLocaleId + "").countdownMillis(300000L);
            if (delta < 0) {
                to.param("decrement", Boolean.TRUE.toString());
            }
            queue.add(to);
            return;
        }
        if (delta < 0) {
            slDao.delete(locale);
        }
    }

    private GeoPlace getGeoPlace(Double lat, Double lon) {
        Country country;
        GeoLocationServiceGeonamesImpl gs = new GeoLocationServiceGeonamesImpl();
        GeoPlace geoPlace = gs.manualLookup(lat.toString(), lon.toString(), OGRFeature.FeatureType.SUB_COUNTRY_OTHER);
        if (geoPlace == null) {
            geoPlace = gs.findGeoPlace(lat.toString(), lon.toString());
        }
        if (geoPlace != null && geoPlace.getCountryCode() != null && (country = this.countryDao.findByCode(geoPlace.getCountryCode())) == null) {
            country = new Country();
            country.setIsoAlpha2Code(geoPlace.getCountryCode());
            country.setName(geoPlace.getCountryName() != null ? geoPlace.getCountryName() : geoPlace.getCountryCode());
            country.setDisplayName(country.getName());
            this.countryDao.save(country);
        }
        return geoPlace;
    }

    private void setGeoData(GeoPlace geoPlace, SurveyedLocale l) {
        if (geoPlace != null) {
            l.setCountryCode(geoPlace.getCountryCode());
        }
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        this.getResponse().setStatus(200);
    }

    private void populateGeocellsForLocale(String cursor) {
        log.log(Level.INFO, "Populating geocells for locales");
        SurveyedLocaleDao slDao = new SurveyedLocaleDao();
        List surveyedLocaleList = slDao.list(cursor);
        String newCursor = SurveyedLocaleDao.getCursor(surveyedLocaleList);
        if (surveyedLocaleList == null || surveyedLocaleList.size() == 0) {
            log.log(Level.INFO, "No locales found");
            return;
        }
        for (SurveyedLocale sl : surveyedLocaleList) {
            if (sl.getGeocells() != null && sl.getGeocells().size() > 0) continue;
            if (sl.getLatitude() == null && sl.getLongitude() == null) {
                log.log(Level.INFO, "Could not populate Geocells for SurveyedLocale: " + sl.getKey().getId() + ". No lat/lon values set");
                continue;
            }
            try {
                sl.setGeocells(GeocellManager.generateGeoCell((Point)new Point(sl.getLatitude().doubleValue(), sl.getLongitude().doubleValue())));
            }
            catch (Exception ex) {
                log.log(Level.INFO, "Could not generate Geocell for SurveyedLocale: " + sl.getKey().getId() + " error: " + ex);
            }
            slDao.save(sl);
        }
        Queue queue = QueueFactory.getDefaultQueue();
        queue.add(TaskOptions.Builder.withUrl((String)"/app_worker/surveyalservlet").param("action", "populateGeocellsForLocale").param("cursor", newCursor));
    }
}

