/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.xml;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import org.akvo.flow.xml.XmlForm;

public class PublishedForm {
    public static XmlForm parse(String xml) throws IOException {
        return PublishedForm.parse(xml, false);
    }

    public static XmlForm parse(String xml, boolean strict) throws IOException {
        XmlMapper objectMapper = new XmlMapper();
        if (!strict) {
            objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        }
        XmlForm form = (XmlForm)objectMapper.readValue(xml, XmlForm.class);
        return form;
    }

    public static String generate(XmlForm tree) throws IOException {
        XmlMapper objectMapper = new XmlMapper();
        StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        xml.append(objectMapper.writeValueAsString((Object)tree));
        return xml.toString();
    }

    public static String generateIndented(XmlForm tree) throws IOException {
        XmlMapper objectMapper = new XmlMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
        xml.append(objectMapper.writeValueAsString((Object)tree));
        return xml.toString();
    }
}

