/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.analytics.dao;

import com.gallatinsystems.common.util.MemCacheUtils;
import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.domain.BaseDomain;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheException;
import org.akvo.flow.domain.DataUtils;
import org.waterforpeople.mapping.analytics.domain.SurveyQuestionSummary;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;

public class SurveyQuestionSummaryDao
extends BaseDAO<SurveyQuestionSummary> {
    private Cache cache = MemCacheUtils.initCache(14400);

    public SurveyQuestionSummaryDao() {
        super(SurveyQuestionSummary.class);
    }

    public static synchronized void incrementCount(QuestionAnswerStore questionAnswer, int unit) {
        PersistenceManager pm = PersistenceFilter.getManager();
        String[] answers = DataUtils.optionResponsesTextArray(questionAnswer.getValue());
        for (int i = 0; i < answers.length; ++i) {
            String answer = answers[i];
            if (answer.length() > 500) {
                answer = answer.substring(0, 500);
            }
            Query query = pm.newQuery(SurveyQuestionSummary.class);
            query.setFilter("questionId == questionIdParam && response == answerParam");
            query.declareParameters("String questionIdParam, String answerParam");
            List results = (List)query.execute((Object)questionAnswer.getQuestionID(), (Object)answer);
            SurveyQuestionSummary summary = null;
            if ((results == null || results.size() == 0) && unit > 0) {
                summary = new SurveyQuestionSummary();
                summary.setCount(new Long(unit));
                summary.setQuestionId(questionAnswer.getQuestionID());
                summary.setResponse(answer);
            } else if (results != null && results.size() > 0) {
                summary = (SurveyQuestionSummary)results.get(0);
                summary.setCount(summary.getCount() + (long)unit);
            }
            if (summary == null) continue;
            SurveyQuestionSummaryDao summaryDao = new SurveyQuestionSummaryDao();
            if (summary.getCount() > 0L) {
                summaryDao.save(summary);
                continue;
            }
            if (summary.getKey() == null) continue;
            summaryDao.delete(summary);
        }
    }

    public List<SurveyQuestionSummary> listByQuestion(String qId) {
        return this.listByProperty("questionId", qId, "String");
    }

    public List<SurveyQuestionSummary> listByResponse(String questionId, String questionResponse) {
        if (questionResponse == null) {
            return Collections.emptyList();
        }
        String answer = questionResponse;
        if (answer.length() > 500) {
            answer = answer.substring(0, 500);
        }
        List<SurveyQuestionSummary> result = null;
        String cacheKey = null;
        try {
            SurveyQuestionSummary sqs;
            cacheKey = this.getCacheKey(questionId + "-" + answer);
            if (MemCacheUtils.containsKey(this.cache, cacheKey) && (sqs = (SurveyQuestionSummary)this.cache.get((Object)cacheKey)) != null) {
                result = new ArrayList<SurveyQuestionSummary>();
                result.add(sqs);
                return result;
            }
        }
        catch (CacheException e) {
            this.log.log(Level.WARNING, e.getMessage());
        }
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(SurveyQuestionSummary.class);
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        HashMap<String, Object> paramMap = null;
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("questionId", filterString, paramString, "String", questionId, paramMap);
        this.appendNonNullParam("response", filterString, paramString, "String", answer, paramMap);
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        result = (List)query.executeWithMap(paramMap);
        this.cache(result);
        return result;
    }

    private void cache(List<SurveyQuestionSummary> summaryList) {
        if (summaryList == null || summaryList.isEmpty()) {
            return;
        }
        HashMap<Object, Object> cacheMap = new HashMap<Object, Object>();
        for (SurveyQuestionSummary summary : summaryList) {
            if (summary == null) continue;
            try {
                String cacheKey = this.getCacheKey(summary);
                cacheMap.put(cacheKey, summary);
            }
            catch (CacheException e) {
                this.log.log(Level.WARNING, e.getMessage());
            }
        }
        MemCacheUtils.putObjects(this.cache, cacheMap);
    }

    private void uncache(List<SurveyQuestionSummary> summaryList) {
        if (summaryList == null || summaryList.isEmpty()) {
            return;
        }
        for (SurveyQuestionSummary summary : summaryList) {
            if (summary == null) continue;
            try {
                String cacheKey = this.getCacheKey(summary);
                if (!MemCacheUtils.containsKey(this.cache, cacheKey)) continue;
                this.cache.remove((Object)cacheKey);
            }
            catch (CacheException e) {
                this.log.log(Level.WARNING, e.getMessage());
            }
        }
    }

    @Override
    public SurveyQuestionSummary save(SurveyQuestionSummary summary) {
        SurveyQuestionSummary savedSummary = super.save(summary);
        this.cache(Arrays.asList(savedSummary));
        return savedSummary;
    }

    @Override
    public List<SurveyQuestionSummary> save(List<SurveyQuestionSummary> summary) {
        List savedSummaryList = (List)super.save(summary);
        this.cache(savedSummaryList);
        return savedSummaryList;
    }

    @Override
    public void delete(SurveyQuestionSummary summary) {
        this.uncache(Arrays.asList(summary));
        super.delete(summary);
    }

    @Override
    public void delete(List<SurveyQuestionSummary> summaryList) {
        this.uncache(summaryList);
        super.delete(summaryList);
    }

    @Override
    public String getCacheKey(BaseDomain object) throws CacheException {
        SurveyQuestionSummary summary = (SurveyQuestionSummary)object;
        if (summary.getQuestionId() == null || summary.getResponse() == null) {
            throw new CacheException("Cannnot create cache key without questionId and response");
        }
        return summary.getClass().getSimpleName() + "-" + summary.getQuestionId() + "-" + summary.getResponse();
    }
}

