/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestError;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.framework.rest.exception.RestException;
import com.gallatinsystems.gis.geography.dao.CountryDao;
import com.gallatinsystems.gis.geography.domain.Country;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;
import org.waterforpeople.mapping.app.gwt.client.community.CommunityDto;
import org.waterforpeople.mapping.app.gwt.client.community.CountryDto;
import org.waterforpeople.mapping.app.web.dto.GeoRequest;
import org.waterforpeople.mapping.app.web.dto.GeoResponse;
import org.waterforpeople.mapping.dao.CommunityDao;
import org.waterforpeople.mapping.domain.Community;

public class GeoServlet
extends AbstractRestApiServlet {
    private static final long serialVersionUID = -7534864780109561623L;
    private static final Logger log = Logger.getLogger(GeoServlet.class.getName());
    private CountryDao countryDao = new CountryDao();
    private CommunityDao communityDao = new CommunityDao();

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        GeoRequest restRequest = new GeoRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        GeoRequest geoReq = (GeoRequest)req;
        if ("getCountries".equalsIgnoreCase(geoReq.getAction())) {
            if (geoReq.getMapType() == null) {
                return this.convertToResponse(this.countryDao.list(BaseDAO.CURSOR_TYPE.all.toString()), null);
            }
            if ("public".equalsIgnoreCase(geoReq.getMapType())) {
                return this.convertToResponse(this.communityDao.listMapCountries(CommunityDao.MAP_TYPE.PUBLIC), null);
            }
            if ("kmz".equalsIgnoreCase(geoReq.getMapType())) {
                return this.convertToResponse(this.communityDao.listMapCountries(CommunityDao.MAP_TYPE.KMZ), null);
            }
            return null;
        }
        if ("getCommunities".equalsIgnoreCase(geoReq.getAction())) {
            return this.convertToResponse(null, this.communityDao.listCommunityByCountry(geoReq.getCountry()));
        }
        throw new RestException(new RestError("5001", "Unrecognized Action", "Action is not valid"), "Action not valid", null);
    }

    protected GeoResponse convertToResponse(List<Country> countries, List<Community> communities) {
        GeoResponse resp = new GeoResponse();
        if (countries != null) {
            ArrayList<CountryDto> dtoList = new ArrayList<CountryDto>();
            for (Country c : countries) {
                CountryDto dto = new CountryDto();
                dto.setIsoAlpha2Code(c.getIsoAlpha2Code());
                dto.setIsoAlpha3Code(c.getIsoAlpha3Code());
                dto.setIsoNumeric3Code(c.getIsoNumeric3Code());
                dto.setCentroidLat(c.getCentroidLat());
                dto.setCentroidLon(c.getCentroidLon());
                dto.setName(c.getName());
                dtoList.add(dto);
            }
            resp.setCountries(dtoList);
        } else if (communities != null) {
            ArrayList<CommunityDto> dtoList = new ArrayList<CommunityDto>();
            for (Community c : communities) {
                CommunityDto dto = new CommunityDto();
                dto.setCommunityCode(c.getCommunityCode());
                dtoList.add(dto);
            }
            resp.setCommunities(dtoList);
        }
        return resp;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        this.getResponse().setStatus(200);
        if (resp != null) {
            GeoResponse geoResp = (GeoResponse)resp;
            JSONObject result = new JSONObject((Object)geoResp);
            this.getResponse().getWriter().println(result.toString());
        }
    }
}

