/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dao;

import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.device.dao.DeviceDAO;
import com.gallatinsystems.device.domain.Device;
import com.gallatinsystems.device.domain.DeviceFiles;
import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.DatastoreTimeoutException;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import javax.jdo.PersistenceManager;
import org.akvo.flow.domain.DataUtils;
import org.apache.commons.lang.StringUtils;
import org.waterforpeople.mapping.analytics.dao.SurveyQuestionSummaryDao;
import org.waterforpeople.mapping.analytics.domain.SurveyQuestionSummary;
import org.waterforpeople.mapping.app.web.DataProcessorRestServlet;
import org.waterforpeople.mapping.dao.QuestionAnswerStoreDao;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;
import org.waterforpeople.mapping.domain.SurveyInstance;

public class SurveyInstanceDAO
extends BaseDAO<SurveyInstance> {
    private static final String DEFAULT_ORG_PROP = "defaultOrg";
    private final QuestionAnswerStoreDao qasDao = new QuestionAnswerStoreDao();
    private final DeviceDAO deviceDao = new DeviceDAO();
    private final QuestionDao questionDao = new QuestionDao();

    public SurveyInstanceDAO() {
        super(SurveyInstance.class);
    }

    public SurveyInstance save(SurveyInstance si, DeviceFiles deviceFile) {
        boolean isNew = true;
        SurveyInstance existing = this.findByUUID(si.getUuid());
        if (existing != null) {
            si.setKey(existing.getKey());
            si.setCreatedDateTime(existing.getCreatedDateTime());
            isNew = false;
        }
        SurveyedLocale sl = this.saveSurveyedLocale(si);
        si.setSurveyedLocaleId(sl.getKey().getId());
        if (si.getSurveyedLocaleDisplayName() == null && sl != null) {
            si.setSurveyedLocaleDisplayName(sl.getDisplayName());
        }
        si.setDeviceFile(deviceFile);
        si = this.save(si);
        long surveyInstanceId = si.getKey().getId();
        this.qasDao.listBySurveyInstance(surveyInstanceId);
        HashSet<QuestionAnswerStore> images = new HashSet<QuestionAnswerStore>();
        HashSet<QuestionAnswerStore> locations = new HashSet<QuestionAnswerStore>();
        ArrayList<QuestionAnswerStore> responses = new ArrayList<QuestionAnswerStore>();
        for (QuestionAnswerStore qas : si.getQuestionAnswersStore()) {
            if (!this.isProcessable(qas, si)) continue;
            qas.setSurveyInstanceId(surveyInstanceId);
            if (Question.Type.GEO.toString().equals(qas.getType()) && isNew) {
                locations.add(qas);
            } else if ("IMAGE".equals(qas.getType())) {
                images.add(qas);
            }
            responses.add(qas);
        }
        try {
            this.qasDao.save((List<QuestionAnswerStore>)responses);
        }
        catch (DatastoreTimeoutException te) {
            SurveyInstanceDAO.sleep();
            this.qasDao.save((List<QuestionAnswerStore>)responses);
        }
        if (!images.isEmpty()) {
            Device d = this.deviceDao.getDevice(deviceFile.getAndroidId(), deviceFile.getImei(), deviceFile.getPhoneNumber());
            String deviceId = d == null ? "null" : String.valueOf(d.getKey().getId());
            for (QuestionAnswerStore qas : images) {
                String value = qas.getValue();
                String filename = null;
                if (value.startsWith("{")) {
                    String key = "\"filename\":\"";
                    int i = value.indexOf("\"filename\":\"");
                    if (i > -1) {
                        filename = value.substring(i + "\"filename\":\"".length()).split("\"", 2)[0];
                    }
                } else {
                    filename = value;
                }
                if (filename == null) continue;
                filename = filename.substring(filename.lastIndexOf("/") + 1);
                Queue queue = QueueFactory.getQueue((String)"background-processing");
                TaskOptions to = TaskOptions.Builder.withUrl((String)"/app_worker/imagecheck").param("fileName", filename).param("deviceId", deviceId).param("qasId", String.valueOf(qas.getKey().getId())).param("attempt", "1");
                queue.add(to);
            }
        }
        deviceFile.setSurveyInstanceId(si.getKey().getId());
        DataProcessorRestServlet.queueSynchronizedSummaryUpdate(si, true);
        return si;
    }

    private boolean isProcessable(QuestionAnswerStore qas, SurveyInstance si) {
        Long qid = Long.valueOf(qas.getQuestionID());
        if (this.qasDao.isCached(qid, si.getKey().getId())) {
            this.log.log(Level.INFO, "Skipping QAS already present in datasore [SurveyInstance, Survey, Question]: " + qas.getSurveyInstanceId() + ", " + si.getSurveyId() + ", " + qas.getQuestionID());
            return false;
        }
        if (this.questionDao.getByKey(qid) == null) {
            this.log.log(Level.WARNING, String.format("Question %d not found in the datastore", qid));
            return false;
        }
        return true;
    }

    private SurveyedLocale saveSurveyedLocale(SurveyInstance si) {
        String[] tokens;
        SurveyedLocale sl;
        SurveyedLocaleDao slDao = new SurveyedLocaleDao();
        SurveyedLocale surveyedLocale = sl = si.getSurveyedLocaleIdentifier() != null ? slDao.getByIdentifier(si.getSurveyedLocaleIdentifier()) : null;
        if (sl == null) {
            sl = new SurveyedLocale();
            sl.setOrganization(PropertyUtil.getProperty(DEFAULT_ORG_PROP));
            if (StringUtils.isNotBlank((String)si.getSurveyedLocaleIdentifier())) {
                sl.setIdentifier(si.getSurveyedLocaleIdentifier());
            } else {
                sl.setIdentifier(SurveyedLocale.generateBase32Uuid());
            }
            Survey survey = SurveyUtils.retrieveSurvey(si.getSurveyId());
            if (survey != null) {
                SurveyGroup surveyGroup = SurveyUtils.retrieveSurveyGroup(survey.getSurveyGroupId());
                sl.setSurveyGroupId(survey.getSurveyGroupId());
                sl.setCreationSurveyId(surveyGroup.getNewLocaleSurveyId());
            }
        }
        if (si.getSurveyedLocaleDisplayName() != null) {
            sl.setDisplayName(si.getSurveyedLocaleDisplayName());
        }
        if (si.getLocaleGeoLocation() != null && (tokens = si.getLocaleGeoLocation().split("\\|", -1)).length >= 2) {
            try {
                sl.setLatitude(Double.parseDouble(tokens[0]));
                sl.setLongitude(Double.parseDouble(tokens[1]));
            }
            catch (NumberFormatException nfe) {
                this.log.log(Level.SEVERE, "Could not parse lat/lon from META_GEO: " + si.getLocaleGeoLocation());
            }
        }
        sl = slDao.save(sl);
        return sl;
    }

    public List<SurveyInstance> listByDateRange(Date beginDate, String cursorString) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query q = pm.newQuery(SurveyInstance.class);
        q.setFilter("collectionDate >= pBeginDate");
        q.declareParameters("java.util.Date pBeginDate");
        q.setOrdering("collectionDate desc");
        this.prepareCursor(cursorString, q);
        return (List)q.execute((Object)beginDate);
    }

    public List<SurveyInstance> listByDateRange(Date beginDate, Date endDate, boolean unapprovedOnlyFlag, Long surveyId, String source, String cursorString) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query query = pm.newQuery(SurveyInstance.class);
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("surveyId", filterString, paramString, "Long", surveyId, paramMap);
        this.appendNonNullParam("deviceIdentifier", filterString, paramString, "String", source, paramMap);
        this.appendNonNullParam("collectionDate", filterString, paramString, "Date", beginDate, paramMap, " >= ");
        this.appendNonNullParam("collectionDate", filterString, paramString, "Date", endDate, paramMap, " <= ");
        if (unapprovedOnlyFlag) {
            this.appendNonNullParam("approvedFlag", filterString, paramString, "String", "False", paramMap);
        }
        if (beginDate != null || endDate != null) {
            query.declareImports("import java.util.Date");
        }
        query.setOrdering("collectionDate desc");
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        this.prepareCursor(cursorString, query);
        return (List)query.executeWithMap(paramMap);
    }

    public List<SurveyInstance> listByDateRangeAndSubmitter(Date beginDate, Date endDate, boolean unapprovedOnlyFlag, Long surveyId, String deviceIdentifier, String submitterName, String countryCode, String level1, String level2, String cursorString) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query query = pm.newQuery(SurveyInstance.class);
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("surveyId", filterString, paramString, "Long", surveyId, paramMap);
        this.appendNonNullParam("deviceIdentifier", filterString, paramString, "String", deviceIdentifier, paramMap);
        this.appendNonNullParam("submitterName", filterString, paramString, "String", submitterName, paramMap);
        this.appendNonNullParam("countryCode", filterString, paramString, "String", countryCode, paramMap);
        this.appendNonNullParam("sublevel1", filterString, paramString, "String", level1, paramMap);
        this.appendNonNullParam("sublevel2", filterString, paramString, "String", level2, paramMap);
        this.appendNonNullParam("collectionDate", filterString, paramString, "Date", beginDate, paramMap, " >= ");
        this.appendNonNullParam("collectionDate", filterString, paramString, "Date", endDate, paramMap, " <= ");
        if (unapprovedOnlyFlag) {
            this.appendNonNullParam("approvedFlag", filterString, paramString, "String", "False", paramMap);
        }
        if (beginDate != null || endDate != null) {
            query.declareImports("import java.util.Date");
        }
        query.setOrdering("collectionDate desc");
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        this.prepareCursor(cursorString, query);
        return (List)query.executeWithMap(paramMap);
    }

    public Iterable<Entity> listRawEntity(Boolean returnKeysOnly, Date beginDate, Date endDate, Integer limit, Long surveyId) {
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        Query q = new Query("SurveyInstance");
        ArrayList<Query.FilterPredicate> filters = new ArrayList<Query.FilterPredicate>();
        if (returnKeysOnly.booleanValue()) {
            q.setKeysOnly();
        }
        if (surveyId != null) {
            filters.add(new Query.FilterPredicate("surveyId", Query.FilterOperator.EQUAL, (Object)surveyId));
        }
        if (beginDate != null) {
            filters.add(new Query.FilterPredicate("collectionDate", Query.FilterOperator.GREATER_THAN_OR_EQUAL, (Object)beginDate));
        }
        if (endDate != null) {
            filters.add(new Query.FilterPredicate("collectionDate", Query.FilterOperator.LESS_THAN_OR_EQUAL, (Object)endDate));
        }
        if (filters.size() == 1) {
            q.setFilter((Query.Filter)filters.get(0));
        }
        if (filters.size() > 1) {
            q.setFilter((Query.Filter)Query.CompositeFilterOperator.and(filters));
        }
        q.addSort("collectionDate", Query.SortDirection.DESCENDING);
        PreparedQuery pq = datastore.prepare(q);
        FetchOptions fetchOptions = limit != null ? FetchOptions.Builder.withLimit((int)limit) : FetchOptions.Builder.withDefaults();
        return pq.asIterable(fetchOptions);
    }

    public QuestionAnswerStore findQuestionAnswerStoreForQuestion(Long surveyInstanceId, String questionId) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query q = pm.newQuery(QuestionAnswerStore.class);
        q.setFilter("surveyInstanceId == surveyInstanceIdParam && questionID == questionIdParam");
        q.declareParameters("Long surveyInstanceIdParam, String questionIdParam");
        List result = (List)q.execute((Object)surveyInstanceId, (Object)questionId);
        if (result != null && result.size() > 0) {
            return (QuestionAnswerStore)result.get(0);
        }
        return null;
    }

    public List<QuestionAnswerStore> listQuestionAnswerStoreByType(Long surveyInstanceId, String type) {
        if (surveyInstanceId != null) {
            PersistenceManager pm = PersistenceFilter.getManager();
            javax.jdo.Query query = pm.newQuery(QuestionAnswerStore.class);
            HashMap<String, Object> paramMap = null;
            StringBuilder filterString = new StringBuilder();
            StringBuilder paramString = new StringBuilder();
            paramMap = new HashMap<String, Object>();
            this.appendNonNullParam("surveyInstanceId", filterString, paramString, "Long", surveyInstanceId, paramMap);
            this.appendNonNullParam("type", filterString, paramString, "String", type, paramMap);
            query.setFilter(filterString.toString());
            query.declareParameters(paramString.toString());
            return (List)query.executeWithMap(paramMap);
        }
        throw new IllegalArgumentException("surveyInstanceId may not be null");
    }

    public List<QuestionAnswerStore> listQuestionAnswerStore(Long instanceId, Integer count) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query q = pm.newQuery(QuestionAnswerStore.class);
        q.setFilter("surveyInstanceId == surveyInstanceIdParam");
        q.declareParameters("Long surveyInstanceIdParam");
        if (count != null) {
            q.setRange(0L, (long)count.intValue());
        }
        return (List)q.execute((Object)instanceId);
    }

    public List<QuestionAnswerStore> listQuestionAnswerStoreForQuestion(String questionId, String cursorString) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query q = pm.newQuery(QuestionAnswerStore.class);
        q.setFilter("questionID == qidParam");
        q.declareParameters("String qidParam");
        this.prepareCursor(cursorString, q);
        return (List)q.execute((Object)questionId);
    }

    public void updateSummaryCounts(long siId, boolean increment) {
        SurveyQuestionSummaryDao summaryDao = new SurveyQuestionSummaryDao();
        QuestionAnswerStoreDao qasDao = new QuestionAnswerStoreDao();
        QuestionDao qDao = new QuestionDao();
        List<QuestionAnswerStore> answerList = qasDao.listBySurveyInstance(siId);
        if (answerList == null || answerList.isEmpty()) {
            return;
        }
        ArrayList<SurveyQuestionSummary> saveList = new ArrayList<SurveyQuestionSummary>();
        ArrayList<SurveyQuestionSummary> deleteList = new ArrayList<SurveyQuestionSummary>();
        for (QuestionAnswerStore response : answerList) {
            Long questionId = Long.parseLong(response.getQuestionID());
            Question question = qDao.getByKey(questionId);
            if (question == null || !question.canBeCharted()) continue;
            String questionIdStr = response.getQuestionID();
            String[] questionResponse = DataUtils.optionResponsesTextArray(response.getValue());
            for (int i = 0; i < questionResponse.length; ++i) {
                List<SurveyQuestionSummary> questionSummaryList = summaryDao.listByResponse(questionIdStr, questionResponse[i]);
                SurveyQuestionSummary questionSummary = null;
                if (questionSummaryList.isEmpty()) {
                    questionSummary = new SurveyQuestionSummary();
                    questionSummary.setQuestionId(response.getQuestionID());
                    questionSummary.setResponse(questionResponse[i]);
                    questionSummary.setCount(0L);
                    summaryDao.save(questionSummary);
                } else {
                    questionSummary = questionSummaryList.get(0);
                }
                long count = questionSummary.getCount() == null ? 0L : questionSummary.getCount();
                count = increment ? (count = count + 1L) : (count = count - 1L);
                questionSummary.setCount(count);
                if (count > 0L) {
                    saveList.add(questionSummary);
                    continue;
                }
                deleteList.add(questionSummary);
            }
        }
        summaryDao.save((List<SurveyQuestionSummary>)saveList);
        summaryDao.delete((List<SurveyQuestionSummary>)deleteList);
    }

    public void deleteSurveyInstance(SurveyInstance surveyInstance) {
        Long surveyedLocaleId;
        List relatedSurveyInstances;
        Long surveyInstanceId = surveyInstance.getKey().getId();
        QuestionAnswerStoreDao qasDao = new QuestionAnswerStoreDao();
        QuestionDao qDao = new QuestionDao();
        List<QuestionAnswerStore> qasList = qasDao.listBySurveyInstance(surveyInstanceId);
        SurveyQuestionSummaryDao summDao = new SurveyQuestionSummaryDao();
        if (qasList != null && !qasList.isEmpty()) {
            for (QuestionAnswerStore qasItem : qasList) {
                Question question = qDao.getByKey(Long.parseLong(qasItem.getQuestionID()));
                if (question == null || !question.canBeCharted()) continue;
                String[] responses = DataUtils.optionResponsesTextArray(qasItem.getValue());
                for (int i = 0; i < responses.length; ++i) {
                    List<SurveyQuestionSummary> summaryList = summDao.listByResponse(qasItem.getQuestionID(), responses[i]);
                    if (summaryList == null || summaryList.isEmpty()) continue;
                    String key = Long.toString(summaryList.get(0).getKey().getId());
                    DataProcessorRestServlet.queueAdjustSurveyResponseCount(key, false);
                }
            }
            qasDao.delete(qasList);
        }
        if (surveyInstance.getSurveyedLocaleId() != null && (relatedSurveyInstances = this.listByProperty("surveyedLocaleId", surveyedLocaleId = surveyInstance.getSurveyedLocaleId(), "Long")).size() < 2) {
            Queue queue = QueueFactory.getDefaultQueue();
            TaskOptions to = TaskOptions.Builder.withUrl((String)"/app_worker/surveyalservlet").param("action", "adaptClusterData").param("surveyedLocaleId", surveyedLocaleId + "").param("decrement", Boolean.TRUE.toString());
            queue.add(to);
        }
        super.delete(surveyInstance);
    }

    public List<SurveyInstance> listSurveyInstanceBySurvey(Long surveyId, Integer count) {
        return this.listSurveyInstanceBySurvey(surveyId, count, null);
    }

    public List<SurveyInstance> listSurveyInstanceBySurvey(Long surveyId, Integer count, String cursorString) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query q = pm.newQuery(SurveyInstance.class);
        q.setFilter("surveyId == surveyIdParam");
        q.setOrdering("createdDateTime asc");
        q.declareParameters("Long surveyIdParam");
        this.prepareCursor(cursorString, count, q);
        List siList = (List)q.execute((Object)surveyId);
        return siList;
    }

    public List<SurveyInstance> listSurveyInstanceBySurveyId(Long surveyId, String cursorString) {
        return this.listSurveyInstanceBySurvey(surveyId, null, cursorString);
    }

    public Iterable<Entity> listSurveyInstanceKeysBySurveyId(Long surveyId) {
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        Query q = new Query("SurveyInstance");
        q.setKeysOnly().setFilter((Query.Filter)new Query.FilterPredicate("surveyId", Query.FilterOperator.EQUAL, (Object)surveyId));
        PreparedQuery pq = datastore.prepare(q);
        return pq.asIterable();
    }

    public List<SurveyInstance> listInstancesByLocale(Long surveyedLocaleId, Date dateFrom, Date dateTo, String cursor) {
        return this.listInstancesByLocale(surveyedLocaleId, dateFrom, dateTo, 20, cursor);
    }

    public List<SurveyInstance> listInstancesByLocale(Long surveyedLocaleId, Date dateFrom, Date dateTo, Integer pageSize, String cursor) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query query = pm.newQuery(SurveyInstance.class);
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("surveyedLocaleId", filterString, paramString, "Long", surveyedLocaleId, paramMap);
        if (dateFrom != null || dateTo != null) {
            this.appendNonNullParam("collectionDate", filterString, paramString, "Date", dateFrom, paramMap, " >= ");
            this.appendNonNullParam("collectionDate", filterString, paramString, "Date", dateTo, paramMap, " <= ");
            query.declareImports("import java.util.Date");
        }
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        query.setOrdering("collectionDate desc");
        this.prepareCursor(cursor, pageSize, query);
        return (List)query.executeWithMap(paramMap);
    }

    public List<SurveyInstance> listInstanceBySubmitter(String submitter) {
        if (submitter != null) {
            return this.listByProperty("submitterName", submitter, "String");
        }
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query query = pm.newQuery(SurveyInstance.class, "submitterName == null");
        return (List)query.execute();
    }

    public List<QuestionAnswerStore> listQAOptions(String cursorString, Integer pageSize, String ... options) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query q = pm.newQuery(QuestionAnswerStore.class);
        StringBuffer filter = new StringBuffer();
        for (String op : options) {
            filter.append("type == '").append(op).append("' ||");
        }
        q.setFilter(filter.substring(0, filter.length() - 3).toString());
        this.prepareCursor(cursorString, pageSize, q);
        return (List)q.execute();
    }

    public SurveyInstance findByUUID(String uuid) {
        return (SurveyInstance)this.findByProperty("uuid", uuid, "String");
    }

    public SurveyInstance getRegistrationSurveyInstance(SurveyedLocale locale, Long registrationSurveyId) {
        PersistenceManager pm = PersistenceFilter.getManager();
        javax.jdo.Query query = pm.newQuery(SurveyInstance.class);
        HashMap<String, Object> paramMap = null;
        StringBuilder filterString = new StringBuilder();
        StringBuilder paramString = new StringBuilder();
        paramMap = new HashMap<String, Object>();
        this.appendNonNullParam("surveyId", filterString, paramString, "Long", registrationSurveyId, paramMap);
        this.appendNonNullParam("surveyedLocaleId", filterString, paramString, "Long", locale.getKey().getId(), paramMap);
        query.setFilter(filterString.toString());
        query.declareParameters(paramString.toString());
        query.setOrdering("collectionDate ascending");
        List res = (List)query.executeWithMap(paramMap);
        if (res != null && !res.isEmpty()) {
            return (SurveyInstance)res.get(0);
        }
        return null;
    }
}

