/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.framework.rest;

import com.gallatinsystems.common.util.MD5Util;
import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.framework.rest.RestError;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.framework.rest.exception.RestException;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.RetryOptions;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractRestApiServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(AbstractRestApiServlet.class.getName());
    private static final long serialVersionUID = -8553345034709944772L;
    public static final String XML_MODE = "XML";
    public static final String JSON_MODE = "JSON";
    public static final String XHTML_MODE = "XHTML";
    public static final String PLAINTEXT_MODE = "TEXT";
    private String mode;
    private ThreadLocal<HttpServletRequest> requests;
    private ThreadLocal<HttpServletResponse> responses;
    private static final String API_PRIVATE_KEY = PropertyUtil.getProperty("restPrivateKey");

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.executeRequest(req, resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.executeRequest(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRequest(HttpServletRequest req, HttpServletResponse resp) {
        if (req.getParameter("runAsTask") != null) {
            this.executeRequestAsTask(req);
            return;
        }
        try {
            this.checkThreadLocal();
            resp.setCharacterEncoding("UTF-8");
            this.requests.set(req);
            this.responses.set(resp);
            this.setContentType(resp);
            RestRequest restReq = this.convertRequest();
            restReq.validate();
            RestResponse restResp = this.handleRequest(restReq);
            this.writeOkResponse(restResp);
        }
        catch (RestException e) {
            this.writeErrorResponse(e.getErrors(), resp);
        }
        catch (Throwable e) {
            this.writeErrorResponse(null, resp);
            log.log(Level.SEVERE, "Could not execute rest request", e);
        }
        finally {
            this.requests.set(null);
            this.responses.set(null);
        }
    }

    private void executeRequestAsTask(HttpServletRequest req) {
        Map<String, String[]> parameterMap = this.stripIncomingParameterList(req.getParameterMap());
        Map<String, String[]> paramMapWithTimestamp = this.addTimeStampParam(parameterMap);
        TaskOptions options = TaskOptions.Builder.withDefaults();
        options.url(req.getRequestURI()).header("Content-Type", "application/x-www-form-urlencoded").method(TaskOptions.Method.POST).retryOptions(RetryOptions.Builder.withTaskRetryLimit((int)5).minBackoffSeconds(5.0).maxBackoffSeconds(120.0).maxDoublings(5));
        for (String paramKey : paramMapWithTimestamp.keySet()) {
            String[] paramValues = paramMapWithTimestamp.get(paramKey);
            for (int i = 0; i < paramValues.length; ++i) {
                options.param(paramKey, paramValues[i]);
            }
        }
        String parametersHash = this.generateParameterHash(paramMapWithTimestamp, API_PRIVATE_KEY);
        options.param("h", parametersHash);
        log.log(Level.FINE, "Query params: " + options.getStringParams());
        Queue defaultQueue = QueueFactory.getDefaultQueue();
        defaultQueue.add(options);
    }

    private Map<String, String[]> stripIncomingParameterList(Map<String, String[]> parameterMap) {
        HashMap<String, String[]> strippedParamList = new HashMap<String, String[]>();
        for (String param : parameterMap.keySet()) {
            if (this.parameterShouldBeSkipped(param)) continue;
            strippedParamList.put(param, parameterMap.get(param));
        }
        return strippedParamList;
    }

    private Map<String, String[]> addTimeStampParam(Map<String, String[]> parameterMap) {
        HashMap<String, String[]> paramMapWithTs = new HashMap<String, String[]>(parameterMap);
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        paramMapWithTs.put("ts", new String[]{df.format(new Date())});
        return paramMapWithTs;
    }

    private String generateParameterHash(Map<String, String[]> paramMapWithTimestamp, String apiKey) {
        ArrayList<String> paramKeys = new ArrayList<String>(paramMapWithTimestamp.keySet());
        Collections.sort(paramKeys);
        StringBuilder queryString = new StringBuilder();
        for (String paramKey : paramKeys) {
            String[] values = paramMapWithTimestamp.get(paramKey);
            for (int i = 0; i < values.length; ++i) {
                try {
                    String encodedParam = URLEncoder.encode(values[i], "UTF-8");
                    queryString.append(paramKey).append("=").append(encodedParam).append("&");
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    log.warning("Failed to encode parameter: " + paramKey + "=" + values[i]);
                }
            }
        }
        queryString.deleteCharAt(queryString.lastIndexOf("&"));
        return MD5Util.generateHMAC(queryString.toString(), apiKey);
    }

    private boolean parameterShouldBeSkipped(String param) {
        return "runAsTask".equalsIgnoreCase(param) || "ts".equalsIgnoreCase(param) || "h".equalsIgnoreCase(param);
    }

    protected abstract RestRequest convertRequest() throws Exception;

    protected abstract RestResponse handleRequest(RestRequest var1) throws Exception;

    protected abstract void writeOkResponse(RestResponse var1) throws Exception;

    private void setContentType(HttpServletResponse resp) {
        if (XML_MODE.equalsIgnoreCase(this.mode)) {
            resp.setContentType("text/xml;charset=utf-8");
        } else if (JSON_MODE.equalsIgnoreCase(this.mode)) {
            resp.setContentType("application/json;charset=utf-8");
        } else if (XHTML_MODE.equalsIgnoreCase(this.mode)) {
            resp.setContentType("application/xhtml+xml");
        } else {
            resp.setContentType("text/plain");
        }
    }

    protected void writeErrorResponse(List<RestError> errs, HttpServletResponse resp) {
        try {
            resp.setStatus(500);
            if (errs != null) {
                for (RestError err : errs) {
                    resp.getWriter().print(err.toString() + "\n");
                }
            } else {
                resp.getWriter().print(new RestError());
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Could not write to servlet response object", e);
        }
    }

    protected HttpServletRequest getRequest() {
        return this.requests.get();
    }

    protected HttpServletResponse getResponse() {
        return this.responses.get();
    }

    private void checkThreadLocal() {
        if (this.requests == null) {
            this.requests = new ThreadLocal();
        }
        if (this.responses == null) {
            this.responses = new ThreadLocal();
        }
    }
}

