/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.framework.servlet;

import com.gallatinsystems.common.util.MD5Util;
import com.gallatinsystems.common.util.PropertyUtil;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.RetryOptions;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ExecuteRequestAsTaskFilter
implements Filter {
    private static Logger log = Logger.getLogger(ExecuteRequestAsTaskFilter.class.getName());
    public static final String REST_PRIVATE_KEY_PROP = "restPrivateKey";
    private String privateKey;
    private static final String RUN_AS_TASK = "1";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.privateKey = filterConfig.getInitParameter(REST_PRIVATE_KEY_PROP) != null ? filterConfig.getInitParameter(REST_PRIVATE_KEY_PROP) : PropertyUtil.getProperty(REST_PRIVATE_KEY_PROP);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (this.isTaskRequest(request)) {
            this.executeRequestAsTask(new RequestToTaskMapper(servletRequest, this.privateKey));
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public boolean isTaskRequest(HttpServletRequest request) {
        String runAsTask = request.getParameter("runAsTask");
        return RUN_AS_TASK.equals(runAsTask);
    }

    public void destroy() {
    }

    private void executeRequestAsTask(RequestToTaskMapper requestToTaskMapper) {
        TaskOptions options = TaskOptions.Builder.withDefaults();
        options.url(requestToTaskMapper.getUrl()).header("Content-Type", "application/x-www-form-urlencoded").method(TaskOptions.Method.POST).retryOptions(RetryOptions.Builder.withTaskRetryLimit((int)5).minBackoffSeconds(5.0).maxBackoffSeconds(120.0).maxDoublings(5));
        for (Map.Entry<String, String[]> entry : requestToTaskMapper.getTaskRequestParams().entrySet()) {
            String key = entry.getKey();
            String[] paramValues = entry.getValue();
            for (int i = 0; i < paramValues.length; ++i) {
                options.param(key, paramValues[i]);
            }
        }
        log.log(Level.FINE, "Query params: " + options.getStringParams());
        Queue defaultQueue = QueueFactory.getDefaultQueue();
        defaultQueue.add(options);
    }

    class RequestToTaskMapper {
        private HttpServletRequest request;
        private String privateHashKey;
        private SortedMap<String, String[]> taskRequestParams;

        public RequestToTaskMapper(ServletRequest servletRequest, String privateKey) {
            this.privateHashKey = privateKey;
            this.request = (HttpServletRequest)servletRequest;
            this.taskRequestParams = this.generateTaskParameters(this.request.getParameterMap());
        }

        private SortedMap<String, String[]> generateTaskParameters(Map<String, String[]> parameterMap) {
            TreeMap<String, String[]> taskParams = new TreeMap<String, String[]>();
            for (String paramKey : parameterMap.keySet()) {
                if (this.parameterShouldBeStripped(paramKey)) continue;
                taskParams.put(paramKey, parameterMap.get(paramKey));
            }
            taskParams.put("h", new String[]{this.generateParameterHash(taskParams)});
            return taskParams;
        }

        private String generateParameterHash(Map<String, String[]> paramMap) {
            TreeMap<String, String[]> sortedTaskParams = new TreeMap<String, String[]>(paramMap);
            StringBuilder queryString = new StringBuilder();
            for (Map.Entry entry : sortedTaskParams.entrySet()) {
                String paramKey = (String)entry.getKey();
                String[] values = (String[])entry.getValue();
                for (int i = 0; i < values.length; ++i) {
                    try {
                        String encodedParam = URLEncoder.encode(values[i], "UTF-8");
                        queryString.append(paramKey).append("=").append(encodedParam).append("&");
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        log.warning("Failed to encode parameter: " + paramKey + "=" + values[i]);
                    }
                }
            }
            queryString.deleteCharAt(queryString.lastIndexOf("&"));
            String hash = MD5Util.generateHMAC(queryString.toString(), this.privateHashKey);
            return hash;
        }

        private boolean parameterShouldBeStripped(String param) {
            return "runAsTask".equalsIgnoreCase(param) || "h".equalsIgnoreCase(param);
        }

        public String getUrl() {
            return this.request.getRequestURI();
        }

        public SortedMap<String, String[]> getTaskRequestParams() {
            return this.taskRequestParams;
        }
    }
}

