/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.survey.dao;

import com.gallatinsystems.device.domain.DeviceSurveyJobQueue;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

public class DeviceSurveyJobQueueDAO {
    public List<DeviceSurveyJobQueue> get(String devicePhoneNumber, String imei, String androidId) {
        Query query;
        PersistenceManager pm = PersistenceFilter.getManager();
        HashSet set = new HashSet();
        if (androidId != null) {
            query = pm.newQuery(DeviceSurveyJobQueue.class);
            query.setFilter("androidId == androidIdParam");
            query.declareParameters("String androidIdParam");
            set.addAll((List)query.execute((Object)androidId));
        }
        List legacy = null;
        if (imei != null && !"NO_IMEI".equals(imei)) {
            query = pm.newQuery(DeviceSurveyJobQueue.class);
            query.setFilter("imei == imeiParam");
            query.declareParameters("String imeiParam");
            legacy = (List)query.execute((Object)imei);
        }
        if ((legacy == null || legacy.isEmpty()) && devicePhoneNumber != null && !devicePhoneNumber.isEmpty()) {
            query = pm.newQuery(DeviceSurveyJobQueue.class);
            query.setFilter("devicePhoneNumber == devicePhoneNumberParam");
            query.declareParameters("String devicePhoneNumberParam");
            legacy = (List)query.execute((Object)devicePhoneNumber);
        }
        if (legacy != null) {
            set.addAll(legacy);
        }
        return new ArrayList<DeviceSurveyJobQueue>(set);
    }

    public Long save(DeviceSurveyJobQueue deviceSurveyJobQueue) {
        PersistenceManager pm = PersistenceFilter.getManager();
        pm.makePersistent((Object)deviceSurveyJobQueue);
        return deviceSurveyJobQueue.getId();
    }

    public void save(List<DeviceSurveyJobQueue> itemList) {
        PersistenceManager pm = PersistenceFilter.getManager();
        pm.makePersistentAll(itemList);
    }

    public List<DeviceSurveyJobQueue> listAllJobsInQueue() {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(DeviceSurveyJobQueue.class);
        List results = (List)query.execute();
        return results;
    }

    public void deleteJob(Long assignmentId) {
        List<DeviceSurveyJobQueue> results;
        if (assignmentId != null && (results = this.listJobByAssignment(assignmentId)) != null) {
            this.delete(results);
        }
    }

    public void delete(List<DeviceSurveyJobQueue> items) {
        PersistenceManager pm = PersistenceFilter.getManager();
        pm.deletePersistentAll(items);
    }

    public List<DeviceSurveyJobQueue> listJobByAssignment(Long assignmentId) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(DeviceSurveyJobQueue.class);
        String filterString = "assignmentId == assignmentIdParam";
        String paramString = "Long assignmentIdParam";
        query.setFilter(filterString);
        query.declareParameters(paramString);
        return (List)query.execute((Object)assignmentId);
    }

    public void updateAssignmentIdForSurvey(Long surveyId, Long assignmentId) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(DeviceSurveyJobQueue.class);
        String filterString = "surveyID == surveyIdParam";
        String paramString = "Long surveyIdParam";
        query.setFilter(filterString);
        query.declareParameters(paramString);
        List results = (List)query.execute((Object)surveyId);
        if (results != null) {
            for (DeviceSurveyJobQueue job : results) {
                job.setAssignmentId(assignmentId);
            }
            pm.makePersistentAll((Collection)results);
        }
    }

    public List<DeviceSurveyJobQueue> listAssignmentsWithEarlierExpirationDate(Date expirationDate) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(DeviceSurveyJobQueue.class);
        String filterString = "effectiveEndDate < expirationDateParam";
        String paramString = "java.util.Date expirationDateParam";
        query.declareImports("import java.util.Date");
        query.setFilter(filterString);
        query.declareParameters(paramString);
        return (List)query.execute((Object)expirationDate);
    }
}

