/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dataexport;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.waterforpeople.mapping.app.gwt.client.surveyinstance.SurveyInstanceDto;
import org.waterforpeople.mapping.app.web.dto.InstanceDataDto;

public class InstanceData {
    public final Map<Long, SortedMap<Long, String>> responseMap;
    public final SurveyInstanceDto surveyInstanceDto;
    public Set<Long> iterationsPresent;
    public String latestApprovalStatus;

    public InstanceData(InstanceDataDto instanceDataDto, Map<Long, Map<Long, String>> responseMap) {
        this(instanceDataDto.surveyInstanceData, responseMap);
        this.latestApprovalStatus = instanceDataDto.latestApprovalStatus;
    }

    public InstanceData(SurveyInstanceDto surveyInstanceDto, Map<Long, Map<Long, String>> responseMap) {
        Map<Long, String> iterationsMap;
        HashMap<Long, SortedMap<Long, String>> sortedResponseMap = new HashMap<Long, SortedMap<Long, String>>();
        this.iterationsPresent = new TreeSet<Long>();
        for (Map.Entry<Long, Map<Long, String>> entry : responseMap.entrySet()) {
            iterationsMap = entry.getValue();
            this.iterationsPresent.addAll(iterationsMap.keySet());
        }
        for (Map.Entry<Long, Map<Long, String>> entry : responseMap.entrySet()) {
            iterationsMap = entry.getValue();
            TreeMap<Long, String> sortedMap = new TreeMap<Long, String>();
            for (long i : this.iterationsPresent) {
                String value = iterationsMap.get(i);
                if (value == null) continue;
                sortedMap.put(i, value);
            }
            sortedResponseMap.put(entry.getKey(), sortedMap);
        }
        this.responseMap = sortedResponseMap;
        this.surveyInstanceDto = surveyInstanceDto;
    }

    public boolean addResponses(Map<Long, Map<Long, String>> additionalResponsesMap) {
        Map<Long, String> iterationsMap;
        for (Map.Entry<Long, Map<Long, String>> entry : additionalResponsesMap.entrySet()) {
            iterationsMap = entry.getValue();
            this.iterationsPresent.addAll(iterationsMap.keySet());
        }
        for (Map.Entry<Long, Map<Long, String>> entry : additionalResponsesMap.entrySet()) {
            iterationsMap = entry.getValue();
            TreeMap<Long, String> sortedMap = new TreeMap<Long, String>();
            for (long i : this.iterationsPresent) {
                String value = iterationsMap.get(i);
                sortedMap.put(i, value == null ? "" : value);
            }
            if (this.responseMap.containsKey(entry.getKey())) {
                return false;
            }
            this.responseMap.put(entry.getKey(), sortedMap);
        }
        return true;
    }

    public String toString() {
        if (this.surveyInstanceDto != null) {
            return this.surveyInstanceDto.getKeyId() + " '" + this.surveyInstanceDto.getSurveyedLocaleIdentifier() + "'";
        }
        return "InstanceData iterations " + this.iterationsPresent.toString();
    }
}

