/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    private static final int BUFFER = 2048;

    public static Boolean copyFile(String srcFile, String destFile) {
        Boolean copyFlag = false;
        File inputFile = new File(srcFile);
        File outputFile = new File(destFile);
        try {
            int c;
            FileReader in = new FileReader(inputFile);
            FileWriter out = new FileWriter(outputFile);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return copyFlag;
    }

    public static void generateKMZ(String inputFileName, String outputFileName) {
        try {
            int count;
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream("outputFileName");
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[2048];
            File f = new File(inputFileName);
            System.out.println("Adding: " + f.getName());
            FileInputStream fi = new FileInputStream(f);
            origin = new BufferedInputStream(fi, 2048);
            ZipEntry entry = new ZipEntry(f.getName());
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] readFileBytes(File fx) throws IOException {
        FileInputStream fis = new FileInputStream(fx);
        long length = fx.length();
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (int offset = 0; offset < bytes.length && (numRead = fis.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        fis.close();
        return bytes;
    }

    public static String writeToFile(String textToWrite, String fileName) {
        File outFile = new File(fileName);
        try {
            if (!outFile.exists()) {
                outFile.createNewFile();
            }
            FileWriter out = new FileWriter(outFile, true);
            out.write(textToWrite);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outFile.getAbsolutePath();
    }

    public static void main(String[] args) {
        Integer i = 0;
        while (i < 100) {
            FileUtil.writeToFile(i.toString() + "\n", "/devenv/reports/example.txt");
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public static void appendLineToFile(String textToWrite, String fileName) throws IOException {
        String eol = System.getProperty("line.separator");
        FileWriter out = new FileWriter(fileName, true);
        BufferedWriter writer = new BufferedWriter(out);
        writer.write(textToWrite + eol);
        writer.close();
    }

    public static String readFromFile(String fileName) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        FileInputStream fstream = new FileInputStream(fileName);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        in.close();
        return sb.toString();
    }

    public static boolean createDir(String directory) {
        File f = new File(directory);
        if (f.exists()) {
            return true;
        }
        return f.mkdirs();
    }
}

