/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.notification;

import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.notification.NotificationHandler;
import com.gallatinsystems.notification.NotificationRequest;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class NotificationProcessor
extends AbstractRestApiServlet {
    private static final long serialVersionUID = -4726303161585277346L;
    protected Map<String, String> notificationTypeMap = new HashMap<String, String>();

    public NotificationProcessor() {
        this.initializeTypeMapping();
    }

    protected abstract void initializeTypeMapping();

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        NotificationRequest restRequest = new NotificationRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest request) throws Exception {
        RestResponse response = new RestResponse();
        NotificationRequest notificationRequest = (NotificationRequest)request;
        String className = this.notificationTypeMap.get(notificationRequest.getType());
        if (className != null) {
            Class<?> cls = Class.forName(className);
            NotificationHandler handler = (NotificationHandler)cls.newInstance();
            HttpServletRequest req = this.getRequest();
            String serverBase = req.getScheme() + "://" + req.getServerName() + (req.getLocalPort() != 80 && req.getLocalPort() != 443 && req.getLocalPort() != 0 ? ":" + req.getLocalPort() : "");
            handler.generateNotification(notificationRequest.getType(), notificationRequest.getNotifEntityId(), notificationRequest.getDestinations(), notificationRequest.getDestOptions(), serverBase);
        } else {
            this.log("Could not find notification handler for type: " + notificationRequest.getType());
        }
        return response;
    }
}

