/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.helper;

import java.util.HashMap;
import java.util.Map;
import org.waterforpeople.mapping.dao.GeoIndexDao;

public class MappingSummarizationHelper {
    private GeoIndexDao geoIndexDao = new GeoIndexDao();
    private Map<String, StringBuilder> regionMap;
    private Map<String, String> firstPositionInPolys;

    public void addPointToRegion(String uuid, String lat, String lon) {
        StringBuilder buf;
        if (this.regionMap == null) {
            this.resetPoly();
        }
        if ((buf = this.regionMap.get(uuid)) == null) {
            buf = new StringBuilder();
            buf.append(lat + " " + lon);
            this.regionMap.put(uuid, buf);
            this.firstPositionInPolys.put(uuid, lat + " " + lon);
        } else {
            buf.append("," + lat + " " + lon);
        }
    }

    public void saveRegions() {
        if (this.regionMap != null) {
            GeoIndexDao indexDao = new GeoIndexDao();
            HashMap<String, String> regionStrings = new HashMap<String, String>();
            for (String region : this.regionMap.keySet()) {
                regionStrings.put(region, "POLYGON((" + this.regionMap.get(region) + "," + this.firstPositionInPolys.get(region) + "))");
            }
            indexDao.saveRegionIndex(regionStrings);
            this.resetPoly();
        }
    }

    public void resetPoly() {
        this.regionMap = new HashMap<String, StringBuilder>();
        this.firstPositionInPolys = new HashMap<String, String>();
    }

    public String processSummarization(String regionUUID, String type) {
        return null;
    }
}

