/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.notification;

import com.gallatinsystems.editorial.dao.EditorialPageDao;
import com.gallatinsystems.editorial.domain.EditorialPage;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.domain.Survey;
import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.SurveyInstance;
import org.waterforpeople.mapping.notification.BaseNotificationHandler;

public class SurveyEventNotificationHandler
extends BaseNotificationHandler {
    public static String[] EVENTS = new String[]{"surveySubmission", "surveyApproval"};
    public static final String APP_ED_PAGE_TEMPLATE = "Survey Approval Email Template";
    public static final String SUB_ED_PAGE_TEMPLATE = "Survey Submission Email Template";
    private static final String APPROVAL_HEADER = "A submission has been approved:";
    private static final String APPROVAL_FOOTER = "Please visit the dashboard to view the details";
    private static final String SUBMISSION_HEADER = "A submission has been received:";
    private static final String SUBMISSION_FOOTER = "Please visit the dashboard to approve";
    private static final String SUBMISSION_SUBJECT = "FLOW Submisson Received";
    private static final String APPROVAL_SUBJECT = "FLOW Submission Approval";
    private SurveyInstanceDAO instDao = new SurveyInstanceDAO();
    private SurveyDAO surveyDao = new SurveyDAO();

    @Override
    public void generateNotification(String type, Long entityId, String destinations, String destOptions, String serverBase) {
        StringBuilder contents = new StringBuilder();
        TreeMap<String, String> linkAddrList = new TreeMap<String, String>();
        StringTokenizer strTok = new StringTokenizer(destinations, "||");
        while (strTok.hasMoreTokens()) {
            String item = strTok.nextToken();
            linkAddrList.put(item, item);
        }
        String body = null;
        EditorialPageDao edDao = new EditorialPageDao();
        String head = null;
        String foot = null;
        String pageName = null;
        if (EVENTS[0].equalsIgnoreCase(type)) {
            pageName = SUB_ED_PAGE_TEMPLATE;
            head = SUBMISSION_HEADER;
            foot = SUBMISSION_FOOTER;
        } else if (EVENTS[1].equalsIgnoreCase(type)) {
            pageName = APP_ED_PAGE_TEMPLATE;
            head = APPROVAL_HEADER;
            foot = APPROVAL_FOOTER;
        }
        EditorialPage page = edDao.findByTargetPage(pageName);
        if (page == null) {
            body = this.formBody(head, contents.toString(), foot);
        } else {
            VelocityEngine engine = new VelocityEngine();
            engine.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogChute");
            try {
                StringWriter writer;
                engine.init();
                VelocityContext context = new VelocityContext();
                context.put("surveyInstanceId", (Object)entityId);
                SurveyInstance inst = (SurveyInstance)this.instDao.getByKey(entityId);
                if (inst != null) {
                    context.put("submitter", (Object)(inst.getSubmitterName() != null ? inst.getSubmitterName() : ""));
                    context.put("submissionDate", (Object)inst.getCollectionDate());
                    Survey s = this.surveyDao.getById(inst.getSurveyId());
                    if (s != null) {
                        context.put("surveyId", (Object)s.getKey().getId());
                        context.put("surveyName", (Object)s.getName());
                        context.put("surveyPath", (Object)s.getPath());
                    }
                }
                if (engine.evaluate((Context)context, (Writer)(writer = new StringWriter()), "LOG", page.getTemplate().getValue())) {
                    body = writer.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sendMail(linkAddrList, EVENTS[0].equalsIgnoreCase(type) ? SUBMISSION_SUBJECT : APPROVAL_SUBJECT, body);
    }

    private String formBody(String header, String contents, String footer) {
        return header + "\n" + contents + "\n" + footer;
    }
}

