/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.api.app;

import com.gallatinsystems.device.dao.DeviceDAO;
import com.gallatinsystems.device.domain.Device;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import java.util.List;
import java.util.logging.Logger;
import org.akvo.flow.dao.DataPointAssignmentDao;
import org.akvo.flow.domain.persistent.DataPointAssignment;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.SurveyInstance;

public class FormInstanceUtil {
    private static final Logger log = Logger.getLogger(FormInstanceUtil.class.getName());
    SurveyedLocaleDao surveyedLocaleDao = new SurveyedLocaleDao();
    DataPointAssignmentDao dataPointAssignmentDao = new DataPointAssignmentDao();

    public List<SurveyInstance> getFormInstances(String androidId, long dataPointId, String cursor) throws Exception {
        DeviceDAO deviceDao = new DeviceDAO();
        Device device = deviceDao.getDevice(androidId, null, null);
        if (device == null) {
            throw new Exception("Device not found");
        }
        log.fine("Found device: " + device);
        SurveyedLocale dataPoint = this.surveyedLocaleDao.getById(dataPointId);
        if (dataPoint == null) {
            throw new Exception("Datapoint not found");
        }
        log.fine("Datapoint: " + dataPoint);
        List<DataPointAssignment> dataPointAssignments = this.dataPointAssignmentDao.listByDeviceAndSurvey(device.getKey().getId(), dataPoint.getSurveyGroupId());
        if (dataPointAssignments.isEmpty()) {
            throw new Exception("No assignments found");
        }
        SurveyInstanceDAO siDAO = new SurveyInstanceDAO();
        return siDAO.listInstancesByLocale(dataPoint.getKey().getId(), null, null, 30, cursor);
    }
}

