/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.QuestionOptionDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionOption;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.akvo.flow.domain.mapper.QuestionDtoMapper;
import org.akvo.flow.domain.mapper.QuestionOptionDtoMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionOptionDto;
import org.waterforpeople.mapping.app.web.rest.dto.QuestionListPayload;
import org.waterforpeople.mapping.app.web.rest.dto.QuestionPayload;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;
import org.waterforpeople.mapping.dao.QuestionAnswerStoreDao;

@Controller
@RequestMapping(value={"/questions"})
public class QuestionRestService {
    private QuestionDao questionDao = new QuestionDao();
    private QuestionOptionDao questionOptionDao = new QuestionOptionDao();
    private SurveyDAO surveyDao = new SurveyDAO();
    private SurveyGroupDAO surveyGroupDao = new SurveyGroupDAO();

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, Object> listQuestions(@RequestParam(value="questionGroupId", defaultValue="") Long questionGroupId, @RequestParam(value="surveyId", defaultValue="") Long surveyId, @RequestParam(value="optionQuestionsOnly", defaultValue="") String optionQuestionsOnlyParam, @RequestParam(value="preflight", defaultValue="") String preflight, @RequestParam(value="questionId", defaultValue="") Long questionId, @RequestParam(value="cascadeResourceId", defaultValue="") Long cascadeResourceId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        List<Object> questions = new ArrayList();
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("");
        statusDto.setMessage("");
        boolean listOptionQuestionOnly = "true".equals(optionQuestionsOnlyParam);
        if (preflight != null && preflight.equals("delete") && questionId != null) {
            QuestionAnswerStoreDao qasDao = new QuestionAnswerStoreDao();
            statusDto.setStatus("preflight-delete-question");
            statusDto.setMessage("cannot_delete");
            if (qasDao.listByQuestion(questionId).size() == 0) {
                statusDto.setMessage("can_delete");
                statusDto.setKeyId(questionId);
            }
        } else if (questionGroupId != null) {
            questions = this.questionDao.listQuestionsInOrderForGroup(questionGroupId);
        } else if (surveyId != null) {
            questions = listOptionQuestionOnly ? this.questionDao.listQuestionsInOrder(surveyId, Question.Type.OPTION) : this.questionDao.listQuestionsInOrder(surveyId, null);
        } else if (cascadeResourceId != null) {
            questions = this.questionDao.listByCascadeResourceId(cascadeResourceId);
        }
        ArrayList<QuestionDto> questionDtoList = new ArrayList<QuestionDto>();
        ArrayList<QuestionOptionDto> questionOptionDtoList = new ArrayList<QuestionOptionDto>();
        if (questions != null && questions.size() > 0) {
            for (Question question : questions) {
                QuestionDto qDto = QuestionDtoMapper.transform(question);
                if (qDto == null) continue;
                questionDtoList.add(qDto);
            }
            if (!listOptionQuestionOnly) {
                questionOptionDtoList.addAll(this.retrieveQuestionOptionList(questionDtoList));
                QuestionRestService.setQuestionOptionsIdList(questionDtoList, questionOptionDtoList);
            }
        }
        response.put("questionOptions", questionOptionDtoList);
        response.put("questions", questionDtoList);
        response.put("meta", statusDto);
        return response;
    }

    private List<QuestionOptionDto> retrieveQuestionOptionList(List<QuestionDto> questionDtoList) {
        if (questionDtoList == null || questionDtoList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> optionTypeQuestionIds = new ArrayList<Long>();
        for (QuestionDto question : questionDtoList) {
            if (!QuestionDto.QuestionType.OPTION.equals((Object)question.getType())) continue;
            optionTypeQuestionIds.add(question.getKeyId());
        }
        ArrayList<QuestionOptionDto> questionOptionDtoList = new ArrayList<QuestionOptionDto>();
        for (QuestionOption qo : this.questionOptionDao.listByQuestionId(optionTypeQuestionIds)) {
            QuestionOptionDto qoDto = QuestionOptionDtoMapper.transform(qo);
            questionOptionDtoList.add(qoDto);
        }
        return questionOptionDtoList;
    }

    private static void setQuestionOptionsIdList(List<QuestionDto> questionDtoList, List<QuestionOptionDto> questionOptionDtoList) {
        HashMap<Long, QuestionDto> questionDtoMap = new HashMap<Long, QuestionDto>();
        for (QuestionDto questionDto : questionDtoList) {
            if (!QuestionDto.QuestionType.OPTION.equals((Object)questionDto.getType())) continue;
            questionDtoMap.put(questionDto.getKeyId(), questionDto);
        }
        for (QuestionOptionDto qoDto : questionOptionDtoList) {
            QuestionDto questionDto = (QuestionDto)questionDtoMap.get(qoDto.getQuestionId());
            if (questionDto.getQuestionOptions() == null) {
                questionDto.setQuestionOptions(new ArrayList<Long>());
            }
            questionDto.getQuestionOptions().add(qoDto.getKeyId());
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> findQuestion(@PathVariable(value="id") Long id) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        List<Object> qoResults = new ArrayList();
        Question q = this.questionDao.getByKey(id);
        QuestionDto dto = null;
        if (q != null) {
            dto = QuestionDtoMapper.transform(q);
            qoResults = this.attachAnyOptions(dto);
        }
        response.put("questionOptions", qoResults);
        response.put("question", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteQuestionById(@PathVariable(value="id") Long questionId) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        Question q = this.questionDao.getByKey(questionId);
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        statusDto.setMessage("_cannot_delete");
        if (q != null) {
            try {
                TaskOptions deleteQuestionTask = TaskOptions.Builder.withUrl((String)"/app_worker/surveytask").param("action", "deleteQuestion").param("id", questionId.toString());
                QueueFactory.getQueue((String)"deletequeue").add(deleteQuestionTask);
                statusDto.setStatus("ok");
                statusDto.setMessage("deleted");
            }
            catch (Exception e) {
                statusDto.setStatus("failed");
                statusDto.setMessage(e.getMessage());
            }
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> saveExistingQuestion(@RequestBody QuestionPayload payLoad) {
        Question q;
        Long keyId;
        QuestionDto questionDto = payLoad.getQuestion();
        HashMap<String, Object> response = new HashMap<String, Object>();
        QuestionDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        statusDto.setMessage("Cannot change question");
        if (questionDto != null && (keyId = questionDto.getKeyId()) != null && (q = this.questionDao.getByKey(keyId)) != null) {
            BeanUtils.copyProperties((Object)questionDto, (Object)q, (String[])new String[]{"createdDateTime", "type", "optionList"});
            if (questionDto.getType() != null) {
                q.setType(Question.Type.valueOf(questionDto.getType().toString()));
            }
            q = this.questionDao.save(q);
            dto = QuestionDtoMapper.transform(q);
            statusDto.setStatus("ok");
            statusDto.setMessage("");
        }
        response.put("meta", statusDto);
        response.put("question", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/bulk"})
    @ResponseBody
    public Map<String, Object> saveExistingQuestions(@RequestBody QuestionListPayload payLoad) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        statusDto.setMessage("No questions to change");
        ArrayList<Question> saveList = new ArrayList<Question>();
        List<QuestionDto> requestList = payLoad.getQuestions();
        if (requestList != null && requestList.size() > 0) {
            for (QuestionDto questionDto : requestList) {
                if (questionDto == null) continue;
                Long keyId = questionDto.getKeyId();
                if (keyId != null) {
                    Question q = this.questionDao.getByKey(keyId);
                    if (q != null) {
                        BeanUtils.copyProperties((Object)questionDto, (Object)q, (String[])new String[]{"createdDateTime", "type", "optionList"});
                        if (questionDto.getType() != null) {
                            q.setType(Question.Type.valueOf(questionDto.getType().toString()));
                        }
                        saveList.add(q);
                        continue;
                    }
                    statusDto.setMessage("Cannot change unknown question " + keyId);
                    response.put("meta", statusDto);
                    return response;
                }
                statusDto.setMessage("Cannot change question without id");
                response.put("meta", statusDto);
                return response;
            }
            this.questionDao.save((List<Question>)saveList);
            statusDto.setStatus("ok");
            statusDto.setMessage("");
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> saveNewQuestion(@RequestBody QuestionPayload payLoad) {
        QuestionDto questionDto = payLoad.getQuestion();
        HashMap<String, Object> response = new HashMap<String, Object>();
        List<Object> qoResults = new ArrayList();
        QuestionDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        statusDto.setMessage("Cannot create question");
        if (questionDto != null) {
            Question q = null;
            q = questionDto.getSourceId() == null ? this.newQuestion(questionDto) : this.copyQuestion(questionDto);
            dto = QuestionDtoMapper.transform(q);
            statusDto.setStatus("ok");
            statusDto.setMessage("");
            qoResults = this.attachAnyOptions(dto);
        }
        response.put("meta", statusDto);
        response.put("questionOptions", qoResults);
        response.put("question", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{id}/validate"})
    @ResponseBody
    public Map<String, Object> validateQuestionId(@PathVariable(value="id") Long id, @RequestParam(value="variableName") String variableName) {
        Question question = this.questionDao.getByKey(id);
        Long surveyId = question.getSurveyId();
        Survey survey = this.surveyDao.getById(surveyId);
        Long surveyGroupId = survey.getSurveyGroupId();
        SurveyGroup surveyGroup = (SurveyGroup)this.surveyGroupDao.getByKey(surveyGroupId);
        boolean isMonitoringGroup = surveyGroup.getMonitoringGroup();
        List<Object> surveys = new ArrayList<Survey>();
        if (isMonitoringGroup) {
            surveys = this.surveyDao.listSurveysByGroup(surveyGroupId);
        } else {
            surveys.add(survey);
        }
        ArrayList<Question> questions = new ArrayList<Question>();
        for (Survey survey2 : surveys) {
            questions.addAll(this.questionDao.listQuestionsBySurvey(survey2.getKey().getId()));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Question q : questions) {
            if (!variableName.equalsIgnoreCase(q.getVariableName()) || question.getKey().equals((Object)q.getKey())) continue;
            result.put("success", false);
            result.put("reason", "Variable name not unique");
            return result;
        }
        result.put("success", true);
        return result;
    }

    private Question copyQuestion(QuestionDto dto) {
        Question source = this.questionDao.getByKey(dto.getSourceId());
        if (source == null) {
            return null;
        }
        return SurveyUtils.copyQuestion(source, dto.getQuestionGroupId(), dto.getOrder(), source.getSurveyId(), SurveyUtils.listQuestionIdsUsedInSurveyGroup(source.getSurveyId()), false);
    }

    private Question newQuestion(QuestionDto dto) {
        Question q = new Question();
        BeanUtils.copyProperties((Object)dto, (Object)q, (String[])new String[]{"createdDateTime", "type"});
        if (dto.getType() != null) {
            q.setType(Question.Type.valueOf(dto.getType().toString()));
        }
        Question result = this.questionDao.save(q);
        return result;
    }

    private List<QuestionOptionDto> attachAnyOptions(QuestionDto dto) {
        if (dto.getType() == QuestionDto.QuestionType.OPTION) {
            ArrayList<QuestionOptionDto> qoResults = new ArrayList<QuestionOptionDto>();
            List<QuestionOption> qoList = this.questionOptionDao.listByQuestionId(dto.getKeyId());
            ArrayList<Long> qoIdList = new ArrayList<Long>();
            for (QuestionOption qo : qoList) {
                qoIdList.add(qo.getKey().getId());
                QuestionOptionDto qoDto = QuestionOptionDtoMapper.transform(qo);
                qoResults.add(qoDto);
            }
            dto.setQuestionOptions(qoIdList);
            return qoResults;
        }
        return Collections.emptyList();
    }
}

