/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.survey.dao;

import com.gallatinsystems.common.Constants;
import com.gallatinsystems.common.util.HttpUtil;
import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.framework.domain.BaseDomain;
import com.gallatinsystems.survey.dao.CascadeResourceDao;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.QuestionGroupDao;
import com.gallatinsystems.survey.dao.QuestionOptionDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.dao.TranslationDao;
import com.gallatinsystems.survey.domain.CascadeResource;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.QuestionOption;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.survey.domain.Translation;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.akvo.flow.dao.MessageDao;
import org.akvo.flow.domain.Message;
import org.akvo.flow.domain.SecuredObject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.springframework.beans.BeanUtils;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyDto;

public class SurveyUtils {
    private static final Logger log = Logger.getLogger(SurveyUtils.class.getName());

    public static Survey copySurvey(Survey source, SurveyDto dto, boolean immutable) {
        SurveyDAO sDao = new SurveyDAO();
        Survey tmp = new Survey();
        BeanUtils.copyProperties((Object)source, (Object)tmp, (String[])Constants.EXCLUDED_PROPERTIES);
        tmp.setCode(dto.getCode());
        tmp.setName(dto.getName());
        tmp.setSurveyGroupId(dto.getSurveyGroupId());
        tmp.setStatus(Survey.Status.COPYING);
        tmp.setPath(SurveyUtils.getPath(tmp));
        tmp.setVersion(Double.valueOf("1.0"));
        log.log(Level.INFO, "Copying `Survey` " + source.getKey().getId());
        Survey newSurvey = sDao.save(tmp);
        log.log(Level.INFO, "New `Survey` ID: " + newSurvey.getKey().getId());
        SurveyUtils.copyTranslation(source.getKey().getId(), newSurvey.getKey().getId(), newSurvey.getKey().getId(), null, Translation.ParentType.SURVEY_NAME, Translation.ParentType.SURVEY_DESC);
        log.log(Level.INFO, "Running rest of copy functionality as a task...");
        Queue queue = QueueFactory.getDefaultQueue();
        TaskOptions options = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "copySurvey").param("surveyId", String.valueOf(newSurvey.getKey().getId())).param("source", String.valueOf(source.getKey().getId())).param("immutable", String.valueOf(immutable));
        queue.add(options);
        return newSurvey;
    }

    public static void copySurvey(Long copiedSurveyId, Long originalSurveyId, boolean immutable) {
        Map<Long, Translation> copiedTranslations = SurveyUtils.copyTranslations(originalSurveyId, copiedSurveyId);
        QuestionGroupDao qgDao = new QuestionGroupDao();
        List<QuestionGroup> qgList = qgDao.listQuestionGroupBySurvey(originalSurveyId);
        HashMap<Long, Long> qDependencyResolutionMap = new HashMap<Long, Long>();
        if (qgList == null) {
            log.log(Level.INFO, "Nothing to copy from {surveyId: " + originalSurveyId + "} to {surveyId: " + copiedSurveyId + "}");
            SurveyUtils.resetSurveyState(copiedSurveyId);
            return;
        }
        log.log(Level.INFO, "Copying " + qgList.size() + " `QuestionGroup`");
        Map<Long, QuestionGroup> sourceToCopiedGroupMap = SurveyUtils.shallowCopyQuestionGroups(copiedSurveyId, immutable, qgList);
        new QuestionGroupDao().save(sourceToCopiedGroupMap.values());
        for (Map.Entry<Long, QuestionGroup> entry : sourceToCopiedGroupMap.entrySet()) {
            Long sourceGroupId = entry.getKey();
            QuestionGroup copyGroup = entry.getValue();
            SurveyUtils.copyQuestionGroupContent(sourceGroupId, copyGroup, qDependencyResolutionMap, null, immutable, copiedTranslations);
            SurveyUtils.updateTranslation(copiedTranslations, sourceGroupId, copyGroup.getKey().getId(), copyGroup.getKey().getId());
        }
        SurveyDAO sDao = new SurveyDAO();
        Survey copiedSurvey = SurveyUtils.resetSurveyState(copiedSurveyId);
        Survey originalSurvey = sDao.getById(originalSurveyId);
        if (copiedTranslations.size() > 0) {
            new TranslationDao().save(copiedTranslations.values());
        }
        MessageDao mDao = new MessageDao();
        Message message = new Message();
        message.setObjectId(copiedSurveyId);
        message.setObjectTitle(copiedSurvey.getName());
        message.setActionAbout("copySurvey");
        message.setShortMessage("Copying from Survey " + originalSurveyId + " (" + originalSurvey.getName() + ") completed");
        mDao.save(message);
    }

    public static Map<Long, QuestionGroup> shallowCopyQuestionGroups(Long formId, boolean immutable, List<QuestionGroup> questionGroupList) {
        HashMap<Long, QuestionGroup> sourceToCopiedGroupMap = new HashMap<Long, QuestionGroup>();
        for (QuestionGroup sourceGroup : questionGroupList) {
            QuestionGroup copyGroup = new QuestionGroup();
            SurveyUtils.shallowCopy(sourceGroup, copyGroup);
            copyGroup.setImmutable(immutable);
            copyGroup.setSurveyId(formId);
            sourceToCopiedGroupMap.put(sourceGroup.getKey().getId(), copyGroup);
        }
        return sourceToCopiedGroupMap;
    }

    public static void copyQuestionGroupContent(Long sourceGroupId, QuestionGroup copyGroup, Map<Long, Long> qDependencyResolutionMap, Set<String> idsInUse, boolean immutable, Map<Long, Translation> translationMap) {
        QuestionDao qDao = new QuestionDao();
        Long copyGroupId = copyGroup.getKey().getId();
        List<Question> qList = qDao.listQuestionsInOrderForGroup(sourceGroupId);
        if (qList == null) {
            return;
        }
        log.log(Level.INFO, "Copying " + qList.size() + " `Question`");
        int qCount = 1;
        HashMap<Long, Question> sourceIdToQuestionCopyMap = new HashMap<Long, Question>();
        for (Question question : qList) {
            Question questionCopy = SurveyUtils.shallowCopyQuestion(question, copyGroup, qCount, idsInUse, immutable);
            sourceIdToQuestionCopyMap.put(question.getKey().getId(), questionCopy);
            ++qCount;
        }
        new QuestionDao().save(sourceIdToQuestionCopyMap.values());
        HashMap<Long, QuestionOption> sourceIdToQuestionOptionCopyMap = new HashMap<Long, QuestionOption>();
        for (Map.Entry sourceCopyPair : sourceIdToQuestionCopyMap.entrySet()) {
            Long sourceQuestionId = (Long)sourceCopyPair.getKey();
            Question copiedQuestion = (Question)sourceCopyPair.getValue();
            sourceIdToQuestionOptionCopyMap.putAll(SurveyUtils.copyQuestionContent(copiedQuestion, sourceQuestionId, translationMap));
            SurveyUtils.updateTranslation(translationMap, sourceQuestionId, copiedQuestion.getKey().getId(), copyGroupId);
        }
        new QuestionOptionDao().save(sourceIdToQuestionOptionCopyMap.values());
        for (Map.Entry sourceCopyPair : sourceIdToQuestionOptionCopyMap.entrySet()) {
            Long sourceQuestionOptionId = (Long)sourceCopyPair.getKey();
            QuestionOption copiedQuestionOption = (QuestionOption)sourceCopyPair.getValue();
            SurveyUtils.updateTranslation(translationMap, sourceQuestionOptionId, copiedQuestionOption.getKey().getId(), copyGroupId);
        }
        SurveyUtils.fixGroupDependencies(qDependencyResolutionMap, qDao, sourceIdToQuestionCopyMap.values());
    }

    public static QuestionGroup copyQuestionGroupContent(QuestionGroup sourceGroup, QuestionGroup copyGroup, Long newSurveyId, Map<Long, Long> qDependencyResolutionMap, Set<String> idsInUse, boolean immutable) {
        QuestionDao qDao = new QuestionDao();
        Long sourceGroupId = sourceGroup.getKey().getId();
        Long copyGroupId = copyGroup.getKey().getId();
        SurveyUtils.copyTranslation(sourceGroupId, copyGroupId, newSurveyId, copyGroupId, Translation.ParentType.QUESTION_GROUP_NAME, Translation.ParentType.QUESTION_GROUP_DESC);
        List<Question> qList = qDao.listQuestionsInOrderForGroup(sourceGroupId);
        if (qList == null) {
            return copyGroup;
        }
        log.log(Level.INFO, "Copying " + qList.size() + " `Question`");
        int qCount = 1;
        ArrayList<Question> qCopyList = new ArrayList<Question>();
        for (Question question : qList) {
            Question questionCopy = SurveyUtils.copyQuestion(idsInUse, immutable, copyGroup, qCount, question);
            qCopyList.add(questionCopy);
            ++qCount;
        }
        SurveyUtils.fixGroupDependencies(qDependencyResolutionMap, qDao, qCopyList);
        return copyGroup;
    }

    private static void fixGroupDependencies(Map<Long, Long> qDependencyResolutionMap, QuestionDao qDao, Collection<Question> qCopyList) {
        if (qDependencyResolutionMap == null) {
            return;
        }
        ArrayList<Question> dependentQuestionList = new ArrayList<Question>();
        for (Question questionCopy : qCopyList) {
            qDependencyResolutionMap.put(questionCopy.getSourceQuestionId(), questionCopy.getKey().getId());
            if (questionCopy.getDependentFlag() == null || !questionCopy.getDependentFlag().booleanValue()) continue;
            Long originalDependentId = questionCopy.getDependentQuestionId();
            questionCopy.setDependentQuestionId(qDependencyResolutionMap.get(originalDependentId));
            dependentQuestionList.add(questionCopy);
        }
        qDao.save((List<Question>)dependentQuestionList);
        log.log(Level.INFO, "Resolved dependencies for " + dependentQuestionList.size() + " `Question`");
    }

    private static Map<Long, QuestionOption> copyQuestionContent(Question questionCopy, Long sourceQuestionId, Map<Long, Translation> translations) {
        if (!Question.Type.OPTION.equals((Object)questionCopy.getType())) {
            return Collections.emptyMap();
        }
        QuestionOptionDao qoDao = new QuestionOptionDao();
        TreeMap<Integer, QuestionOption> options = qoDao.listOptionByQuestion(sourceQuestionId);
        if (options == null) {
            return Collections.emptyMap();
        }
        log.log(Level.FINE, "Copying " + options.values().size() + " `QuestionOption`");
        HashMap<Long, QuestionOption> sourceIdToQuestionOptionMap = new HashMap<Long, QuestionOption>();
        for (QuestionOption qo : options.values()) {
            sourceIdToQuestionOptionMap.put(qo.getKey().getId(), SurveyUtils.shallowCopyQuestionOption(qo, questionCopy.getKey().getId()));
        }
        return sourceIdToQuestionOptionMap;
    }

    public static Question copyQuestion(Set<String> idsInUse, boolean immutable, QuestionGroup questionGroup, Integer order, Question source) {
        Question copy = SurveyUtils.shallowCopyQuestion(source, questionGroup, order, idsInUse, immutable);
        Question newQuestion = new QuestionDao().save(copy);
        log.log(Level.FINE, "Copying question translations");
        SurveyUtils.copyTranslation(source.getKey().getId(), newQuestion.getKey().getId(), newQuestion.getSurveyId(), newQuestion.getQuestionGroupId(), Translation.ParentType.QUESTION_NAME, Translation.ParentType.QUESTION_DESC, Translation.ParentType.QUESTION_TEXT, Translation.ParentType.QUESTION_TIP);
        SurveyUtils.copyQuestionOptions(newQuestion, source.getKey().getId());
        return newQuestion;
    }

    private static Question shallowCopyQuestion(Question source, QuestionGroup newQuestionGroup, Integer order, Set<String> idsInUse, boolean immutable) {
        QuestionDao qDao = new QuestionDao();
        Question tmp = new Question();
        Long sourceQuestionId = source.getKey().getId();
        Object[] questionExcludedProps = new String[]{"questionOptionMap", "questionHelpMediaMap", "scoringRules", "translationMap", "order", "questionId"};
        String[] allExcludedProps = (String[])ArrayUtils.addAll((Object[])questionExcludedProps, (Object[])Constants.EXCLUDED_PROPERTIES);
        log.log(Level.INFO, "Copying `Question` " + sourceQuestionId);
        BeanUtils.copyProperties((Object)source, (Object)tmp, (String[])allExcludedProps);
        tmp.setSurveyId(newQuestionGroup.getSurveyId());
        tmp.setQuestionGroupId(newQuestionGroup.getKey().getId());
        tmp.setOrder(order);
        tmp.setSourceQuestionId(sourceQuestionId);
        tmp.setImmutable(immutable);
        if (source.getVariableName() != null) {
            if (idsInUse != null) {
                String newId = source.getVariableName() + "_1";
                int index = 2;
                while (idsInUse.contains(newId)) {
                    newId = source.getVariableName() + "_" + index++;
                }
                tmp.setVariableName(newId);
                idsInUse.add(newId);
                log.log(Level.FINE, "Changing QuestionId from " + source.getVariableName() + " to " + newId);
            } else {
                tmp.setVariableName(source.getVariableName());
                log.log(Level.FINE, "Keeping QuestionId " + source.getVariableName());
            }
        }
        return tmp;
    }

    private static void copyQuestionOptions(Map<Long, Translation> translations, Question newQuestion, Long sourceQuestionId) {
        if (!Question.Type.OPTION.equals((Object)newQuestion.getType())) {
            return;
        }
        QuestionOptionDao qoDao = new QuestionOptionDao();
        TreeMap<Integer, QuestionOption> options = qoDao.listOptionByQuestion(sourceQuestionId);
        if (options == null) {
            return;
        }
        log.log(Level.FINE, "Copying " + options.values().size() + " `QuestionOption`");
        for (QuestionOption qo : options.values()) {
            QuestionOption newOption = SurveyUtils.shallowCopyQuestionOption(qo, newQuestion.getKey().getId());
            SurveyUtils.updateTranslation(translations, qo.getKey().getId(), newOption.getKey().getId(), newQuestion.getQuestionGroupId());
        }
    }

    private static void copyQuestionOptions(Question newQuestion, Long sourceQuestionId) {
        if (!Question.Type.OPTION.equals((Object)newQuestion.getType())) {
            return;
        }
        QuestionOptionDao qoDao = new QuestionOptionDao();
        TreeMap<Integer, QuestionOption> options = qoDao.listOptionByQuestion(sourceQuestionId);
        if (options == null) {
            return;
        }
        log.log(Level.FINE, "Copying " + options.values().size() + " `QuestionOption`");
        for (QuestionOption qo : options.values()) {
            QuestionOption newOption = qoDao.save(SurveyUtils.shallowCopyQuestionOption(qo, newQuestion.getKey().getId()));
            log.log(Level.INFO, "Copying question option translations");
            SurveyUtils.copyTranslation(sourceQuestionId, newOption.getKey().getId(), newQuestion.getSurveyId(), newQuestion.getQuestionGroupId(), Translation.ParentType.QUESTION_OPTION);
        }
    }

    private static QuestionOption shallowCopyQuestionOption(QuestionOption source, Long newQuestionId) {
        QuestionOption tmp = new QuestionOption();
        BeanUtils.copyProperties((Object)source, (Object)tmp, (String[])Constants.EXCLUDED_PROPERTIES);
        tmp.setQuestionId(newQuestionId);
        log.log(Level.INFO, "Copying `QuestionOption` " + source.getKey().getId());
        return tmp;
    }

    private static void updateTranslation(Map<Long, Translation> translations, Long originalParentId, Long parentId, Long questionGroupId) {
        Translation translation = translations.get(originalParentId);
        if (translation != null) {
            translation.setParentId(parentId);
            translation.setQuestionGroupId(questionGroupId);
        }
    }

    public static Survey resetSurveyState(Long surveyId) {
        SurveyDAO sDao = new SurveyDAO();
        Survey s = sDao.getById(surveyId);
        s.setStatus(Survey.Status.NOT_PUBLISHED);
        return sDao.save(s);
    }

    public static Survey retrieveSurvey(Long surveyId) {
        SurveyDAO sDao = new SurveyDAO();
        return sDao.getById(surveyId);
    }

    public static SurveyGroup retrieveSurveyGroup(Long surveyGroupId) {
        SurveyGroupDAO surveyGroupDAO = new SurveyGroupDAO();
        return (SurveyGroup)surveyGroupDAO.getByKey(surveyGroupId);
    }

    public static String getPath(Survey s) {
        if (s == null) {
            return null;
        }
        SurveyGroupDAO dao = new SurveyGroupDAO();
        SurveyGroup sg = (SurveyGroup)dao.getByKey(s.getSurveyGroupId());
        if (sg == null) {
            return null;
        }
        return sg.getPath() + "/" + s.getName();
    }

    public static List<Long> retrieveAncestorIds(SecuredObject s) {
        ArrayList<Long> ancestorIds = new ArrayList<Long>();
        if (s.getParentObject() == null) {
            return null;
        }
        SecuredObject parent = s.getParentObject();
        if (parent.listAncestorIds() != null) {
            ancestorIds.addAll(parent.listAncestorIds());
        }
        ancestorIds.add(parent.getObjectId());
        return ancestorIds;
    }

    public static String fixPath(String oldPath, String newName) {
        if (oldPath == null || newName == null) {
            return oldPath;
        }
        int idx = oldPath.lastIndexOf("/");
        if (idx >= 0) {
            return oldPath.substring(0, idx) + "/" + newName;
        }
        return oldPath;
    }

    public static List<Translation> getTranslations(Long parentId, Translation.ParentType ... types) {
        ArrayList<Translation> trs = new ArrayList<Translation>();
        TranslationDao trDao = new TranslationDao();
        for (Translation.ParentType pt : types) {
            trs.addAll(trDao.findTranslations(pt, parentId).values());
        }
        return trs;
    }

    public static void saveTranslationCopy(List<Translation> trs, Long newParentId, Long newSurveyId, Long newQuestionGroupId) {
        TranslationDao trDao = new TranslationDao();
        for (Translation t : trs) {
            Translation copy = new Translation();
            BeanUtils.copyProperties((Object)t, (Object)copy, (String[])Constants.EXCLUDED_PROPERTIES);
            copy.setParentId(newParentId);
            copy.setQuestionGroupId(newQuestionGroupId);
            copy.setSurveyId(newSurveyId);
            trDao.save(copy);
        }
    }

    public static void copyTranslation(Long sourceParentId, Long copyParentId, Long newSurveyId, Long newQuestionGroupId, Translation.ParentType ... types) {
        SurveyUtils.saveTranslationCopy(SurveyUtils.getTranslations(sourceParentId, types), copyParentId, newSurveyId, newQuestionGroupId);
    }

    public static Map<Long, Translation> copyTranslations(Long sourceFormId, Long targetFormId) {
        TranslationDao translationDao = new TranslationDao();
        List<Translation> sourceFormTranslations = translationDao.listByFormId(sourceFormId);
        HashMap<Long, Translation> targetFormTranslations = new HashMap<Long, Translation>();
        for (Translation t : sourceFormTranslations) {
            if (t.getParentType().toString().startsWith("SURVEY_")) continue;
            Translation copy = new Translation();
            BeanUtils.copyProperties((Object)t, (Object)copy, (String[])Constants.EXCLUDED_PROPERTIES);
            copy.setSurveyId(targetFormId);
            targetFormTranslations.put(t.getParentId(), copy);
        }
        return targetFormTranslations;
    }

    public static String publishCascade(Long cascadeResourceId) {
        String status = "failed";
        CascadeResourceDao crDao = new CascadeResourceDao();
        CascadeResource cr = (CascadeResource)crDao.getByKey(cascadeResourceId);
        if (cr != null) {
            String flowServiceURL = PropertyUtil.getProperty("flowServices");
            String uploadUrl = PropertyUtil.getProperty("surveyuploadurl");
            if (flowServiceURL == null || "".equals(flowServiceURL)) {
                log.log(Level.SEVERE, "Error trying to publish cascade. Check `flowServices` property");
                return status;
            }
            try {
                JSONObject payload = new JSONObject();
                payload.put("cascadeResourceId", (Object)cascadeResourceId.toString());
                payload.put("uploadUrl", (Object)uploadUrl);
                payload.put("version", (Object)String.valueOf(cr.getVersion() + 1));
                log.log(Level.INFO, "Sending cascade publish request for cascade: " + cascadeResourceId);
                String postString = payload.toString();
                log.log(Level.INFO, "POSTing to: " + flowServiceURL);
                String response = new String(HttpUtil.doPost(flowServiceURL + "/publish_cascade", postString, "application/json"), "UTF-8");
                log.log(Level.INFO, "Response from server: " + response);
                status = "publish requested";
                cr.setStatus(CascadeResource.Status.PUBLISHING);
                crDao.save(cr);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error publishing cascade: " + e.getMessage(), e);
            }
        }
        return status;
    }

    public static String notifyReportService(Collection<Long> surveyIds, String action) {
        String flowServiceURL = PropertyUtil.getProperty("flowServices");
        String baseURL = PropertyUtil.getProperty("alias");
        if (flowServiceURL == null || "".equals(flowServiceURL)) {
            log.log(Level.SEVERE, "Error trying to notify server. It's not configured, check `flowServices` property");
            return null;
        }
        try {
            JSONObject payload = new JSONObject();
            payload.put("surveyIds", surveyIds);
            payload.put("baseURL", (Object)(baseURL.startsWith("http") ? baseURL : "http://" + baseURL));
            log.log(Level.INFO, "Sending notification (" + action + ") for surveys: " + surveyIds);
            String postString = "criteria=" + URLEncoder.encode(payload.toString(), "UTF-8");
            log.log(Level.FINE, "POST URL: " + flowServiceURL + "  POST string: " + postString);
            String response = new String(HttpUtil.doPost(flowServiceURL + "/" + action, postString), "UTF-8");
            log.log(Level.INFO, "Response from server: " + response);
            return response;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error notifying the report service: " + e.getMessage(), e);
            return null;
        }
    }

    public static List<String> listParentPaths(String objectPath, boolean includeRootPath) {
        ArrayList<String> parentPaths = new ArrayList<String>();
        StringBuilder path = new StringBuilder(objectPath);
        while (path.length() > 1) {
            path.delete(path.lastIndexOf("/"), path.length());
            if (!StringUtils.isNotBlank((String)path.toString())) continue;
            parentPaths.add(path.toString().trim());
        }
        if (includeRootPath) {
            parentPaths.add("/");
        }
        return parentPaths;
    }

    public static void shallowCopy(BaseDomain source, BaseDomain copy) {
        BeanUtils.copyProperties((Object)source, (Object)copy, (String[])Constants.EXCLUDED_PROPERTIES);
        String kind = source.getKey().getKind();
        log.log(Level.INFO, "Copying `" + kind + "` " + source.getKey().getId());
    }

    public static void setChildObjects(SurveyGroup surveyGroup) {
        if (surveyGroup == null || surveyGroup.getKey() == null) {
            return;
        }
        Long surveyGroupId = surveyGroup.getKey().getId();
        List<SurveyGroup> childFolders = new SurveyGroupDAO().listByProjectFolderId(surveyGroupId);
        surveyGroup.setChildFolders(childFolders);
        List<Survey> childForms = new SurveyDAO().listSurveysByGroup(surveyGroupId);
        surveyGroup.setChildForms(childForms);
    }

    public static Set<String> listQuestionIdsUsedInSurveyGroup(Long surveyId) {
        SurveyDAO sDao = new SurveyDAO();
        QuestionDao qDao = new QuestionDao();
        HashSet<String> idsInUse = new HashSet<String>();
        Survey s0 = sDao.getById(surveyId);
        Long surveyGroupId = s0.getSurveyGroupId();
        List<Survey> sList = sDao.listSurveysByGroup(surveyGroupId);
        for (Survey s : sList) {
            List<Question> qList = qDao.listQuestionsBySurvey(s.getKey().getId());
            for (Question q : qList) {
                idsInUse.add(q.getVariableName());
            }
        }
        return idsInUse;
    }
}

