/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.framework.servlet;

import com.gallatinsystems.common.util.MD5Util;
import com.gallatinsystems.common.util.PropertyUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class RestAuthFilter
implements Filter {
    private static final long MAX_TIME = 600000L;
    private static final Logger log = Logger.getLogger(RestAuthFilter.class.getName());
    private static final String ENABLED_PROP = "enableRestSecurity";
    public static final String REST_PRIVATE_KEY_PROP = "restPrivateKey";
    private String privateKey;
    private boolean isEnabled = false;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        block5: {
            if (this.isEnabled) {
                try {
                    if (this.isAuthorized(req)) {
                        chain.doFilter(req, res);
                        break block5;
                    }
                    HttpServletResponse response = (HttpServletResponse)res;
                    response.sendError(401, "Authorization failed");
                }
                catch (Exception e) {
                    log.severe("Auth failure " + e.getMessage());
                    HttpServletResponse response = (HttpServletResponse)res;
                    response.sendError(401, "Authorization failed");
                }
            } else {
                chain.doFilter(req, res);
            }
        }
    }

    private boolean isAuthorized(ServletRequest req) throws Exception {
        return this.validateHashParam(req) && this.validateTimeStamp(req);
    }

    public boolean validateHashParam(ServletRequest req) throws UnsupportedEncodingException {
        if (req.getParameterMap() == null || req.getParameter("h") == null) {
            return false;
        }
        TreeMap sortedParamMap = new TreeMap();
        sortedParamMap.putAll(req.getParameterMap());
        StringBuilder builder = new StringBuilder();
        for (Object key : sortedParamMap.keySet()) {
            String paramKey = (String)key;
            if ("h".equals(paramKey)) continue;
            if (builder.length() > 0) {
                builder.append("&");
            }
            String[] vals = (String[])sortedParamMap.get(paramKey);
            int count = 0;
            for (String v : vals) {
                if (count > 0) {
                    builder.append("&");
                }
                builder.append(paramKey).append("=").append(URLEncoder.encode(v, "UTF-8"));
                ++count;
            }
        }
        String incomingHash = ((String[])sortedParamMap.get("h"))[0];
        incomingHash = incomingHash.replaceAll(" ", "+");
        String ourHash = MD5Util.generateHMAC(builder.toString(), this.privateKey);
        if (ourHash == null) {
            return false;
        }
        return ourHash.equals(incomingHash);
    }

    public boolean validateTimeStamp(ServletRequest req) {
        Map paramMap = req.getParameterMap();
        if (paramMap.isEmpty() || !paramMap.containsKey("ts")) {
            return false;
        }
        String timestamp = ((String[])paramMap.get("ts"))[0];
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            long incomingTimeStamp = df.parse(timestamp).getTime();
            return Math.abs(System.currentTimeMillis() - incomingTimeStamp) < 600000L;
        }
        catch (ParseException e) {
            log.warning("Recived rest api request with invalid timestamp");
            return false;
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String enabledFlag = null;
        enabledFlag = filterConfig.getInitParameter(ENABLED_PROP) != null ? filterConfig.getInitParameter(ENABLED_PROP) : PropertyUtil.getProperty(ENABLED_PROP);
        if (enabledFlag != null) {
            try {
                this.isEnabled = Boolean.parseBoolean(enabledFlag.trim());
            }
            catch (Exception e) {
                log.severe("Could not parse enableRestSecurity value of " + enabledFlag);
                this.isEnabled = false;
            }
        }
        this.privateKey = filterConfig.getInitParameter(REST_PRIVATE_KEY_PROP) != null ? filterConfig.getInitParameter(REST_PRIVATE_KEY_PROP) : PropertyUtil.getProperty(REST_PRIVATE_KEY_PROP);
    }

    public void destroy() {
    }
}

