/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.common.util;

import com.gallatinsystems.common.util.MD5Util;
import com.gallatinsystems.common.util.PropertyUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class S3Util {
    private static Logger log = Logger.getLogger(S3Util.class.getName());
    private static final long EXPIRE_DATE = 2145916800L;
    private static final String S3_URL = "https://%s.s3.amazonaws.com/%s";
    private static final String GET_PAYLOAD = "GET\n\n\n%s\n/%s/%s";
    private static final String BROWSER_GET_PAYLOAD = "GET\n\n\n2145916800\n/%s/%s";
    private static final String PUT_PAYLOAD_PUBLIC = "PUT\n%s\n%s\n%s\nx-amz-acl:public-read\n/%s/%s";
    private static final String PUT_PAYLOAD_PRIVATE = "PUT\n%s\n%s\n%s\n/%s/%s";
    private static final String PUT_PAYLOAD_ACL = "PUT\n\n\n%s\nx-amz-acl:%s\n/%s/%s?acl";
    private static final String GET_PAYLOAD_ACL = "GET\n\n\n%s\n/%s/%s?acl";

    public static URLConnection getConnection(String bucketName, String objectKey) throws IOException {
        return S3Util.getConnection(bucketName, objectKey, PropertyUtil.getProperty("aws_identifier"), PropertyUtil.getProperty("aws_secret_key"));
    }

    public static URLConnection getConnection(String bucketName, String objectKey, String awsAccessKeyId, String awsAccessSecret) throws IOException {
        String date = S3Util.getDate();
        String payload = String.format(GET_PAYLOAD, date, bucketName, objectKey);
        String signature = MD5Util.generateHMAC(payload, awsAccessSecret);
        URL url = new URL(String.format(S3_URL, bucketName, objectKey));
        URLConnection conn = url.openConnection();
        conn.setConnectTimeout(60000);
        conn.setReadTimeout(120000);
        conn.addRequestProperty("Cache-Control", "no-cache,max-age=0");
        conn.setRequestProperty("Date", date);
        conn.setRequestProperty("Authorization", "AWS " + awsAccessKeyId + ":" + signature);
        return conn;
    }

    public static boolean put(String bucketName, String objectKey, byte[] data, String contentType, boolean isPublic) throws IOException {
        String awsAccessId = PropertyUtil.getProperty("aws_identifier");
        String awsSecretKey = PropertyUtil.getProperty("aws_secret_key");
        return S3Util.put(bucketName, objectKey, data, contentType, isPublic, awsAccessId, awsSecretKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean put(String bucketName, String objectKey, byte[] data, String contentType, boolean isPublic, String awsAccessId, String awsSecretKey) throws IOException {
        boolean bl;
        BufferedOutputStream out;
        block10: {
            HttpURLConnection conn;
            block8: {
                boolean bl2;
                block9: {
                    String md5Hex;
                    block6: {
                        boolean bl3;
                        block7: {
                            byte[] md5Raw = MD5Util.md5(data);
                            String md5Base64 = Base64.getEncoder().encodeToString(md5Raw).trim();
                            md5Hex = MD5Util.toHex(md5Raw);
                            String date = S3Util.getDate();
                            String payloadStr = isPublic ? PUT_PAYLOAD_PUBLIC : PUT_PAYLOAD_PRIVATE;
                            String payload = String.format(payloadStr, md5Base64, contentType, date, bucketName, objectKey);
                            String signature = MD5Util.generateHMAC(payload, awsSecretKey);
                            URL url = new URL(String.format(S3_URL, bucketName, objectKey));
                            out = null;
                            conn = null;
                            try {
                                conn = (HttpURLConnection)url.openConnection();
                                conn.setDoOutput(true);
                                conn.setRequestMethod("PUT");
                                conn.setRequestProperty("Content-MD5", md5Base64);
                                conn.setRequestProperty("Content-Type", contentType);
                                conn.setRequestProperty("Date", date);
                                if (isPublic) {
                                    conn.setRequestProperty("x-amz-acl", "public-read");
                                }
                                conn.setRequestProperty("Authorization", "AWS " + awsAccessId + ":" + signature);
                                out = new BufferedOutputStream(conn.getOutputStream());
                                IOUtils.copy((InputStream)new ByteArrayInputStream(data), (OutputStream)out);
                                ((OutputStream)out).flush();
                                int status = conn.getResponseCode();
                                if (status == 200 || status == 201) break block6;
                                log.severe("Error uploading file: " + url.toString());
                                log.severe(IOUtils.toString((InputStream)conn.getInputStream()));
                                bl3 = false;
                                if (conn == null) break block7;
                                conn.disconnect();
                            }
                            catch (Throwable throwable) {
                                if (conn != null) {
                                    conn.disconnect();
                                }
                                IOUtils.closeQuietly(out);
                                throw throwable;
                            }
                        }
                        IOUtils.closeQuietly((OutputStream)out);
                        return bl3;
                    }
                    String etag = conn.getHeaderField("ETag");
                    String string = etag = etag != null ? etag.replaceAll("\"", "") : null;
                    if (md5Hex.equals(etag)) break block8;
                    log.severe("ETag comparison failed. Response ETag: " + etag + "Locally computed MD5: " + md5Hex);
                    bl2 = false;
                    if (conn == null) break block9;
                    conn.disconnect();
                }
                IOUtils.closeQuietly((OutputStream)out);
                return bl2;
            }
            bl = true;
            if (conn == null) break block10;
            conn.disconnect();
        }
        IOUtils.closeQuietly((OutputStream)out);
        return bl;
    }

    public static String getBrowserLink(String bucketName, String objectKey) {
        String awsAccessId = PropertyUtil.getProperty("aws_identifier");
        String awsSecretKey = PropertyUtil.getProperty("aws_secret_key");
        return S3Util.getBrowserLink(bucketName, objectKey, awsAccessId, awsSecretKey);
    }

    public static String getBrowserLink(String bucketName, String objectKey, String awsAccessId, String awsSecretKey) {
        String payload = String.format(BROWSER_GET_PAYLOAD, bucketName, objectKey);
        String signature = MD5Util.generateHMAC(payload, awsSecretKey);
        StringBuffer sb = new StringBuffer(String.format(S3_URL, bucketName, objectKey));
        sb.append("?AWSAccessKeyId=").append(awsAccessId);
        sb.append("&Expires=").append(2145916800L);
        try {
            sb.append("&Signature=").append(URLEncoder.encode(signature, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, "Error generating signature for browser URL: " + e.getMessage());
        }
        return sb.toString();
    }

    public static boolean putObjectAcl(String bucketName, String objectKey, ACL acl) throws IOException {
        String awsAccessId = PropertyUtil.getProperty("aws_identifier");
        String awsSecretKey = PropertyUtil.getProperty("aws_secret_key");
        return S3Util.putObjectAcl(bucketName, objectKey, acl, awsAccessId, awsSecretKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean putObjectAcl(String bucketName, String objectKey, ACL acl, String awsAccessId, String awsSecretKey) throws IOException {
        String date = S3Util.getDate();
        URL url = new URL(String.format(S3_URL, bucketName, objectKey) + "?acl");
        String payload = String.format(PUT_PAYLOAD_ACL, date, acl.toString(), bucketName, objectKey);
        String signature = MD5Util.generateHMAC(payload, awsSecretKey);
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("PUT");
            conn.setRequestProperty("Date", date);
            conn.setRequestProperty("x-amz-acl", acl.toString());
            conn.setRequestProperty("Authorization", "AWS " + awsAccessId + ":" + signature);
            int status = conn.getResponseCode();
            if (status != 200 && status != 201) {
                log.severe("Error setting ACL for: " + url.toString());
                log.severe(IOUtils.toString((InputStream)conn.getInputStream()));
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static String getObjectAcl(String bucketName, String objectKey) throws IOException {
        String awsAccessId = PropertyUtil.getProperty("aws_identifier");
        String awsSecretKey = PropertyUtil.getProperty("aws_secret_key");
        return S3Util.getObjectAcl(bucketName, objectKey, awsAccessId, awsSecretKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getObjectAcl(String bucketName, String objectKey, String awsAccessId, String awsSecretKey) throws IOException {
        String string;
        BufferedInputStream in;
        block6: {
            String date = S3Util.getDate();
            URL url = new URL(String.format(S3_URL, bucketName, objectKey) + "?acl");
            String payload = String.format(GET_PAYLOAD_ACL, date, bucketName, objectKey);
            String signature = MD5Util.generateHMAC(payload, awsSecretKey);
            in = null;
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("Date", date);
                conn.setRequestProperty("Authorization", "AWS " + awsAccessId + ":" + signature);
                in = new BufferedInputStream(conn.getInputStream());
                string = IOUtils.toString((InputStream)in);
                if (conn == null) break block6;
                conn.disconnect();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error getting ACL for : " + url.toString(), e);
                String string2 = null;
                return string2;
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
                IOUtils.closeQuietly(in);
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }

    private static String getDate() {
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ", Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(new Date()) + "GMT";
    }

    public static enum ACL {
        PRIVATE("private"),
        PUBLIC_READ("public-read");

        private String val;

        private ACL(String v) {
            this.val = v;
        }

        public String toString() {
            return this.val;
        }
    }
}

