/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest;

import com.google.appengine.api.datastore.KeyFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.akvo.flow.dao.DataPointAssignmentDao;
import org.akvo.flow.domain.persistent.DataPointAssignment;
import org.akvo.flow.rest.dto.DataPointAssignmentDto;
import org.akvo.flow.rest.dto.DataPointAssignmentPayload;
import org.springframework.beans.BeanUtils;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.web.rest.ResourceNotFoundException;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;

@Controller
@RequestMapping(value={"/data_point_assignments"})
public class DataPointAssignmentRestService {
    private DataPointAssignmentDao dataPointAssignmentDao = new DataPointAssignmentDao();

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, List<DataPointAssignmentDto>> listSomeOrAll(@RequestParam(value="surveyAssignmentId", required=false) Long surveyAssignmentId, @RequestParam(value="deviceId", required=false) Long deviceId) {
        HashMap<String, List<DataPointAssignmentDto>> response = new HashMap<String, List<DataPointAssignmentDto>>();
        ArrayList<DataPointAssignmentDto> results = new ArrayList<DataPointAssignmentDto>();
        if (deviceId != null && surveyAssignmentId != null) {
            for (DataPointAssignment dpa : this.dataPointAssignmentDao.listByDeviceAndSurveyAssignment(deviceId, surveyAssignmentId)) {
                results.add(this.marshallToDto(dpa));
            }
        } else if (surveyAssignmentId != null) {
            for (DataPointAssignment dpa : this.dataPointAssignmentDao.listBySurveyAssignment(surveyAssignmentId)) {
                results.add(this.marshallToDto(dpa));
            }
        } else if (deviceId != null) {
            for (DataPointAssignment dpa : this.dataPointAssignmentDao.listByDevice(deviceId)) {
                results.add(this.marshallToDto(dpa));
            }
        } else {
            for (DataPointAssignment dpa : this.dataPointAssignmentDao.list("all")) {
                results.add(this.marshallToDto(dpa));
            }
        }
        response.put("data_point_assignments", results);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, DataPointAssignmentDto> getById(@PathVariable(value="id") Long id) {
        HashMap<String, DataPointAssignmentDto> response = new HashMap<String, DataPointAssignmentDto>();
        DataPointAssignment dpa = (DataPointAssignment)this.dataPointAssignmentDao.getByKey(id);
        if (dpa == null) {
            throw new ResourceNotFoundException("Datapoint Assignment with id: " + id + " not found");
        }
        response.put("data_point_assignment", this.marshallToDto(dpa));
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteById(@PathVariable(value="id") Long id) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        DataPointAssignment dpa = (DataPointAssignment)this.dataPointAssignmentDao.getByKey(id);
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (dpa != null) {
            this.dataPointAssignmentDao.delete(dpa);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, DataPointAssignmentDto> updateDataPointAssignment(@PathVariable(value="id") Long id, @RequestBody DataPointAssignmentPayload payload) {
        DataPointAssignmentDto dto = payload.getData_point_assignment();
        if (!id.equals(dto.getKeyId())) {
            throw new HttpMessageNotReadableException("Ids don't match: " + id + " <> " + dto.getKeyId());
        }
        DataPointAssignment assignment = (DataPointAssignment)this.dataPointAssignmentDao.getByKey(dto.getKeyId());
        if (assignment == null) {
            throw new ResourceNotFoundException("DataPointAssignment with id: " + dto.getKeyId() + " not found");
        }
        DataPointAssignment dpa = this.marshallToDomain(dto);
        this.dataPointAssignmentDao.save(dpa);
        HashMap<String, DataPointAssignmentDto> response = new HashMap<String, DataPointAssignmentDto>();
        response.put("data_point_assignment", this.marshallToDto(dpa));
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> newDataPointAssignment(@RequestBody DataPointAssignmentPayload payload) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        statusDto.setMessage("missing required parameters");
        DataPointAssignment dpa = this.marshallToDomain(payload.getData_point_assignment());
        if (dpa.getDataPointIds().contains(null)) {
            throw new HttpMessageNotReadableException("dataPointIds contain nulls");
        }
        if (dpa != null && dpa.getDeviceId() != null && dpa.getSurveyId() != null && dpa.getSurveyAssignmentId() != null) {
            this.dataPointAssignmentDao.save(dpa);
            response.put("data_point_assignment", this.marshallToDto(dpa));
            statusDto.setStatus("ok");
            statusDto.setMessage("");
        }
        response.put("meta", statusDto);
        return response;
    }

    private DataPointAssignmentDto marshallToDto(DataPointAssignment dpa) {
        DataPointAssignmentDto dto = new DataPointAssignmentDto();
        BeanUtils.copyProperties((Object)dpa, (Object)dto);
        if (dpa.getKey() != null) {
            dto.setKeyId(dpa.getKey().getId());
        }
        return dto;
    }

    private DataPointAssignment marshallToDomain(DataPointAssignmentDto dto) {
        DataPointAssignment dpa = new DataPointAssignment();
        BeanUtils.copyProperties((Object)dto, (Object)dpa);
        if (dto.getKeyId() != null) {
            dpa.setKey(KeyFactory.createKey((String)"DataPointAssignment", (long)dto.getKeyId()));
        }
        return dpa;
    }
}

