/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.GpsDirectory;
import com.gallatinsystems.common.util.PropertyUtil;
import com.gallatinsystems.common.util.S3Util;
import com.gallatinsystems.device.dao.DeviceDAO;
import com.gallatinsystems.device.dao.DeviceFileJobQueueDAO;
import com.gallatinsystems.device.domain.Device;
import com.gallatinsystems.device.domain.DeviceFileJobQueue;
import com.gallatinsystems.device.domain.DeviceSurveyJobQueue;
import com.gallatinsystems.notification.helper.NotificationHelper;
import com.gallatinsystems.survey.dao.DeviceSurveyJobQueueDAO;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyTaskUtil;
import com.google.appengine.api.datastore.Key;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akvo.flow.dao.MessageDao;
import org.akvo.flow.dao.ReportDao;
import org.akvo.flow.dao.SurveyAssignmentDao;
import org.akvo.flow.domain.persistent.Report;
import org.waterforpeople.mapping.dao.QuestionAnswerStoreDao;
import org.waterforpeople.mapping.domain.QuestionAnswerStore;
import org.waterforpeople.mapping.domain.response.value.Location;
import org.waterforpeople.mapping.domain.response.value.Media;
import org.waterforpeople.mapping.serialization.response.MediaResponse;

public class CronCommanderServlet
extends HttpServlet {
    private static final int ONE_YEAR_AGO = -1;
    private static final int ONE_MONTH_AGO = -1;
    private static final int TWO_YEARS_AGO = -2;
    private static final long serialVersionUID = 2287175129835274533L;
    private static final Logger log = Logger.getLogger(CronCommanderServlet.class.getName());

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String action = req.getParameter("action");
        if (!"buildMap".equals(action)) {
            if ("purgeExpiredSurveys".equals(action)) {
                this.purgeExpiredSurveys();
            } else if ("purgeOrphanJobQueueRecords".equals(action)) {
                this.purgeOrphanJobQueueRecords();
            } else if ("generateNotifications".equals(action)) {
                this.generateNotifications();
            } else if ("purgeDeviceFileJobQueueRecords".equals(action)) {
                this.purgeDeviceFileJobQueueRecords();
            } else if ("purgeExpiredDevices".equals(action)) {
                this.purgeExpiredDevices();
            } else if ("extractImageFileGeotags".equals(action)) {
                this.extractImageFileGeotags();
            } else if ("purgeReportRecords".equals(action)) {
                this.purgeReportRecords();
            } else if ("purgeOldMessages".equals(action)) {
                this.purgeOldMessages();
            }
        }
    }

    private void purgeExpiredDevices() {
        Calendar deadline = Calendar.getInstance();
        deadline.add(1, -1);
        log.info("Starting scan for Devices not seen since: " + deadline.getTime());
        DeviceDAO deviceDao = new DeviceDAO();
        DeviceSurveyJobQueueDAO dsjqDao = new DeviceSurveyJobQueueDAO();
        DeviceFileJobQueueDAO dfjqDao = new DeviceFileJobQueueDAO();
        SurveyAssignmentDao saDao = new SurveyAssignmentDao();
        List<Device> deviceList = deviceDao.listAllWithBeaconBefore(deadline.getTime());
        log.info("Found " + deviceList.size() + " old Devices");
        for (Device d : deviceList) {
            List<DeviceFileJobQueue> dfql;
            long did = d.getKey().getId();
            List<DeviceSurveyJobQueue> djql = dsjqDao.get(d.getPhoneNumber(), d.getEsn(), d.getAndroidId());
            if (djql.size() > 0) {
                log.fine("Deleting " + djql.size() + " form assignments for device " + did);
                dsjqDao.delete(djql);
            }
            if ((dfql = dfjqDao.listByDeviceId(did)).size() > 0) {
                log.fine("Deleting " + dfql.size() + " file requests for device " + did);
                dfjqDao.delete(dfql);
            }
            int affected = saDao.removeDevice(did);
            log.fine("Removed device " + did + " from " + affected + " assignments.");
        }
        deviceDao.delete(deviceList);
    }

    private void purgeReportRecords() {
        Calendar deadline = Calendar.getInstance();
        deadline.add(1, -1);
        log.info("Starting scan for Report entries older than: " + deadline.getTime());
        ReportDao reportDao = new ReportDao();
        List<Report> reportList = reportDao.listAllCreatedBefore(deadline.getTime());
        log.fine("Deleting " + reportList.size() + " old Report entries");
        reportDao.delete(reportList);
    }

    private void purgeDeviceFileJobQueueRecords() {
        Calendar deadline = Calendar.getInstance();
        deadline.add(1, -1);
        log.info("Starting scan for DFJQ entries, fulfilled or older than: " + deadline.getTime());
        DeviceFileJobQueueDAO dfjqDao = new DeviceFileJobQueueDAO();
        List dfjqList = dfjqDao.list("all");
        int retirees = 0;
        for (DeviceFileJobQueue item : dfjqList) {
            if (item.getCreatedDateTime() != null && deadline.getTime().after(item.getCreatedDateTime())) {
                log.fine("Deleting old DFJQ entry: " + item.getKey().getId());
                SurveyTaskUtil.spawnDeleteTask("deleteDeviceFileJobQueue", item.getKey().getId());
                ++retirees;
                continue;
            }
            try {
                String bucket = PropertyUtil.getProperty("s3bucket");
                HttpURLConnection conn = (HttpURLConnection)S3Util.getConnection(bucket, "images/" + item.getFileName());
                log.fine("Checking for " + item.getFileName() + " : " + conn.getResponseCode() + " " + conn.getResponseMessage());
                if (conn.getResponseCode() != 200) continue;
                log.fine("Deleting fulfilled DFJQ entry: " + item.getKey().getId());
                SurveyTaskUtil.spawnDeleteTask("deleteDeviceFileJobQueue", item.getKey().getId());
                ++retirees;
            }
            catch (Exception e) {
                log.warning("Error while connecing to " + item.getFileName() + "\n" + e.getMessage());
            }
        }
        log.fine("Attempted to retire " + retirees + " of " + dfjqList.size());
    }

    private void generateNotifications() {
        NotificationHelper helper = new NotificationHelper("rawDataReport", null);
        helper.execute();
        NotificationHelper fieldReportHelper = new NotificationHelper("fieldStatusReport", null);
        fieldReportHelper.execute();
    }

    private void purgeExpiredSurveys() {
        DeviceSurveyJobQueueDAO dsjqDao = new DeviceSurveyJobQueueDAO();
        List<DeviceSurveyJobQueue> dsjqList = dsjqDao.listAssignmentsWithEarlierExpirationDate(new Date());
        for (DeviceSurveyJobQueue item : dsjqList) {
            SurveyTaskUtil.spawnDeleteTask("deleteDeviceSurveyJobQueue", item.getAssignmentId());
        }
    }

    private void purgeOrphanJobQueueRecords() {
        DeviceSurveyJobQueueDAO dsjqDao = new DeviceSurveyJobQueueDAO();
        SurveyDAO surveyDao = new SurveyDAO();
        List<Key> surveyIdList = surveyDao.listSurveyIds();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Key key : surveyIdList) {
            ids.add(key.getId());
        }
        for (DeviceSurveyJobQueue item : dsjqDao.listAllJobsInQueue()) {
            Long dsjqSurveyId = item.getSurveyID();
            boolean found = ids.contains(dsjqSurveyId);
            if (found) continue;
            log.info("found orphan assignmentId: " + item.getAssignmentId() + " id: " + item.getId() + " survey: " + item.getSurveyID() + " for deletion");
            SurveyTaskUtil.spawnDeleteTask("deleteDeviceSurveyJobQueue", item.getAssignmentId());
        }
    }

    private void extractImageFileGeotags() {
        List<QuestionAnswerStore> qaList;
        Calendar deadline = Calendar.getInstance();
        deadline.add(2, -1);
        log.info("Starting scan for image answers, newer than: " + deadline.getTime());
        QuestionAnswerStoreDao qaDao = new QuestionAnswerStoreDao();
        String cursor = "";
        int json = 0;
        int nonjson = 0;
        while ((qaList = qaDao.listByTypeAndDate("IMAGE", null, deadline.getTime(), cursor, 1000)) != null && qaList.size() != 0) {
            cursor = QuestionAnswerStoreDao.getCursor(qaList);
            for (QuestionAnswerStore item : qaList) {
                Media media;
                boolean forceSave = false;
                String v = item.getValue();
                log.fine(String.format(" Old IMAGE value '%s'", v));
                if (v != null && !v.trim().equals("")) {
                    if (v.startsWith("{")) {
                        ++json;
                        media = MediaResponse.parse(v);
                        if (media.getLocation() != null) continue;
                        if (v.matches("\"location\":null")) {
                            log.fine(String.format("Null location in IMAGE %d: '%s'", item.getKey().getId(), v));
                            continue;
                        }
                    } else {
                        ++nonjson;
                        forceSave = true;
                        v = Paths.get(v, new String[0]).getFileName().toString();
                        media = new Media();
                        media.setFilename(v);
                    }
                } else {
                    log.warning(String.format("null or empty value for IMAGE %d: '%s'", item.getKey().getId(), v));
                    continue;
                }
                Location loc = new Location();
                Boolean tagFound = this.fetchLocationFromJpegInS3(media.getFilename(), loc);
                if (tagFound == null && !forceSave) continue;
                if (tagFound == null) {
                    v = MediaResponse.formatWithoutGeotag(media);
                } else {
                    if (tagFound.equals(Boolean.FALSE)) {
                        loc = null;
                    }
                    media.setLocation(loc);
                    v = MediaResponse.formatWithGeotag(media);
                }
                log.fine(String.format("New IMAGE value '%s'", v));
                item.setValue(v);
                qaDao.save(item);
            }
        }
        log.fine("Found " + json + " JSON answers.");
        log.fine("Found " + nonjson + " Non-JSON answers.");
    }

    Boolean fetchLocationFromJpegInS3(String filename, Location loc) {
        InputStream s = this.fetchImageFileFromS3(filename);
        if (s != null) {
            try {
                Metadata metadata = JpegMetadataReader.readMetadata((InputStream)s);
                log.fine("Using JpegMetadataReader");
                Directory directory = metadata.getFirstDirectoryOfType(GpsDirectory.class);
                if (directory == null) {
                    return false;
                }
                Rational[] latTag = directory.getRationalArray(2);
                String latRefTag = directory.getString(1);
                Rational[] lonTag = directory.getRationalArray(4);
                String lonRefTag = directory.getString(3);
                Rational[] altTag = directory.getRationalArray(6);
                Integer altRefTag = directory.getInteger(5);
                Rational[] accTag = directory.getRationalArray(31);
                if (latTag == null || lonTag == null) {
                    return false;
                }
                Double lat = latTag[0].doubleValue() + latTag[1].doubleValue() / 60.0 + latTag[2].doubleValue() / 3600.0;
                if (latRefTag != null && latRefTag.contentEquals("S")) {
                    lat = -lat.doubleValue();
                }
                Double lon = lonTag[0].doubleValue() + lonTag[1].doubleValue() / 60.0 + lonTag[2].doubleValue() / 3600.0;
                if (lonRefTag != null && lonRefTag.contentEquals("W")) {
                    lon = -lon.doubleValue();
                }
                if (lat == 0.0 || lon == 0.0) {
                    return false;
                }
                Double alt = altTag != null ? Double.valueOf(altTag[0].doubleValue()) : Double.valueOf(0.0);
                if (altRefTag != null && altRefTag.equals(1)) {
                    alt = -alt.doubleValue();
                }
                Float acc = accTag != null ? Float.valueOf(accTag[0].floatValue()) : Float.valueOf(0.0f);
                loc.setLatitude(lat);
                loc.setLongitude(lon);
                loc.setAltitude(alt);
                loc.setAccuracy(acc.floatValue());
                log.fine(String.format(" Extracted location N %f, E %f, up %f, acc %f\n", lat, lon, alt, acc));
                return true;
            }
            catch (JpegProcessingException e) {
                log.warning("Could not process JPEG file: " + e.getMessage());
            }
            catch (IOException e) {
                log.warning("Could not read image file: " + e.getMessage());
            }
        }
        return null;
    }

    InputStream fetchImageFileFromS3(String filename) {
        URLConnection conn = null;
        String s3bucket = PropertyUtil.getProperty("s3bucket");
        filename = Paths.get(filename, new String[0]).getFileName().toString();
        log.fine("Fetching " + filename);
        try {
            conn = S3Util.getConnection(s3bucket, "images/" + filename);
            return new BufferedInputStream(conn.getInputStream());
        }
        catch (Exception e) {
            log.warning("Could not fetch image file: " + e.getMessage());
            return null;
        }
    }

    private void purgeOldMessages() {
        Calendar deadline = Calendar.getInstance();
        deadline.add(1, -1);
        log.info("Starting scan for Message entries older than: " + deadline.getTime());
        MessageDao messageDao = new MessageDao();
        List<Key> purgable = messageDao.listKeysCreatedBefore(deadline.getTime());
        log.fine("Deleting " + purgable.size() + " old Message entries");
        messageDao.deleteByKeys(purgable);
    }
}

