/*
 * Decompiled with CFR 0.152.
 */
package com.gallatinsystems.survey.dao;

import com.gallatinsystems.framework.dao.BaseDAO;
import com.gallatinsystems.framework.exceptions.IllegalDeletionException;
import com.gallatinsystems.framework.servlet.PersistenceFilter;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.TranslationDao;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.Translation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

public class QuestionGroupDao
extends BaseDAO<QuestionGroup> {
    private final TranslationDao translationDao = new TranslationDao();

    public QuestionGroupDao() {
        super(QuestionGroup.class);
    }

    public void saveGroupTranslations(QuestionGroup item) {
        Map<String, Translation> translations = item.getTranslations();
        if (translations != null) {
            for (Translation t : translations.values()) {
                t.setParentId(item.getKey().getId());
                t.setSurveyId(item.getSurveyId());
                t.setQuestionGroupId(item.getKey().getId());
            }
            super.save(translations.values());
        }
    }

    public QuestionGroup save(QuestionGroup item, Long surveyId) {
        if (item.getSurveyId() == null || item.getSurveyId() == 0L) {
            item.setSurveyId(surveyId);
        }
        item = this.save(item);
        return item;
    }

    public void deleteGroupsForSurvey(Long surveyId) throws IllegalDeletionException {
        for (QuestionGroup group : this.listQuestionGroupBySurvey(surveyId)) {
            this.delete(group);
        }
    }

    public List<QuestionGroup> listQuestionGroupsByName(String code) {
        return this.listByProperty("name", code, "String");
    }

    public TreeMap<Integer, QuestionGroup> listQuestionGroupsBySurvey(Long surveyId) {
        List groups = this.listByProperty("surveyId", surveyId, "Long");
        TreeMap<Integer, QuestionGroup> map = new TreeMap<Integer, QuestionGroup>();
        if (groups != null) {
            int i = 1;
            for (QuestionGroup group : groups) {
                List<Translation> translations = this.translationDao.findTranslations(group.getKey().getId(), Translation.ParentType.QUESTION_GROUP_NAME);
                HashMap<String, Translation> translationMap = new HashMap<String, Translation>();
                if (translations != null) {
                    for (Translation t : translations) {
                        translationMap.put(t.getLanguageCode(), t);
                    }
                }
                group.setTranslations(translationMap);
                if (map.containsKey(group.getOrder())) {
                    map.put(i, group);
                    group.setOrder(i);
                } else {
                    map.put(group.getOrder() != null ? group.getOrder() : i, group);
                }
                ++i;
            }
        }
        return map;
    }

    public List<QuestionGroup> listQuestionGroupBySurvey(Long surveyId) {
        return super.listByProperty("surveyId", (Object)surveyId, "Long", "order", "asc");
    }

    public QuestionGroup getByParentIdandCode(String code, Long surveyId) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(QuestionGroup.class);
        query.setFilter(" code==codeParam && surveyId == surveyIdParam");
        query.declareParameters("String codeParam, Long surveyIdParam");
        List results = (List)query.execute((Object)code, (Object)surveyId);
        if (results != null && results.size() > 0) {
            return (QuestionGroup)results.get(0);
        }
        return null;
    }

    public QuestionGroup getByPath(String code, String path) {
        PersistenceManager pm = PersistenceFilter.getManager();
        Query query = pm.newQuery(QuestionGroup.class);
        query.setFilter(" path == pathParam && code == codeParam");
        query.declareParameters("String pathParam, String codeParam");
        List results = (List)query.execute((Object)path, (Object)code);
        if (results != null && results.size() > 0) {
            return (QuestionGroup)results.get(0);
        }
        return null;
    }

    @Override
    public void delete(QuestionGroup group) throws IllegalDeletionException {
        QuestionDao qDao = new QuestionDao();
        qDao.deleteQuestionsForGroup(group.getKey().getId());
        super.delete(group);
    }
}

