/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.dataexport;

import com.gallatinsystems.framework.domain.BaseDomain;
import com.gallatinsystems.framework.gwt.dto.client.BaseDto;
import com.gallatinsystems.survey.dao.QuestionDao;
import com.gallatinsystems.survey.dao.QuestionGroupDao;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.domain.Question;
import com.gallatinsystems.survey.domain.QuestionGroup;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.survey.domain.Translation;
import com.google.appengine.api.datastore.KeyFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionGroupDto;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyDto;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyGroupDto;
import org.waterforpeople.mapping.app.gwt.client.survey.TranslationDto;
import org.waterforpeople.mapping.app.gwt.server.survey.SurveyServiceImpl;
import org.waterforpeople.mapping.app.util.DtoMarshaller;
import org.waterforpeople.mapping.dataexport.service.BulkDataServiceClient;

public class SurveyReplicationImporter {
    private static final Logger log = Logger.getLogger(SurveyReplicationImporter.class.getName());

    public void importOneGroup(String sourceBase, long surveyId, String apiKey) {
        SurveyGroupDAO sgDao = new SurveyGroupDAO();
        SurveyDAO sDao = new SurveyDAO();
        QuestionGroupDao qgDao = new QuestionGroupDao();
        QuestionDao qDao = new QuestionDao();
        System.out.println("Importing survey " + surveyId + " with id remapping from " + sourceBase);
        int count_sg = 0;
        int count_s = 0;
        int count_qg = 0;
        int count_q = 0;
        try {
            List<SurveyGroup> allGroups = this.fetchSurveyGroups(sourceBase, apiKey);
            System.out.println(" scanning " + allGroups.size() + " survey groups");
            for (SurveyGroup sg : allGroups) {
                System.out.println(" surveygroup: " + sg.getKey().getId() + " " + sg.getName() + ":" + sg.getCode());
                ++count_sg;
                if (sg.getProjectType() != SurveyGroup.ProjectType.PROJECT) continue;
                boolean thisIsTheGroup = false;
                List<Survey> allSurveys = this.fetchSurveys(sg.getKey().getId(), sourceBase, apiKey);
                for (Survey s0 : allSurveys) {
                    if (s0.getKey().getId() != surveyId) continue;
                    thisIsTheGroup = true;
                    break;
                }
                if (!thisIsTheGroup) continue;
                System.out.println(" copying group with " + allSurveys.size() + " surveys");
                sg.setParentId(0L);
                sg.setPath("");
                ArrayList<Long> nai = new ArrayList<Long>(1);
                nai.add(0L);
                sg.setAncestorIds(nai);
                sg.getKey().getId();
                sg.setKey(null);
                sgDao.save(sg);
                long newId = sg.getKey().getId();
                for (Survey s : allSurveys) {
                    int numberOfTranslations = s.getTranslationMap() == null ? 0 : s.getTranslationMap().size();
                    System.out.println("  survey:" + s.getKey().getId() + " " + s.getCode() + " with " + numberOfTranslations + " translations");
                    long oldSurveyId = s.getKey().getId();
                    s.setKey(null);
                    ArrayList<Long> nai2 = new ArrayList<Long>(2);
                    nai2.add(0L);
                    nai2.add(newId);
                    s.setAncestorIds(nai2);
                    s.setSurveyGroupId(newId);
                    s.setPath("");
                    s.setStatus(Survey.Status.NOT_PUBLISHED);
                    s.setVersion(1.0);
                    sDao.save(s);
                    long newSurveyId = s.getKey().getId();
                    sDao.saveTranslations(s);
                    if (sg.getNewLocaleSurveyId() != null && sg.getNewLocaleSurveyId() == oldSurveyId) {
                        System.out.println("   registration form id fixup :" + oldSurveyId + " -> " + newSurveyId);
                        sg.setNewLocaleSurveyId(newSurveyId);
                        sgDao.save(sg);
                    }
                    ++count_s;
                    HashMap<Long, Long> qMap = new HashMap<Long, Long>();
                    List<QuestionGroup> allQgs = this.fetchQuestionGroups(oldSurveyId, sourceBase, apiKey);
                    for (QuestionGroup qg : allQgs) {
                        int numberOfTranslationsGr = qg.getTranslations() == null ? 0 : qg.getTranslations().size();
                        System.out.println("     qg:" + qg.getKey().getId() + " " + qg.getCode() + "with " + numberOfTranslationsGr + " translations");
                        long oldQgId = qg.getKey().getId();
                        qg.setKey(null);
                        qg.setSurveyId(newSurveyId);
                        qg.setPath("");
                        qgDao.save(qg);
                        long newQgId = qg.getKey().getId();
                        qgDao.saveGroupTranslations(qg);
                        for (Question q : this.fetchQuestions(oldQgId, sourceBase, apiKey)) {
                            System.out.println("       q:" + q.getKey().getId() + " " + q.getText());
                            q.setPath("");
                            long oldQId = q.getKey().getId();
                            q.setKey(null);
                            qDao.save(q, newQgId);
                            long newQId = q.getKey().getId();
                            qMap.put(oldQId, newQId);
                            ++count_q;
                        }
                        ++count_qg;
                    }
                    System.out.println("     q depependency fixup pass");
                    Iterator<QuestionGroup> iterator = qMap.values().iterator();
                    while (iterator.hasNext()) {
                        Long updatedId;
                        long qid = (Long)((Object)iterator.next());
                        Question q = qDao.getByKey(qid);
                        if (q == null) {
                            System.out.println("     q not found:" + qid);
                            continue;
                        }
                        if (!q.getDependentFlag().booleanValue() || q.getDependentQuestionId() == null || (updatedId = (Long)qMap.get(q.getDependentQuestionId())) == null) continue;
                        System.out.println("       q:" + q.getText());
                        System.out.println("        dep fixup :" + q.getDependentQuestionId() + " -> " + updatedId);
                        q.setDependentQuestionId(updatedId);
                        qDao.save(q, q.getQuestionGroupId());
                    }
                }
            }
            System.out.println("Survey import complete after " + count_sg + " groups scanned; " + count_s + " surveys, " + count_qg + " question groups, " + count_q + " questions copied. ");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.log(Level.SEVERE, "Error copying survey", e);
        }
    }

    public void executeImport(String sourceBase, Long surveyId, String apiKey) {
        if (surveyId != null) {
            this.importOneGroup(sourceBase, surveyId, apiKey);
            return;
        }
        SurveyGroupDAO sgDao = new SurveyGroupDAO();
        SurveyDAO sDao = new SurveyDAO();
        QuestionGroupDao qgDao = new QuestionGroupDao();
        QuestionDao qDao = new QuestionDao();
        boolean hasFoundSurvey = false;
        try {
            List<SurveyGroup> allGroups = this.fetchSurveyGroups(sourceBase, apiKey);
            for (SurveyGroup sg : allGroups) {
                System.out.println("surveygroup: " + sg.getName() + ":" + sg.getCode());
                if (surveyId == null) {
                    sgDao.save(sg);
                }
                for (Survey s : this.fetchSurveys(sg.getKey().getId(), sourceBase, apiKey)) {
                    System.out.println("  survey:" + s.getCode());
                    if (surveyId != null && surveyId.equals(s.getKey().getId())) {
                        for (Long ancestor : s.listAncestorIds()) {
                            if (ancestor == 0L || ancestor.longValue() == sg.getKey().getId()) continue;
                            for (SurveyGroup potentialAncestor : allGroups) {
                                if (potentialAncestor.getKey().getId() != ancestor.longValue()) continue;
                                sgDao.save(potentialAncestor);
                            }
                        }
                        sgDao.save(sg);
                        sDao.save(s);
                        hasFoundSurvey = true;
                    } else {
                        if (surveyId != null) continue;
                        sDao.save(s);
                    }
                    for (QuestionGroup qg : this.fetchQuestionGroups(s.getKey().getId(), sourceBase, apiKey)) {
                        System.out.println("     qg:" + qg.getCode());
                        qgDao.save(qg);
                        for (Question q : this.fetchQuestions(qg.getKey().getId(), sourceBase, apiKey)) {
                            System.out.println("       q" + q.getText());
                            qDao.save(q, qg.getKey().getId());
                        }
                    }
                    if (!hasFoundSurvey) continue;
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<SurveyGroup> fetchSurveyGroups(String serverBase, String apiKey) throws Exception {
        List<SurveyGroupDto> sgDtoList = BulkDataServiceClient.fetchSurveyGroups(serverBase, apiKey);
        ArrayList sgList = new ArrayList();
        return SurveyReplicationImporter.copyAndCreateList(sgList, sgDtoList, SurveyGroup.class);
    }

    public List<Survey> fetchSurveys(Long surveyGroupId, String serverBase, String apiKey) throws Exception {
        List<SurveyDto> surveyDtoList = BulkDataServiceClient.fetchSurveys(surveyGroupId, serverBase, apiKey);
        ArrayList surveyList = new ArrayList();
        return SurveyReplicationImporter.copyAndCreateList(surveyList, surveyDtoList, Survey.class);
    }

    public List<QuestionGroup> fetchQuestionGroups(Long surveyId, String serverBase, String apiKey) throws Exception {
        List<QuestionGroupDto> qgDtoList = BulkDataServiceClient.fetchQuestionGroups(serverBase, surveyId.toString(), apiKey);
        return this.copyAndCreateGroupList(qgDtoList);
    }

    private List<QuestionGroup> copyAndCreateGroupList(List<QuestionGroupDto> qgDtoList) {
        ArrayList<QuestionGroup> groups = new ArrayList<QuestionGroup>();
        if (qgDtoList != null) {
            for (QuestionGroupDto dto : qgDtoList) {
                QuestionGroup group = new QuestionGroup();
                DtoMarshaller.copyToCanonical(group, dto);
                Map<String, TranslationDto> translationMap = dto.getTranslationMap();
                if (translationMap == null) continue;
                HashMap<String, Translation> mappedTranslations = SurveyReplicationImporter.mapTranslations(translationMap);
                group.setTranslations(mappedTranslations);
            }
        }
        return groups;
    }

    private static HashMap<String, Translation> mapTranslations(Map<String, TranslationDto> translationMap) {
        HashMap<String, Translation> translationHashMap = new HashMap<String, Translation>();
        try {
            for (TranslationDto dto : translationMap.values()) {
                Translation t = new Translation();
                t.setKey(KeyFactory.createKey((String)Translation.class.getSimpleName(), (long)dto.getKeyId()));
                t.setLanguageCode(dto.getLangCode());
                t.setText(dto.getText());
                t.setParentId(dto.getParentId());
                if (Translation.ParentType.SURVEY_NAME.toString().equals(dto.getParentType())) {
                    t.setParentType(Translation.ParentType.SURVEY_NAME);
                } else if (Translation.ParentType.SURVEY_DESC.toString().equals(dto.getParentType())) {
                    t.setParentType(Translation.ParentType.SURVEY_DESC);
                } else if (Translation.ParentType.QUESTION_GROUP_DESC.toString().equals(dto.getParentType())) {
                    t.setParentType(Translation.ParentType.QUESTION_GROUP_DESC);
                } else if (Translation.ParentType.QUESTION_GROUP_NAME.toString().equals(dto.getParentType())) {
                    t.setParentType(Translation.ParentType.QUESTION_GROUP_NAME);
                }
                translationHashMap.put(dto.getLangCode(), t);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error mapping translations", e);
        }
        return translationHashMap;
    }

    public List<Question> fetchQuestions(Long questionGroupId, String serverBase, String apiKey) throws Exception {
        List<QuestionDto> qgDtoList = BulkDataServiceClient.fetchQuestions(serverBase, questionGroupId, apiKey);
        ArrayList<Question> qList = new ArrayList<Question>();
        SurveyServiceImpl ssi = new SurveyServiceImpl();
        for (QuestionDto dto : qgDtoList) {
            QuestionDto dtoDetail = null;
            for (int i = 0; i < 3; ++i) {
                try {
                    dtoDetail = BulkDataServiceClient.loadQuestionDetails(serverBase, dto.getKeyId(), apiKey);
                    break;
                }
                catch (IOException iex) {
                    System.out.print("Retrying because of timeout.");
                    log.log(Level.SEVERE, "Error fetchQuestions", iex);
                    continue;
                }
            }
            Question q = ssi.marshalQuestion(dtoDetail);
            qList.add(q);
        }
        return qList;
    }

    public static <T extends BaseDomain, U extends BaseDto> List<T> copyAndCreateList(List<T> canonicalList, List<U> dtoList, Class<T> clazz) {
        for (BaseDto dto : dtoList) {
            BaseDomain canonical = null;
            try {
                canonical = (BaseDomain)clazz.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                log.log(Level.SEVERE, "Error copyAndCreateList", e);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                log.log(Level.SEVERE, "Error copyAndCreateList", e);
            }
            DtoMarshaller.copyToCanonical(canonical, dto);
            if (canonical instanceof Survey && dto instanceof SurveyDto) {
                Survey s = (Survey)canonical;
                SurveyDto d = (SurveyDto)dto;
                if (Survey.Status.PUBLISHED.equals((Object)s.getStatus())) {
                    s.setStatus(Survey.Status.NOT_PUBLISHED);
                }
                s.setDesc(d.getDescription());
                if (d.getTranslationMap() != null) {
                    s.setTranslationMap(SurveyReplicationImporter.mapTranslations(d.getTranslationMap()));
                }
            }
            canonicalList.add(canonical);
        }
        return canonicalList;
    }
}

