/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.dao.SurveyGroupDAO;
import com.gallatinsystems.survey.dao.SurveyUtils;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.survey.domain.SurveyGroup;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.akvo.flow.rest.handler.FormInstanceRequestHandler;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.gwt.client.surveyinstance.SurveyInstanceDto;
import org.waterforpeople.mapping.app.util.DtoMarshaller;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;
import org.waterforpeople.mapping.app.web.rest.dto.SurveyInstancePayload;
import org.waterforpeople.mapping.dao.SurveyInstanceDAO;
import org.waterforpeople.mapping.domain.SurveyInstance;

@Controller
@RequestMapping(value={"/survey_instances"})
public class SurveyInstanceRestService {
    private static final Logger log = Logger.getLogger(SurveyInstanceRestService.class.getName());
    private SurveyInstanceDAO surveyInstanceDao = new SurveyInstanceDAO();
    private SurveyDAO surveyDao = new SurveyDAO();
    private SurveyGroupDAO surveyGroupDao = new SurveyGroupDAO();
    private SurveyedLocaleDao surveyedLocaleDao = new SurveyedLocaleDao();

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, Object> listSurveyInstances(@RequestParam(value="beginDate", defaultValue="") Long bDate, @RequestParam(value="endDate", defaultValue="") Long eDate, @RequestParam(value="surveyId", required=false) Long surveyId, @RequestParam(value="since", defaultValue="") String since, @RequestParam(value="unapprovedOnlyFlag", defaultValue="") Boolean unapprovedOnlyFlag, @RequestParam(value="surveyInstanceId", defaultValue="") Long surveyInstanceId, @RequestParam(value="deviceId", defaultValue="") String deviceId, @RequestParam(value="submitterName", defaultValue="") String submitterName, @RequestParam(value="countryCode", defaultValue="") String countryCode, @RequestParam(value="level1", defaultValue="") String level1, @RequestParam(value="level2", defaultValue="") String level2, @RequestParam(value="surveyedLocaleId", defaultValue="") Long surveyedLocaleId) {
        if ("".equals(deviceId)) {
            deviceId = null;
        }
        if ("".equals(submitterName)) {
            submitterName = null;
        }
        if ("".equals(countryCode)) {
            countryCode = null;
        }
        if ("".equals(level1)) {
            level1 = null;
        }
        if ("".equals(level2)) {
            level2 = null;
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        RestStatusDto statusDto = new RestStatusDto();
        if (surveyId == null && surveyedLocaleId == null) {
            response.put("survey_instances", Collections.emptyList());
            return response;
        }
        if (surveyInstanceId != null) {
            SurveyInstance surveyInstance = (SurveyInstance)this.surveyInstanceDao.getByKey(surveyInstanceId);
            ArrayList<SurveyInstanceDto> dtoList = new ArrayList<SurveyInstanceDto>();
            if (surveyInstance != null && surveyInstance.getSurveyId().equals(surveyId)) {
                SurveyInstanceDto dto = new SurveyInstanceDto();
                DtoMarshaller.copyToDto(surveyInstance, dto);
                dtoList.add(dto);
            }
            response.put("survey_instances", dtoList);
            return response;
        }
        Date beginDate = null;
        Date endDate = null;
        if (bDate != null) {
            beginDate = new Date(bDate);
        }
        if (eDate != null) {
            endDate = new Date(eDate);
        }
        if (beginDate == null && endDate == null) {
            beginDate = new Date(0L);
        }
        List<SurveyInstance> siList = null;
        if (surveyId != null) {
            List<Survey> authorizedSurveys = this.surveyDao.listAllFilteredByUserAuthorization();
            HashSet<Long> authorizedSurveyIds = new HashSet<Long>();
            for (Survey survey : authorizedSurveys) {
                authorizedSurveyIds.add(survey.getKey().getId());
            }
            if (!authorizedSurveyIds.contains(surveyId)) {
                response.put("survey_instances", Collections.emptyList());
                return response;
            }
            siList = this.surveyInstanceDao.listByDateRangeAndSubmitter(beginDate, endDate, false, surveyId, deviceId, submitterName, countryCode, level1, level2, since);
        } else if (surveyedLocaleId != null) {
            SurveyedLocale sl = (SurveyedLocale)this.surveyedLocaleDao.getByKey(surveyedLocaleId);
            if (sl.getSurveyGroupId() == null) {
                log.warning("No surveyGroupId found for surveyedLocale=" + sl.getKey());
                response.put("survey_instances", Collections.emptyList());
                return response;
            }
            List<SurveyGroup> authorizedSurveyGroups = this.surveyGroupDao.listAllFilteredByUserAuthorization();
            HashSet<Long> authorizedSurveyGroupIds = new HashSet<Long>();
            for (SurveyGroup sg : authorizedSurveyGroups) {
                authorizedSurveyGroupIds.add(sg.getKey().getId());
            }
            siList = authorizedSurveyGroupIds.contains(sl.getSurveyGroupId()) ? this.surveyInstanceDao.listInstancesByLocale(surveyedLocaleId, null, null, null) : Collections.emptyList();
        }
        Integer num = siList.size();
        String newSince = SurveyInstanceDAO.getCursor(siList);
        String surveyCode = null;
        if (siList.size() > 0) {
            Survey survey = (Survey)this.surveyDao.getByKey(((SurveyInstance)siList.get(0)).getSurveyId());
            surveyCode = survey.getPath();
        } else {
            surveyCode = "";
        }
        ArrayList<SurveyInstanceDto> arrayList = new ArrayList<SurveyInstanceDto>();
        for (SurveyInstance siItem : siList) {
            SurveyInstanceDto dto = new SurveyInstanceDto();
            DtoMarshaller.copyToDto(siItem, dto);
            dto.setSurveyCode(surveyCode);
            arrayList.add(dto);
        }
        statusDto.setSince(newSince);
        statusDto.setNum(num);
        response.put("meta", statusDto);
        response.put("survey_instances", arrayList);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, SurveyInstanceDto> findSurveyInstanceById(@PathVariable(value="id") Long id) {
        HashMap<String, SurveyInstanceDto> response = new HashMap<String, SurveyInstanceDto>();
        SurveyInstance s = (SurveyInstance)this.surveyInstanceDao.getByKey(id);
        SurveyInstanceDto dto = null;
        if (s != null) {
            dto = new SurveyInstanceDto();
            DtoMarshaller.copyToDto(s, dto);
        }
        response.put("survey_instance", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteSurveyInstanceById(@PathVariable(value="id") Long id) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        response.put("meta", statusDto);
        SurveyInstance si = (SurveyInstance)this.surveyInstanceDao.getByKey(id);
        if (si == null) {
            return response;
        }
        Long surveyId = si.getSurveyId();
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(surveyId);
        FormInstanceRequestHandler requestHandler = new FormInstanceRequestHandler();
        requestHandler.deleteFormInstance(si);
        TaskOptions to = TaskOptions.Builder.withUrl((String)"/app_worker/dataprocessor").param("action", "deleteSurveyInstanceResponses").param("surveyInstanceId", Long.toString(id));
        QueueFactory.getQueue((String)"deletequeue").add(to);
        statusDto.setStatus("ok");
        SurveyUtils.notifyReportService(ids, "invalidate");
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> saveExistingSurveyInstance(@RequestBody SurveyInstancePayload payLoad) {
        SurveyInstance s;
        Long keyId;
        SurveyInstanceDto surveyInstanceDto = payLoad.getSurvey_instance();
        HashMap<String, Object> response = new HashMap<String, Object>();
        SurveyInstanceDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (surveyInstanceDto != null && (keyId = surveyInstanceDto.getKeyId()) != null && (s = (SurveyInstance)this.surveyInstanceDao.getByKey(keyId)) != null) {
            BeanUtils.copyProperties((Object)surveyInstanceDto, (Object)s, (String[])new String[]{"createdDateTime", "lastUpdateDateTime", "displayName", "questionInstanceList"});
            s = this.surveyInstanceDao.save(s);
            dto = new SurveyInstanceDto();
            DtoMarshaller.copyToDto(s, dto);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("survey_instance", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> saveNewSurveyInstance(@RequestBody SurveyInstancePayload payLoad) {
        SurveyInstanceDto surveyInstanceDto = payLoad.getSurvey_instance();
        HashMap<String, Object> response = new HashMap<String, Object>();
        SurveyInstanceDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (surveyInstanceDto != null) {
            SurveyInstance s = new SurveyInstance();
            BeanUtils.copyProperties((Object)surveyInstanceDto, (Object)s, (String[])new String[]{"createdDateTime", "lastUpdateDateTime", "displayName", "questionInstanceList"});
            s = this.surveyInstanceDao.save(s);
            dto = new SurveyInstanceDto();
            DtoMarshaller.copyToDto(s, dto);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("survey_instance", dto);
        return response;
    }
}

