/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest.security.google;

import com.gallatinsystems.user.dao.UserDao;
import com.google.appengine.api.users.User;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.akvo.flow.rest.security.AppRole;
import org.akvo.flow.rest.security.GaeUserAuthentication;
import org.akvo.flow.rest.security.user.GaeUser;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class GoogleAccountsAuthenticationProvider
implements AuthenticationProvider,
MessageSourceAware {
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private static final Logger log = Logger.getLogger(GoogleAccountsAuthenticationProvider.class.getName());
    private UserDao userDao = new UserDao();

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        User googleUser = (User)authentication.getPrincipal();
        return GoogleAccountsAuthenticationProvider.getAuthentication(true, this.userDao, authentication, googleUser.getEmail(), googleUser.getNickname());
    }

    public static Authentication getAuthentication(boolean authByGAE, UserDao userDao, Authentication authentication, String email, String nickname) {
        GaeUser user = GoogleAccountsAuthenticationProvider.findUser(userDao, email, authByGAE);
        if (user == null) {
            user = new GaeUser(authByGAE, nickname, email);
        }
        if (!user.isEnabled()) {
            throw new DisabledException("Account is disabled");
        }
        return new GaeUserAuthentication(user, authentication.getDetails());
    }

    private static GaeUser findUser(UserDao userDao, String email, boolean authByGAE) {
        com.gallatinsystems.user.domain.User user = userDao.findUserByEmail(email);
        if (user == null) {
            return null;
        }
        int authority = GoogleAccountsAuthenticationProvider.getAuthorityLevel(user);
        EnumSet<AppRole> roles = EnumSet.noneOf(AppRole.class);
        if (authority == AppRole.ROLE_NEW_USER.getLevel()) {
            roles.add(AppRole.ROLE_NEW_USER);
        } else {
            for (AppRole r : AppRole.values()) {
                if (authority > r.getLevel()) continue;
                roles.add(r);
            }
        }
        return new GaeUser(user.getUserName(), user.getEmailAddress(), user.getKey().getId(), roles, true, authByGAE);
    }

    private static int getAuthorityLevel(com.gallatinsystems.user.domain.User user) {
        if (user.isSuperAdmin().booleanValue()) {
            return AppRole.ROLE_SUPER_ADMIN.getLevel();
        }
        try {
            int level = Integer.parseInt(user.getPermissionList());
            return level;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error getting role level, setting ROLE_USER role", e);
            return AppRole.ROLE_USER.getLevel();
        }
    }

    public final boolean supports(Class<?> authentication) {
        return PreAuthenticatedAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }
}

