/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.api.app;

import com.gallatinsystems.device.domain.DeviceSurveyJobQueue;
import com.gallatinsystems.framework.rest.AbstractRestApiServlet;
import com.gallatinsystems.framework.rest.RestRequest;
import com.gallatinsystems.framework.rest.RestResponse;
import com.gallatinsystems.survey.dao.DeviceSurveyJobQueueDAO;
import com.gallatinsystems.survey.dao.SurveyDAO;
import com.gallatinsystems.survey.domain.Survey;
import com.gallatinsystems.surveyal.dao.SurveyedLocaleDao;
import com.gallatinsystems.surveyal.domain.SurveyedLocale;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.akvo.flow.api.app.DataPointUtil;
import org.akvo.flow.api.app.SurveyedLocaleRequest;
import org.akvo.flow.api.app.SurveyedLocaleResponse;
import org.akvo.flow.util.FlowJsonObjectWriter;
import org.waterforpeople.mapping.app.web.dto.SurveyedLocaleDto;

public class SurveyedLocaleServlet
extends AbstractRestApiServlet {
    private static final long serialVersionUID = 8748650927754433019L;
    private SurveyedLocaleDao surveyedLocaleDao;
    private static final Integer SL_PAGE_SIZE = 30;

    public SurveyedLocaleServlet() {
        this.setMode("JSON");
        this.surveyedLocaleDao = new SurveyedLocaleDao();
    }

    @Override
    protected RestRequest convertRequest() throws Exception {
        HttpServletRequest req = this.getRequest();
        SurveyedLocaleRequest restRequest = new SurveyedLocaleRequest();
        restRequest.populateFromHttpRequest(req);
        return restRequest;
    }

    @Override
    protected RestResponse handleRequest(RestRequest req) throws Exception {
        SurveyedLocaleRequest slReq = (SurveyedLocaleRequest)req;
        if (slReq.getSurveyGroupId() != null) {
            DeviceSurveyJobQueueDAO dsjqDAO = new DeviceSurveyJobQueueDAO();
            SurveyDAO surveyDao = new SurveyDAO();
            List<DeviceSurveyJobQueue> deviceSurveyJobQueues = dsjqDAO.get(slReq.getPhoneNumber(), slReq.getImei(), slReq.getAndroidId());
            for (DeviceSurveyJobQueue dsjq : deviceSurveyJobQueues) {
                Survey s = surveyDao.getById(dsjq.getSurveyID());
                if (s == null || s.getSurveyGroupId().longValue() != slReq.getSurveyGroupId().longValue()) continue;
                List<SurveyedLocale> slList = this.surveyedLocaleDao.listLocalesBySurveyGroupAndUpdateDate(slReq.getSurveyGroupId(), slReq.getLastUpdateTime(), SL_PAGE_SIZE);
                return this.convertToResponse(slList, slReq.getSurveyGroupId());
            }
        }
        RestResponse res = new RestResponse();
        res.setCode(String.valueOf(403));
        res.setMessage("Invalid assignment");
        return res;
    }

    private SurveyedLocaleResponse convertToResponse(List<SurveyedLocale> slList, Long surveyId) {
        SurveyedLocaleResponse resp = new SurveyedLocaleResponse();
        if (slList == null) {
            resp.setCode(String.valueOf(500));
            resp.setMessage("Internal Server Error");
            return resp;
        }
        resp.setCode(String.valueOf(200));
        resp.setResultCount(slList.size());
        DataPointUtil dpu = new DataPointUtil();
        List<SurveyedLocaleDto> dtoList = dpu.getSurveyedLocaleDtosList(slList, surveyId);
        resp.setSurveyedLocaleData(dtoList);
        return resp;
    }

    @Override
    protected void writeOkResponse(RestResponse resp) throws Exception {
        int sc;
        try {
            sc = Integer.valueOf(resp.getCode());
        }
        catch (NumberFormatException ignored) {
            sc = 500;
        }
        this.getResponse().setStatus(sc);
        if (sc == 200) {
            FlowJsonObjectWriter writer = new FlowJsonObjectWriter();
            ServletOutputStream stream = this.getResponse().getOutputStream();
            writer.writeValue((OutputStream)stream, resp);
            PrintWriter endwriter = new PrintWriter((OutputStream)stream);
            endwriter.println();
        } else {
            this.getResponse().getWriter().println(resp.getMessage());
        }
    }
}

